/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.junit;

import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.tasks.junit.JUnitParser;
import hudson.tasks.junit.Messages;
import hudson.tasks.junit.TestDataPublisher;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.test.TestResultProjectAction;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.sf.json.JSONObject;
import org.apache.tools.ant.DirectoryScanner;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitResultArchiver
extends Recorder {
    private final String testResults;
    private final boolean keepLongStdio;
    private final DescribableList<TestDataPublisher, Descriptor<TestDataPublisher>> testDataPublishers;
    private final Double healthScaleFactor;
    private static final long serialVersionUID = 1L;

    @Deprecated
    public JUnitResultArchiver(String testResults) {
        this(testResults, false, null);
    }

    @Deprecated
    public JUnitResultArchiver(String testResults, DescribableList<TestDataPublisher, Descriptor<TestDataPublisher>> testDataPublishers) {
        this(testResults, false, testDataPublishers);
    }

    @Deprecated
    public JUnitResultArchiver(String testResults, boolean keepLongStdio, DescribableList<TestDataPublisher, Descriptor<TestDataPublisher>> testDataPublishers) {
        this(testResults, keepLongStdio, testDataPublishers, 1.0);
    }

    @DataBoundConstructor
    public JUnitResultArchiver(String testResults, boolean keepLongStdio, DescribableList<TestDataPublisher, Descriptor<TestDataPublisher>> testDataPublishers, double healthScaleFactor) {
        this.testResults = testResults;
        this.keepLongStdio = keepLongStdio;
        this.testDataPublishers = testDataPublishers;
        this.healthScaleFactor = Math.max(0.0, healthScaleFactor);
    }

    protected TestResult parse(String expandedTestResults, AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        return new JUnitParser(this.isKeepLongStdio()).parse(expandedTestResults, build, launcher, (TaskListener)listener);
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        TestResultAction action;
        listener.getLogger().println(Messages.JUnitResultArchiver_Recording());
        String testResults = build.getEnvironment((TaskListener)listener).expand(this.testResults);
        try {
            TestResult result = this.parse(testResults, build, launcher, listener);
            try {
                action = new TestResultAction(build, result, listener);
            }
            catch (NullPointerException npe) {
                throw new AbortException(Messages.JUnitResultArchiver_BadXML(testResults));
            }
            action.setHealthScaleFactor(this.getHealthScaleFactor());
            result.freeze(action);
            if (result.isEmpty()) {
                throw new AbortException(Messages.JUnitResultArchiver_ResultIsEmpty());
            }
            ArrayList<TestResultAction.Data> data = new ArrayList<TestResultAction.Data>();
            if (this.testDataPublishers != null) {
                for (TestDataPublisher tdp : this.testDataPublishers) {
                    TestResultAction.Data d = tdp.getTestData(build, launcher, listener, result);
                    if (d == null) continue;
                    data.add(d);
                }
            }
            action.setData(data);
        }
        catch (AbortException e) {
            if (build.getResult() == Result.FAILURE) {
                return true;
            }
            listener.getLogger().println(e.getMessage());
            build.setResult(Result.FAILURE);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace(listener.error("Failed to archive test reports"));
            build.setResult(Result.FAILURE);
            return true;
        }
        build.addAction((Action)action);
        if (action.getResult().getFailCount() > 0) {
            build.setResult(Result.UNSTABLE);
        }
        return true;
    }

    protected TestResult parseResult(DirectoryScanner ds, long buildTime) throws IOException {
        return new TestResult(buildTime, ds);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public String getTestResults() {
        return this.testResults;
    }

    public double getHealthScaleFactor() {
        return this.healthScaleFactor == null ? 1.0 : this.healthScaleFactor;
    }

    public DescribableList<TestDataPublisher, Descriptor<TestDataPublisher>> getTestDataPublishers() {
        return this.testDataPublishers;
    }

    public Collection<Action> getProjectActions(AbstractProject<?, ?> project) {
        return Collections.singleton(new TestResultProjectAction(project));
    }

    public boolean isKeepLongStdio() {
        return this.keepLongStdio;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return Messages.JUnitResultArchiver_DisplayName();
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String testResults = formData.getString("testResults");
            boolean keepLongStdio = formData.getBoolean("keepLongStdio");
            DescribableList testDataPublishers = new DescribableList(Saveable.NOOP);
            try {
                testDataPublishers.rebuild(req, formData, TestDataPublisher.all());
            }
            catch (IOException e) {
                throw new Descriptor.FormException((Throwable)e, null);
            }
            return new JUnitResultArchiver(testResults, keepLongStdio, (DescribableList<TestDataPublisher, Descriptor<TestDataPublisher>>)testDataPublishers);
        }

        public FormValidation doCheckTestResults(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException {
            return FilePath.validateFileMask((FilePath)project.getSomeWorkspace(), (String)value);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public FormValidation doCheckHealthScaleFactor(@QueryParameter double value) {
            if (value < 1.0E-7) {
                return FormValidation.warning((String)"Test health reporting disabled");
            }
            return FormValidation.ok((String)Messages.JUnitResultArchiver_HealthScaleFactorAnalysis(1, (int)(100.0 - Math.max(0.0, Math.min(100.0, 1.0 * value))), 5, (int)(100.0 - Math.max(0.0, Math.min(100.0, 5.0 * value)))));
        }
    }
}

