/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.junit;

import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.tasks.junit.Messages;
import hudson.tasks.junit.TestResult;
import hudson.tasks.test.TestResultParser;
import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;

@Extension
public class JUnitParser
extends TestResultParser {
    private final boolean keepLongStdio;

    @Deprecated
    public JUnitParser() {
        this(false);
    }

    public JUnitParser(boolean keepLongStdio) {
        this.keepLongStdio = keepLongStdio;
    }

    public String getDisplayName() {
        return Messages.JUnitParser_DisplayName();
    }

    public String getTestResultLocationMessage() {
        return Messages.JUnitParser_TestResultLocationMessage();
    }

    public TestResult parse(String testResultLocations, AbstractBuild build, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        long buildTime = build.getTimestamp().getTimeInMillis();
        long timeOnMaster = System.currentTimeMillis();
        FilePath workspace = build.getWorkspace();
        if (workspace == null) {
            throw new AbortException(Messages.JUnitParser_no_workspace_found(build));
        }
        return (TestResult)workspace.act((FilePath.FileCallable)new ParseResultCallable(testResultLocations, buildTime, timeOnMaster, this.keepLongStdio));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ParseResultCallable
    implements FilePath.FileCallable<TestResult> {
        private final long buildTime;
        private final String testResults;
        private final long nowMaster;
        private final boolean keepLongStdio;

        private ParseResultCallable(String testResults, long buildTime, long nowMaster, boolean keepLongStdio) {
            this.buildTime = buildTime;
            this.testResults = testResults;
            this.nowMaster = nowMaster;
            this.keepLongStdio = keepLongStdio;
        }

        public TestResult invoke(File ws, VirtualChannel channel) throws IOException {
            long nowSlave = System.currentTimeMillis();
            FileSet fs = Util.createFileSet((File)ws, (String)this.testResults);
            DirectoryScanner ds = fs.getDirectoryScanner();
            String[] files = ds.getIncludedFiles();
            if (files.length == 0) {
                throw new AbortException(Messages.JUnitResultArchiver_NoTestReportFound());
            }
            TestResult result = new TestResult(this.buildTime + (nowSlave - this.nowMaster), ds, this.keepLongStdio);
            result.tally();
            return result;
        }
    }
}

