/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.junit;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.tasks.junit.TestObject;
import hudson.tasks.test.TestResult;
import hudson.util.ChartUtil;
import hudson.util.ColorPalette;
import hudson.util.DataSetBuilder;
import hudson.util.Graph;
import hudson.util.ShiftedCategoryAxis;
import hudson.util.StackedAreaRenderer2;
import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleInsets;
import org.kohsuke.stapler.Stapler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class History {
    private final hudson.tasks.test.TestObject testObject;

    public History(hudson.tasks.test.TestObject testObject) {
        this.testObject = testObject;
    }

    public hudson.tasks.test.TestObject getTestObject() {
        return this.testObject;
    }

    public boolean historyAvailable() {
        return ((AbstractProject)this.testObject.getOwner().getParent()).getBuilds().size() > 1;
    }

    public List<TestResult> getList(int start, int end) {
        ArrayList<TestResult> list = new ArrayList<TestResult>();
        end = Math.min(end, ((AbstractProject)this.testObject.getOwner().getParent()).getBuilds().size());
        for (AbstractBuild b : ((AbstractProject)this.testObject.getOwner().getParent()).getBuilds().subList(start, end)) {
            TestObject o;
            if (b.isBuilding() || (o = this.testObject.getResultInBuild(b)) == null) continue;
            list.add((TestResult)o);
        }
        return list;
    }

    public List<TestResult> getList() {
        return this.getList(0, ((AbstractProject)this.testObject.getOwner().getParent()).getBuilds().size());
    }

    public Graph getDurationGraph() {
        return new GraphImpl("seconds"){

            @Override
            protected DataSetBuilder<String, ChartLabel> createDataSet() {
                List<TestResult> list;
                DataSetBuilder data = new DataSetBuilder();
                try {
                    list = History.this.getList(Integer.parseInt(Stapler.getCurrentRequest().getParameter("start")), Integer.parseInt(Stapler.getCurrentRequest().getParameter("end")));
                }
                catch (NumberFormatException e) {
                    list = History.this.getList();
                }
                for (TestResult o : list) {
                    data.add((Number)((double)o.getDuration() / 1000.0), (Comparable)((Object)""), (Comparable)new ChartLabel(o){

                        public Color getColor() {
                            if (this.o.getFailCount() > 0) {
                                return ColorPalette.RED;
                            }
                            if (this.o.getSkipCount() > 0) {
                                return ColorPalette.YELLOW;
                            }
                            return ColorPalette.BLUE;
                        }
                    });
                }
                return data;
            }
        };
    }

    public Graph getCountGraph() {
        return new GraphImpl(""){

            @Override
            protected DataSetBuilder<String, ChartLabel> createDataSet() {
                List<TestResult> list;
                DataSetBuilder data = new DataSetBuilder();
                try {
                    list = History.this.getList(Integer.parseInt(Stapler.getCurrentRequest().getParameter("start")), Integer.parseInt(Stapler.getCurrentRequest().getParameter("end")));
                }
                catch (NumberFormatException e) {
                    list = History.this.getList();
                }
                for (TestResult o : list) {
                    data.add((Number)o.getPassCount(), (Comparable)((Object)"2Passed"), (Comparable)new ChartLabel(o));
                    data.add((Number)o.getFailCount(), (Comparable)((Object)"1Failed"), (Comparable)new ChartLabel(o));
                    data.add((Number)o.getSkipCount(), (Comparable)((Object)"0Skipped"), (Comparable)new ChartLabel(o));
                }
                return data;
            }
        };
    }

    public static int asInt(String s, int defalutValue) {
        if (s == null) {
            return defalutValue;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return defalutValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ChartLabel
    implements Comparable<ChartLabel> {
        TestResult o;
        String url;

        public ChartLabel(TestResult o) {
            this.o = o;
            this.url = null;
        }

        public String getUrl() {
            if (this.url == null) {
                this.generateUrl();
            }
            return this.url;
        }

        private void generateUrl() {
            AbstractBuild<?, ?> build = this.o.getOwner();
            String buildLink = build.getUrl();
            String actionUrl = this.o.getTestResultAction().getUrlName();
            this.url = Jenkins.getInstance().getRootUrl() + buildLink + actionUrl + this.o.getUrl();
        }

        @Override
        public int compareTo(ChartLabel that) {
            return this.o.getOwner().number - that.o.getOwner().number;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ChartLabel)) {
                return false;
            }
            ChartLabel that = (ChartLabel)o;
            return this.o == that.o;
        }

        public Color getColor() {
            return null;
        }

        public int hashCode() {
            return this.o.hashCode();
        }

        public String toString() {
            String l = this.o.getOwner().getDisplayName();
            String s = this.o.getOwner().getBuiltOnStr();
            if (s != null) {
                l = l + ' ' + s;
            }
            return l;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class GraphImpl
    extends Graph {
        private final String yLabel;

        protected GraphImpl(String yLabel) {
            super(-1L, 600, 300);
            this.yLabel = yLabel;
        }

        protected abstract DataSetBuilder<String, ChartLabel> createDataSet();

        protected JFreeChart createGraph() {
            final CategoryDataset dataset = this.createDataSet().build();
            JFreeChart chart = ChartFactory.createStackedAreaChart(null, null, (String)this.yLabel, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
            chart.setBackgroundPaint((Paint)Color.white);
            CategoryPlot plot = chart.getCategoryPlot();
            plot.setBackgroundPaint((Paint)Color.WHITE);
            plot.setOutlinePaint(null);
            plot.setForegroundAlpha(0.8f);
            plot.setRangeGridlinesVisible(true);
            plot.setRangeGridlinePaint((Paint)Color.black);
            ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
            plot.setDomainAxis((CategoryAxis)domainAxis);
            domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
            domainAxis.setLowerMargin(0.0);
            domainAxis.setUpperMargin(0.0);
            domainAxis.setCategoryMargin(0.0);
            NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
            ChartUtil.adjustChebyshev((CategoryDataset)dataset, (NumberAxis)rangeAxis);
            rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
            rangeAxis.setAutoRange(true);
            StackedAreaRenderer2 ar = new StackedAreaRenderer2(){

                public Paint getItemPaint(int row, int column) {
                    ChartLabel key = (ChartLabel)dataset.getColumnKey(column);
                    if (key.getColor() != null) {
                        return key.getColor();
                    }
                    return super.getItemPaint(row, column);
                }

                public String generateURL(CategoryDataset dataset2, int row, int column) {
                    ChartLabel label = (ChartLabel)dataset2.getColumnKey(column);
                    return label.getUrl();
                }

                public String generateToolTip(CategoryDataset dataset2, int row, int column) {
                    ChartLabel label = (ChartLabel)dataset2.getColumnKey(column);
                    return label.o.getOwner().getDisplayName() + " : " + label.o.getDurationString();
                }
            };
            plot.setRenderer((CategoryItemRenderer)ar);
            ar.setSeriesPaint(0, (Paint)ColorPalette.YELLOW);
            ar.setSeriesPaint(1, (Paint)ColorPalette.RED);
            ar.setSeriesPaint(2, (Paint)ColorPalette.BLUE);
            plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
            return chart;
        }
    }
}

