/*
 * Decompiled with CFR 0.152.
 */
package join;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.Publisher;
import hudson.util.DescribableList;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import join.JoinTrigger;

public class JoinAction
implements Action {
    private List<String> pendingDownstreamProjects = new LinkedList<String>();
    private List<String> completedDownstreamProjects;
    private List<String> consideredBuilds;
    private transient String joinProjects;
    private DescribableList<Publisher, Descriptor<Publisher>> joinPublishers;
    private Result resultThreshold;
    private Result overallResult;

    public JoinAction(JoinTrigger joinTrigger, List<AbstractProject<?, ?>> downstream) {
        for (AbstractProject<?, ?> project : downstream) {
            if (project.isDisabled()) continue;
            this.pendingDownstreamProjects.add(project.getFullName());
        }
        this.joinProjects = joinTrigger.getJoinProjectsValue();
        this.joinPublishers = joinTrigger.getJoinPublishers();
        this.resultThreshold = joinTrigger.getResultThreshold();
        this.completedDownstreamProjects = new LinkedList<String>();
        this.consideredBuilds = new LinkedList<String>();
        this.overallResult = Result.SUCCESS;
    }

    public String getDisplayName() {
        return null;
    }

    public String getIconFileName() {
        return null;
    }

    public String getUrlName() {
        return "join";
    }

    public synchronized boolean downstreamFinished(AbstractBuild<?, ?> upstreamBuild, AbstractBuild<?, ?> finishedBuild, TaskListener listener) {
        if (!this.consideredBuilds.contains(finishedBuild.toString())) {
            this.consideredBuilds.add(finishedBuild.toString());
            String finishedBuildProjectName = finishedBuild.getProject().getFullName();
            if (this.pendingDownstreamProjects.remove(finishedBuildProjectName)) {
                this.overallResult = this.overallResult.combine(finishedBuild.getResult());
                this.completedDownstreamProjects.add(finishedBuildProjectName);
                this.checkPendingDownstream(upstreamBuild, listener);
            } else {
                listener.getLogger().println("[Join] Pending does not contain " + finishedBuildProjectName);
            }
            try {
                upstreamBuild.save();
            }
            catch (IOException e) {
                listener.getLogger().printf("Unable to save upstream build.", new Object[0]);
            }
        }
        return this.pendingDownstreamProjects.isEmpty();
    }

    public Result getOverallResult() {
        return this.overallResult;
    }

    public synchronized void checkPendingDownstream(AbstractBuild<?, ?> owner, TaskListener listener) {
        if (this.pendingDownstreamProjects.isEmpty()) {
            listener.getLogger().println("All downstream projects complete!");
            if (this.overallResult.isWorseThan(this.resultThreshold)) {
                listener.getLogger().println("Minimum result threshold not met for join project");
            } else {
                Launcher launcher = null;
                for (Publisher pub : this.joinPublishers) {
                    try {
                        pub.perform(owner, launcher, (BuildListener)listener);
                    }
                    catch (InterruptedException e) {
                        listener.getLogger().print(e.toString());
                    }
                    catch (IOException e) {
                        listener.getLogger().print(e.toString());
                    }
                }
            }
        } else {
            listener.getLogger().println("Project " + owner.getProject().getName() + " still waiting for " + this.pendingDownstreamProjects.toString() + " builds to complete");
        }
    }

    public class JoinCause
    extends Cause.UpstreamCause {
        public JoinCause(Run<?, ?> arg0) {
            super(arg0);
        }
    }
}

