/*
 * Decompiled with CFR 0.152.
 */
package join;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.Plugin;
import hudson.Util;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.AutoCompletionCandidates;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.DependecyDeclarer;
import hudson.model.DependencyGraph;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Project;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.model.listeners.ItemListener;
import hudson.model.listeners.RunListener;
import hudson.plugins.downstream_ext.DownstreamTrigger;
import hudson.plugins.parameterizedtrigger.BuildTrigger;
import hudson.plugins.parameterizedtrigger.BuildTriggerConfig;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import join.Items;
import join.JoinAction;
import join.JoinTriggerDependency;
import join.ParameterizedJoinDependency;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class JoinTrigger
extends Recorder
implements DependecyDeclarer,
MatrixAggregatable {
    private static final Logger LOGGER = Logger.getLogger(JoinTrigger.class.getName());
    private String joinProjects;
    private DescribableList<Publisher, Descriptor<Publisher>> joinPublishers = new DescribableList(Saveable.NOOP);
    private boolean evenIfDownstreamUnstable;

    public JoinTrigger() {
        this((DescribableList<Publisher, Descriptor<Publisher>>)new DescribableList(Saveable.NOOP), "", false);
    }

    public JoinTrigger(DescribableList<Publisher, Descriptor<Publisher>> publishers, String string, boolean b) {
        this.joinProjects = string;
        this.evenIfDownstreamUnstable = b;
        this.joinPublishers = publishers;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        for (Publisher bs : this.joinPublishers) {
            if (bs.prebuild(build, listener)) continue;
            return false;
        }
        return true;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        hudson.tasks.BuildTrigger buildTrigger = (hudson.tasks.BuildTrigger)build.getProject().getPublishersList().get(hudson.tasks.BuildTrigger.class);
        JoinAction joinAction = new JoinAction(this, this.getAllDownstream(build.getProject(), build.getEnvironment((TaskListener)listener)));
        build.addAction((Action)joinAction);
        joinAction.checkPendingDownstream(build, (TaskListener)listener);
        return true;
    }

    public void buildDependencyGraph(AbstractProject owner, DependencyGraph graph) {
        List<AbstractProject<?, ?>> downstreamProjects = this.getAllDownstream(owner, null);
        if (downstreamProjects.isEmpty()) {
            downstreamProjects.add(owner);
        }
        for (AbstractProject<?, ?> downstreamProject : downstreamProjects) {
            for (BuildTriggerConfig config : this.getBuildTriggerConfigs(this.joinPublishers)) {
                for (AbstractProject joinProject : config.getProjectList(owner.getParent(), null)) {
                    ParameterizedJoinDependency dependency = new ParameterizedJoinDependency(downstreamProject, joinProject, owner, config);
                    graph.addDependency((DependencyGraph.Dependency)dependency);
                }
            }
            for (AbstractProject joinProject : this.getJoinProjects(owner.getParent())) {
                JoinTriggerDependency dependency = new JoinTriggerDependency(downstreamProject, joinProject, owner, this.evenIfDownstreamUnstable);
                graph.addDependency((DependencyGraph.Dependency)dependency);
            }
        }
    }

    private List<String> tryGetParameterizedDownstreamNames(AbstractBuild<?, ?> build, BuildListener listener) {
        ArrayList<String> ret = new ArrayList<String>();
        EnvVars env = null;
        try {
            env = build.getEnvironment((TaskListener)listener);
        }
        catch (Exception e) {
            listener.getLogger().print(e);
        }
        for (AbstractProject<?, ?> project : this.getParameterizedDownstreamProjects(build.getProject().getParent(), (DescribableList<Publisher, Descriptor<Publisher>>)build.getProject().getPublishersList(), env)) {
            if (project.isDisabled()) continue;
            ret.add(project.getName());
        }
        return ret;
    }

    private List<AbstractProject<?, ?>> getParameterizedDownstreamProjects(ItemGroup context, DescribableList<Publisher, Descriptor<Publisher>> publishers, EnvVars env) {
        ArrayList ret = new ArrayList();
        for (BuildTriggerConfig config : this.getBuildTriggerConfigs(publishers)) {
            for (AbstractProject project : config.getProjectList(context, env)) {
                ret.add(project);
            }
        }
        return ret;
    }

    private List<BuildTriggerConfig> getBuildTriggerConfigs(DescribableList<Publisher, Descriptor<Publisher>> publishers) {
        BuildTrigger buildTrigger;
        ArrayList<BuildTriggerConfig> ret = new ArrayList<BuildTriggerConfig>();
        Plugin parameterizedTrigger = Hudson.getInstance().getPlugin("parameterized-trigger");
        if (parameterizedTrigger != null && (buildTrigger = (BuildTrigger)publishers.get(BuildTrigger.class)) != null) {
            for (BuildTriggerConfig config : buildTrigger.getConfigs()) {
                ret.add(config);
            }
        }
        return ret;
    }

    private List<AbstractProject<?, ?>> getDownstreamExtDownstream(ItemGroup context, DescribableList<Publisher, Descriptor<Publisher>> publishers) {
        DownstreamTrigger buildTrigger;
        ArrayList ret = new ArrayList();
        Plugin extDownstream = Hudson.getInstance().getPlugin("downstream-ext");
        if (extDownstream != null && (buildTrigger = (DownstreamTrigger)publishers.get(DownstreamTrigger.class)) != null) {
            for (AbstractProject project : buildTrigger.getChildProjects(context)) {
                ret.add(project);
            }
        }
        return ret;
    }

    static boolean canDeclare(AbstractProject<?, ?> owner) {
        return true;
    }

    public List<AbstractProject<?, ?>> getAllDownstream(AbstractProject<?, ?> project, EnvVars env) {
        List<AbstractProject<?, ?>> downstream = this.getBuildTriggerDownstream(project);
        downstream.addAll(this.getParameterizedDownstreamProjects(project.getParent(), (DescribableList<Publisher, Descriptor<Publisher>>)project.getPublishersList(), env));
        downstream.addAll(this.getDownstreamExtDownstream(project.getParent(), (DescribableList<Publisher, Descriptor<Publisher>>)project.getPublishersList()));
        return downstream;
    }

    public List<AbstractProject<?, ?>> getBuildTriggerDownstream(AbstractProject<?, ?> project) {
        ArrayList ret = new ArrayList();
        hudson.tasks.BuildTrigger buildTrigger = (hudson.tasks.BuildTrigger)project.getPublishersList().get(hudson.tasks.BuildTrigger.class);
        if (buildTrigger != null) {
            for (AbstractProject childProject : buildTrigger.getChildProjects(project.getParent())) {
                ret.add(childProject);
            }
        }
        return ret;
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        return new MatrixAggregator(build, launcher, listener){

            public boolean endBuild() throws InterruptedException, IOException {
                return JoinTrigger.this.perform((AbstractBuild<?, ?>)this.build, this.launcher, this.listener);
            }
        };
    }

    public boolean onJobRenamed(ItemGroup parent, String oldName, String newName) {
        String newJoin = Items.rename(oldName, newName, this.joinProjects, parent);
        boolean updated = !this.joinProjects.equals(newJoin);
        this.joinProjects = newJoin;
        return updated;
    }

    public boolean usePostBuildActions() {
        return this.containsAnyDescriptor(DescriptorImpl.DESCRIPTOR.getApplicableDescriptors());
    }

    private boolean containsAnyDescriptor(List<Descriptor<Publisher>> applicableDescriptors) {
        for (Descriptor<Publisher> descriptor : applicableDescriptors) {
            if (!this.joinPublishers.contains(descriptor)) continue;
            return true;
        }
        return false;
    }

    public String getJoinProjectsValue() {
        return this.joinProjects;
    }

    public List<AbstractProject> getJoinProjects() {
        return this.getJoinProjects(null);
    }

    public List<AbstractProject> getJoinProjects(ItemGroup context) {
        List<Object> list = this.joinProjects == null ? new ArrayList<AbstractProject>() : hudson.model.Items.fromNameList((ItemGroup)context, (String)this.joinProjects, AbstractProject.class);
        return list;
    }

    public DescribableList<Publisher, Descriptor<Publisher>> getJoinPublishers() {
        return this.joinPublishers;
    }

    public boolean getEvenIfDownstreamUnstable() {
        return this.evenIfDownstreamUnstable;
    }

    private Object readResolve() {
        if (this.joinPublishers == null) {
            this.joinPublishers = new DescribableList(Saveable.NOOP);
        }
        return this;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        @Extension
        public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

        public String getDisplayName() {
            return "Join Trigger";
        }

        public String getHelpFile() {
            return "/plugin/join/help/joinTrigger.html";
        }

        public JoinTrigger newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            JSONObject joinPublishers;
            LOGGER.finer(formData.toString());
            ArrayList<Publisher> newList = new ArrayList<Publisher>();
            JSONObject postbuild = formData.optJSONObject("postbuildactions");
            if (postbuild != null && (joinPublishers = postbuild.optJSONObject("joinPublishers")) != null) {
                this.extractAndAddPublisher(joinPublishers, this.getApplicableDescriptors(), newList, req);
            }
            DescribableList publishers = new DescribableList(Saveable.NOOP, newList);
            LOGGER.finer("Parsed " + publishers.size() + " publishers");
            String joinProjectsValue = this.reformatJoinProjectsValue(formData.getString("joinProjectsValue"));
            return new JoinTrigger((DescribableList<Publisher, Descriptor<Publisher>>)publishers, joinProjectsValue, formData.has("evenIfDownstreamUnstable") && formData.getBoolean("evenIfDownstreamUnstable"));
        }

        public String reformatJoinProjectsValue(String joinProjectsValue) {
            String[] tokens = Util.fixNull((String)joinProjectsValue).split(",");
            ArrayList<String> verified = new ArrayList<String>();
            for (String token : tokens) {
                String projectName = token.trim();
                if (!StringUtils.isNotEmpty((String)projectName)) continue;
                verified.add(projectName);
            }
            return Util.join(verified, (String)", ");
        }

        private void extractAndAddPublisher(JSONObject json, List<Descriptor<Publisher>> applicableDescriptors, List<Publisher> newList, StaplerRequest req) throws Descriptor.FormException {
            for (Descriptor<Publisher> d : applicableDescriptors) {
                String name = d.getJsonSafeClassName();
                if (!json.has(name)) continue;
                Publisher instance = (Publisher)d.newInstance(req, json.getJSONObject(name));
                newList.add(instance);
            }
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public boolean showEvenIfUnstableOption(Class<? extends AbstractProject> jobType) {
            return !jobType.getName().contains("PromotionProcess");
        }

        public List<Descriptor<Publisher>> getApplicableDescriptors() {
            ArrayList<Descriptor<Publisher>> list = new ArrayList<Descriptor<Publisher>>();
            Plugin parameterizedTrigger = Hudson.getInstance().getPlugin("parameterized-trigger");
            if (parameterizedTrigger != null) {
                list.add((Descriptor<Publisher>)Hudson.getInstance().getDescriptorByType(BuildTrigger.DescriptorImpl.class));
            }
            return list;
        }

        public FormValidation doCheckJoinProjectsValue(@AncestorInPath AbstractProject context, @QueryParameter String value) {
            String[] tokens;
            for (String token : tokens = Util.fixNull((String)value).split(",")) {
                String projectName = token.trim();
                if (!StringUtils.isNotEmpty((String)projectName)) continue;
                Item item = Hudson.getInstance().getItem(projectName, (Item)context, Item.class);
                if (item == null) {
                    return FormValidation.error((String)("No such project: " + projectName));
                }
                if (item instanceof AbstractProject) continue;
                return FormValidation.error((String)("Not buildable: " + projectName));
            }
            return FormValidation.ok();
        }

        public AutoCompletionCandidates doAutoCompleteJoinProjectsValue(@QueryParameter String value) {
            String prefix = Util.fixNull((String)value);
            List projects = Hudson.getInstance().getItems(AbstractProject.class);
            ArrayList<String> candidates = new ArrayList<String>();
            ArrayList<String> lowPrioCandidates = new ArrayList<String>();
            for (AbstractProject project : projects) {
                if (project.getFullName().startsWith(prefix)) {
                    candidates.add(project.getFullName());
                    continue;
                }
                if (!project.getFullName().toLowerCase().startsWith(prefix.toLowerCase())) continue;
                lowPrioCandidates.add(project.getFullName());
            }
            AutoCompletionCandidates autoCand = new AutoCompletionCandidates();
            autoCand.add(candidates.toArray(new String[candidates.size()]));
            autoCand.add(lowPrioCandidates.toArray(new String[candidates.size()]));
            return autoCand;
        }

        @Extension
        public static class ItemListenerImpl
        extends ItemListener {
            public void onRenamed(Item item, String oldName, String newName) {
                for (Project p : Hudson.getInstance().getProjects()) {
                    hudson.tasks.BuildTrigger t = (hudson.tasks.BuildTrigger)p.getPublishersList().get(hudson.tasks.BuildTrigger.class);
                    if (t == null || !t.onJobRenamed(oldName, newName)) continue;
                    try {
                        p.save();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Failed to persist project setting during rename from " + oldName + " to " + newName, e);
                    }
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @Extension
        public static class RunListenerImpl
        extends RunListener<Run> {
            public RunListenerImpl() {
                super(Run.class);
            }

            public void onCompleted(Run run, TaskListener listener) {
                if (!(run instanceof AbstractBuild)) {
                    return;
                }
                AbstractBuild abstractBuild = (AbstractBuild)run;
                listener.getLogger().println("Notifying upstream projects of job completion");
                CauseAction ca = (CauseAction)run.getAction(CauseAction.class);
                if (ca == null) {
                    listener.getLogger().println("Join notifier requires a CauseAction");
                    return;
                }
                for (Cause c : ca.getCauses()) {
                    if (!(c instanceof Cause.UpstreamCause) || c instanceof JoinAction.JoinCause) continue;
                    Cause.UpstreamCause uc = (Cause.UpstreamCause)c;
                    this.notifyJob(abstractBuild, listener, uc.getUpstreamProject(), uc.getUpstreamBuild());
                }
            }

            private void notifyJob(AbstractBuild<?, ?> abstractBuild, TaskListener listener, String upstreamProjectName, int upstreamJobNumber) {
                List upstreamList = hudson.model.Items.fromNameList((ItemGroup)abstractBuild.getProject().getParent(), (String)upstreamProjectName, AbstractProject.class);
                if (upstreamList.size() != 1) {
                    listener.getLogger().println("Join notifier cannot find upstream project: " + upstreamProjectName);
                    return;
                }
                AbstractProject upstreamProject = (AbstractProject)upstreamList.get(0);
                Run upstreamRun = upstreamProject.getBuildByNumber(upstreamJobNumber);
                if (upstreamRun == null) {
                    listener.getLogger().println("Join notifier cannot find upstream run: " + upstreamProjectName + " number " + upstreamJobNumber);
                    return;
                }
                if (!(upstreamRun instanceof AbstractBuild)) {
                    LOGGER.fine("Upstream run is not an AbstractBuild: " + upstreamProjectName + " number " + upstreamJobNumber);
                    return;
                }
                AbstractBuild upstreamBuild = (AbstractBuild)upstreamRun;
                JoinAction ja = (JoinAction)upstreamRun.getAction(JoinAction.class);
                if (ja == null) {
                    LOGGER.finer("Join notifier cannot find upstream JoinAction: " + upstreamProjectName + " number " + upstreamJobNumber);
                    return;
                }
                listener.getLogger().println("Notifying upstream of completion: " + upstreamProjectName + " #" + upstreamJobNumber);
                ja.downstreamFinished(upstreamBuild, abstractBuild, listener);
            }
        }
    }
}

