/*
 * Decompiled with CFR 0.152.
 */
package join;

import hudson.Extension;
import hudson.model.Item;
import hudson.model.Project;
import hudson.model.listeners.ItemListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import join.Items;
import join.JoinTrigger;

@Extension
public class JoinItemListener
extends ItemListener {
    private static final Logger LOGGER = Logger.getLogger(JoinItemListener.class.getName());

    public void onRenamed(Item item, String oldName, String newName) {
        String context = item.getParent().getFullName();
        if (context.length() > 0) {
            context = context + "/";
        }
        for (Project p : Jenkins.getInstance().getAllItems(Project.class)) {
            JoinTrigger t = (JoinTrigger)p.getPublishersList().get(JoinTrigger.class);
            if (t == null || !t.onJobRenamed(p.getParent(), Items.getCanonicalName(item.getParent(), oldName), Items.getCanonicalName(item.getParent(), newName))) continue;
            try {
                p.save();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to persist project setting during rename from " + oldName + " to " + newName, e);
            }
        }
    }
}

