/*
 * Decompiled with CFR 0.152.
 */
package join;

import hudson.model.ItemGroup;
import java.util.ArrayList;
import java.util.Stack;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;

public class Items {
    public static String getCanonicalName(ItemGroup context, String path) {
        return Items.getCanonicalName(context.getFullName(), path);
    }

    static String getCanonicalName(String context, String path) {
        int i;
        String[] c = context.split("/");
        String[] p = path.split("/");
        Stack<String> name = new Stack<String>();
        for (i = 0; i < c.length; ++i) {
            if (i == 0 && c[i].equals("")) continue;
            name.push(c[i]);
        }
        for (i = 0; i < p.length; ++i) {
            if (i == 0 && p[i].equals("")) {
                name.clear();
                continue;
            }
            if (p[i].equals("..")) {
                name.pop();
                continue;
            }
            if (p[i].equals(".")) continue;
            name.push(p[i]);
        }
        return StringUtils.join(name, (char)'/');
    }

    public static String rename(String oldFullName, String newFullName, String relativeNames, ItemGroup context) {
        StringTokenizer tokens = new StringTokenizer(relativeNames, ",");
        ArrayList<String> newValue = new ArrayList<String>();
        while (tokens.hasMoreTokens()) {
            String relativeName = tokens.nextToken().trim();
            String canonicalName = Items.getCanonicalName(context, relativeName);
            if (canonicalName.startsWith(oldFullName)) {
                String newCanonicalName = newFullName + canonicalName.substring(oldFullName.length());
                newValue.add(Items.rename(canonicalName, newCanonicalName, relativeName));
                continue;
            }
            newValue.add(relativeName);
        }
        return StringUtils.join(newValue, (String)",");
    }

    static String rename(String oldFullName, String newFullName, String relativeName) {
        String[] a = oldFullName.split("/");
        String[] n = newFullName.split("/");
        assert (a.length == n.length);
        Object[] r = relativeName.split("/");
        int j = a.length - 1;
        for (int i = r.length - 1; i >= 0; --i) {
            String part = r[i];
            if (part.equals("") && i == 0 || part.equals(".")) continue;
            if (part.equals("..")) {
                --j;
                continue;
            }
            if (!part.equals(a[j])) continue;
            r[i] = n[j];
            --j;
        }
        return StringUtils.join((Object[])r, (char)'/');
    }
}

