/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import hudson.Extension;
import hudson.XmlFile;
import hudson.model.AbstractBuild;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildBadgeAction;
import hudson.model.Hudson;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.plugins.jobConfigHistory.ConfigInfo;
import hudson.plugins.jobConfigHistory.ConfigInfoComparator;
import hudson.plugins.jobConfigHistory.HistoryDescr;
import hudson.plugins.jobConfigHistory.JobConfigHistory;
import hudson.plugins.jobConfigHistory.Messages;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class JobConfigBadgeAction
extends RunListener<AbstractBuild>
implements BuildBadgeAction {
    private static final Logger LOG = Logger.getLogger(JobConfigBadgeAction.class.getName());
    private String[] configDates;
    private AbstractBuild build;

    public JobConfigBadgeAction() {
    }

    public JobConfigBadgeAction(String[] configDates, AbstractBuild build) {
        super(AbstractBuild.class);
        this.configDates = (String[])configDates.clone();
        this.build = build;
    }

    public void onStarted(AbstractBuild build, TaskListener listener) {
        AbstractProject project = build.getProject();
        if (project.getNextBuildNumber() <= 2) {
            super.onStarted((Run)build, listener);
            return;
        }
        Date lastBuildDate = null;
        if (((AbstractBuild)project.getLastBuild()).getPreviousBuild() != null) {
            lastBuildDate = ((AbstractBuild)((AbstractBuild)project.getLastBuild()).getPreviousBuild()).getTime();
        }
        ArrayList<ConfigInfo> configs = new ArrayList<ConfigInfo>();
        File historyRootDir = ((JobConfigHistory)Hudson.getInstance().getPlugin(JobConfigHistory.class)).getHistoryDir(project.getConfigFile());
        if (historyRootDir.exists()) {
            try {
                for (File historyDir : historyRootDir.listFiles(JobConfigHistory.HISTORY_FILTER)) {
                    XmlFile historyXml = new XmlFile(new File(historyDir, "history.xml"));
                    HistoryDescr histDescr = (HistoryDescr)historyXml.read();
                    ConfigInfo config = ConfigInfo.create((AbstractItem)project, historyDir, histDescr);
                    configs.add(config);
                }
            }
            catch (IOException ex) {
                LOG.finest("Could not parse history files: " + ex);
            }
        }
        if (configs.size() > 1) {
            Collections.sort(configs, ConfigInfoComparator.INSTANCE);
            ConfigInfo lastChange = Collections.min(configs, ConfigInfoComparator.INSTANCE);
            Date lastConfigChange = this.parseDate(lastChange);
            if (lastBuildDate != null && lastConfigChange.after(lastBuildDate)) {
                String[] dates = new String[]{lastChange.getDate(), this.findLastRelevantConfigChangeDate(configs, lastBuildDate)};
                build.addAction((Action)new JobConfigBadgeAction(dates, build));
            }
        }
        super.onStarted((Run)build, listener);
    }

    private String findLastRelevantConfigChangeDate(ArrayList<ConfigInfo> configs, Date lastBuildDate) {
        for (int i = 1; i < configs.size(); ++i) {
            ConfigInfo oldConfigChange = configs.get(i);
            Date changeDate = this.parseDate(oldConfigChange);
            if (changeDate == null || !changeDate.before(lastBuildDate)) continue;
            return oldConfigChange.getDate();
        }
        return configs.get(1).getDate();
    }

    private Date parseDate(ConfigInfo config) {
        Date date = null;
        try {
            date = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").parse(config.getDate());
        }
        catch (ParseException ex) {
            LOG.finest("Could not parse Date: " + ex);
        }
        return date;
    }

    public boolean showBadge() {
        return ((JobConfigHistory)Hudson.getInstance().getPlugin(JobConfigHistory.class)).showBuildBadges(this.build.getProject());
    }

    public boolean oldConfigsExist() {
        JobConfigHistory plugin = (JobConfigHistory)Hudson.getInstance().getPlugin(JobConfigHistory.class);
        for (String timestamp : this.configDates) {
            String path = plugin.getJobHistoryRootDir() + "/" + this.build.getProject().getName() + "/" + timestamp;
            File historyDir = new File(path);
            if (historyDir.exists() && new File(historyDir, "config.xml").exists()) continue;
            return false;
        }
        return true;
    }

    public String createLink() {
        return Hudson.getInstance().getRootUrl() + this.build.getProject().getUrl() + "jobConfigHistory" + "/showDiffFiles?timestamp1=" + this.configDates[1] + "&timestamp2=" + this.configDates[0];
    }

    public String getTooltip() {
        return Messages.JobConfigBadgeAction_ToolTip();
    }

    public String getIcon() {
        return "/plugin/jobConfigHistory/img/buildbadge.png";
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "";
    }
}

