/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import hudson.XmlFile;
import hudson.model.Api;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.plugins.jobConfigHistory.ConfigInfo;
import hudson.plugins.jobConfigHistory.HistoryDescr;
import hudson.plugins.jobConfigHistory.JobConfigHistory;
import hudson.plugins.jobConfigHistory.JobConfigHistoryBaseAction;
import hudson.plugins.jobConfigHistory.Messages;
import hudson.plugins.jobConfigHistory.ParsedDateComparator;
import hudson.plugins.jobConfigHistory.PluginUtils;
import hudson.plugins.jobConfigHistory.SideBySideView;
import hudson.plugins.jobConfigHistory.XmlSyntaxChecker;
import hudson.security.AccessControlled;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=-1)
public class ComputerConfigHistoryAction
extends JobConfigHistoryBaseAction {
    private static final Logger LOG = Logger.getLogger(ComputerConfigHistoryAction.class.getName());
    private Slave slave;

    public ComputerConfigHistoryAction(Slave slave) {
        this.slave = slave;
    }

    @Override
    public final String getDisplayName() {
        return Messages.agentDisplayName();
    }

    @Override
    public String getUrlName() {
        return "jobConfigHistory";
    }

    public Slave getSlave() {
        return this.slave;
    }

    @Override
    protected AccessControlled getAccessControlledObject() {
        return this.slave;
    }

    @Override
    protected void checkConfigurePermission() {
        this.getAccessControlledObject().checkPermission(Computer.CONFIGURE);
    }

    @Override
    protected void checkDeleteEntryPermission() {
        this.getAccessControlledObject().checkPermission(JobConfigHistory.DELETEENTRY_PERMISSION);
    }

    @Override
    public boolean hasAdminPermission() {
        return this.getAccessControlledObject().hasPermission(Jenkins.ADMINISTER);
    }

    @Override
    public boolean hasDeleteEntryPermission() {
        return this.getAccessControlledObject().hasPermission(JobConfigHistory.DELETEENTRY_PERMISSION);
    }

    @Override
    public boolean hasConfigurePermission() {
        return this.getAccessControlledObject().hasPermission(Computer.CONFIGURE);
    }

    @Override
    public int getRevisionAmount() {
        LOG.log(Level.INFO, "Paging is not implemented for agents, yet!");
        return -1;
    }

    public final String getIconFileName() {
        if (!this.hasConfigurePermission()) {
            return null;
        }
        return "/plugin/jobConfigHistory/img/confighistory.png";
    }

    public final List<ConfigInfo> getSlaveConfigs() throws IOException {
        if (!this.hasConfigurePermission()) {
            return Collections.emptyList();
        }
        ArrayList<ConfigInfo> configs = new ArrayList<ConfigInfo>();
        ArrayList<HistoryDescr> values = new ArrayList<HistoryDescr>(this.getHistoryDao().getRevisions((Node)this.slave).values());
        for (HistoryDescr historyDescr : values) {
            String timestamp = historyDescr.getTimestamp();
            XmlFile oldRevision = this.getHistoryDao().getOldRevision((Node)this.slave, timestamp);
            if (oldRevision.getFile() != null) {
                configs.add(ConfigInfo.create(this.slave.getNodeName(), true, historyDescr, true));
                continue;
            }
            if (!"Deleted".equals(historyDescr.getOperation())) continue;
            configs.add(ConfigInfo.create(this.slave.getNodeName(), false, historyDescr, true));
        }
        Collections.sort(configs, ParsedDateComparator.DESCENDING);
        return configs;
    }

    @Exported(name="jobConfigHistory", visibility=1)
    public final List<ConfigInfo> getSlaveConfigsREST() throws IOException {
        return this.getSlaveConfigs();
    }

    public final String getTimestamp(int timestampNumber) {
        this.checkConfigurePermission();
        String timeStamp = this.getRequestParameter("timestamp" + timestampNumber);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        try {
            format.setLenient(false);
            format.parse(timeStamp);
            return timeStamp;
        }
        catch (ParseException e) {
            return null;
        }
    }

    public final String getUser(int timestampNumber) {
        this.checkConfigurePermission();
        return ((HistoryDescr)this.getHistoryDao().getRevisions((Node)this.slave).get(this.getTimestamp(timestampNumber))).getUser();
    }

    public final String getUserID(int timestamp) {
        this.checkConfigurePermission();
        return ((HistoryDescr)this.getHistoryDao().getRevisions((Node)this.slave).get(this.getTimestamp(timestamp))).getUserID();
    }

    public final String getOperation(int timestampNumber) {
        this.checkConfigurePermission();
        return ((HistoryDescr)this.getHistoryDao().getRevisions((Node)this.slave).get(this.getTimestamp(timestampNumber))).getOperation();
    }

    public final String getNextTimestamp(int timestampNumber) {
        this.checkConfigurePermission();
        String timestamp = this.getRequestParameter("timestamp" + timestampNumber);
        SortedMap<String, HistoryDescr> revisions = this.getHistoryDao().getRevisions((Node)this.slave);
        Iterator<Map.Entry<String, HistoryDescr>> itr = revisions.entrySet().iterator();
        while (itr.hasNext()) {
            if (!itr.next().getValue().getTimestamp().equals(timestamp) || !itr.hasNext()) continue;
            return itr.next().getValue().getTimestamp();
        }
        return timestamp;
    }

    public final String getPrevTimestamp(int timestampNumber) {
        this.checkConfigurePermission();
        String timestamp = this.getRequestParameter("timestamp" + timestampNumber);
        SortedMap<String, HistoryDescr> revisions = this.getHistoryDao().getRevisions((Node)this.slave);
        Iterator<Map.Entry<String, HistoryDescr>> itr = revisions.entrySet().iterator();
        String prevTimestamp = timestamp;
        while (itr.hasNext()) {
            String checkTimestamp = itr.next().getValue().getTimestamp();
            if (checkTimestamp.equals(timestamp)) {
                return prevTimestamp;
            }
            prevTimestamp = checkTimestamp;
        }
        return timestamp;
    }

    public final String getFile() throws IOException {
        this.checkConfigurePermission();
        String timestamp = this.getRequestParameter("timestamp");
        XmlFile xmlFile = this.getOldConfigXml(timestamp);
        return xmlFile.asString();
    }

    @Override
    public final List<SideBySideView.Line> getLines(boolean hideVersionDiffs) throws IOException {
        this.checkConfigurePermission();
        String timestamp1 = this.getRequestParameter("timestamp1");
        String timestamp2 = this.getRequestParameter("timestamp2");
        return this.getLines(this.getOldConfigXml(timestamp1), this.getOldConfigXml(timestamp2), hideVersionDiffs);
    }

    public XmlSyntaxChecker.Answer checkXmlSyntax(String timestamp) {
        return XmlSyntaxChecker.check(this.getOldConfigXml(timestamp).getFile());
    }

    private XmlFile getOldConfigXml(String timestamp) {
        this.checkConfigurePermission();
        XmlFile oldRevision = this.getHistoryDao().getOldRevision((Node)this.slave, timestamp);
        if (oldRevision.getFile() != null) {
            return oldRevision;
        }
        throw new IllegalArgumentException("Non existent timestamp " + timestamp);
    }

    public final void doRestore(StaplerRequest req, StaplerResponse rsp) throws IOException {
        this.checkConfigurePermission();
        String timestamp = req.getParameter("timestamp");
        XmlFile xmlFile = this.getHistoryDao().getOldRevision((Node)this.slave, timestamp);
        Slave newSlave = (Slave)Jenkins.XSTREAM2.fromXML(xmlFile.getFile());
        ArrayList<Slave> nodes = new ArrayList<Slave>();
        nodes.addAll(Jenkins.get().getNodes());
        nodes.remove(this.slave);
        nodes.add(newSlave);
        this.slave = newSlave;
        Jenkins.get().setNodes(nodes);
        try {
            rsp.sendRedirect(Jenkins.get().getRootUrl() + this.slave.toComputer().getUrl());
        }
        catch (NullPointerException e) {
            LOG.log(Level.WARNING, "Failed to redirect to agent url. ", e);
        }
    }

    public final void doForwardToRestoreQuestion(StaplerRequest req, StaplerResponse rsp) throws IOException {
        String timestamp = req.getParameter("timestamp");
        rsp.sendRedirect("restoreQuestion?timestamp=" + timestamp);
    }

    public final void doDeleteRevision(StaplerRequest req, StaplerResponse rsp) {
        this.checkDeleteEntryPermission();
        String timestamp = req.getParameter("timestamp");
        PluginUtils.getHistoryDao().deleteRevision((Node)this.getSlave(), timestamp);
    }

    public boolean revisionEqualsCurrent(String timestamp) {
        return PluginUtils.getHistoryDao().revisionEqualsCurrent(Jenkins.get().getNode(this.getSlave().getNodeName()), timestamp);
    }

    public final void doToggleShowHideVersionDiffs(StaplerRequest req, StaplerResponse rsp) throws IOException {
        String timestamp1 = req.getParameter("timestamp1");
        String timestamp2 = req.getParameter("timestamp2");
        String showVersionDiffs = Boolean.toString(!Boolean.parseBoolean(req.getParameter("showVersionDiffs")));
        rsp.sendRedirect("showDiffFiles?timestamp1=" + timestamp1 + "&timestamp2=" + timestamp2 + "&showVersionDiffs=" + showVersionDiffs);
    }

    public Api getApi() {
        return new Api((Object)this);
    }

    public int getLeadingWhitespace(String str) {
        return str == null ? 0 : str.indexOf(str.trim());
    }
}

