/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import hudson.Extension;
import hudson.model.AbstractItem;
import hudson.model.Item;
import hudson.model.listeners.ItemListener;
import hudson.plugins.jobConfigHistory.ItemListenerHistoryDao;
import hudson.plugins.jobConfigHistory.PluginUtils;
import java.util.logging.Level;
import java.util.logging.Logger;

@Extension
public class JobConfigHistoryJobListener
extends ItemListener {
    private static final Logger LOG = Logger.getLogger(JobConfigHistoryJobListener.class.getName());

    public void onCreated(Item item) {
        LOG.log(Level.FINEST, "In onCreated for {0}", item);
        this.switchHistoryDao(item).createNewItem(item);
        LOG.log(Level.FINEST, "onCreated for {0} done.", item);
    }

    public void onLocationChanged(Item item, String oldFullName, String newFullName) {
        String onLocationChangedDescription = "old full name: " + oldFullName + ", new full name: " + newFullName;
        LOG.log(Level.FINEST, "In onLocationChanged for {0}{1}", new Object[]{item, onLocationChangedDescription});
        this.switchHistoryDao(item).changeItemLocation(item, oldFullName, newFullName);
        LOG.log(Level.FINEST, "Completed onLocationChanged for {0}", item);
    }

    public void onRenamed(Item item, String oldName, String newName) {
        String onRenameDesc = " old name: " + oldName + ", new name: " + newName;
        LOG.log(Level.FINEST, "In onRenamed for {0}{1}", new Object[]{item, onRenameDesc});
        this.switchHistoryDao(item).renameItem(item, oldName, newName);
        LOG.log(Level.FINEST, "Completed onRename for {0} done.", item);
    }

    public void onDeleted(Item item) {
        LOG.log(Level.FINEST, "In onDeleted for {0}", item);
        this.switchHistoryDao(item).deleteItem(item);
        LOG.log(Level.FINEST, "onDeleted for {0} done.", item);
    }

    private ItemListenerHistoryDao switchHistoryDao(Item item) {
        return item instanceof AbstractItem ? this.getHistoryDao() : NoOpItemListenerHistoryDao.INSTANCE;
    }

    ItemListenerHistoryDao getHistoryDao() {
        return PluginUtils.getHistoryDao();
    }

    private static class NoOpItemListenerHistoryDao
    implements ItemListenerHistoryDao {
        static final NoOpItemListenerHistoryDao INSTANCE = new NoOpItemListenerHistoryDao();

        private NoOpItemListenerHistoryDao() {
        }

        @Override
        public void createNewItem(Item item) {
            LOG.log(Level.FINEST, "onCreated: not an AbstractItem {0}, skipping.", item);
        }

        @Override
        public void renameItem(Item item, String oldName, String newName) {
            LOG.log(Level.FINEST, "onRenamed: not an AbstractItem {0}, skipping.", item);
        }

        @Override
        public void deleteItem(Item item) {
            LOG.log(Level.FINEST, "onDeleted: not an AbstractItem {0}, skipping.", item);
        }

        @Override
        public void changeItemLocation(Item item, String oldFullName, String newFullName) {
            LOG.log(Level.FINEST, "onLocationChanged: not an AbstractItem{0}, skipping.", item);
        }
    }
}

