/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import hudson.XmlFile;
import hudson.maven.MavenModule;
import hudson.model.AbstractItem;
import hudson.model.Api;
import hudson.model.Item;
import hudson.model.TopLevelItem;
import hudson.plugins.jobConfigHistory.ConfigInfo;
import hudson.plugins.jobConfigHistory.HistoryDao;
import hudson.plugins.jobConfigHistory.HistoryDescr;
import hudson.plugins.jobConfigHistory.JobConfigHistory;
import hudson.plugins.jobConfigHistory.JobConfigHistoryBaseAction;
import hudson.plugins.jobConfigHistory.ParsedDateComparator;
import hudson.plugins.jobConfigHistory.PluginUtils;
import hudson.plugins.jobConfigHistory.SideBySideView;
import hudson.plugins.jobConfigHistory.XmlSyntaxChecker;
import hudson.security.AccessControlled;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import jenkins.model.Jenkins;
import org.acegisecurity.AccessDeniedException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=-1)
public class JobConfigHistoryProjectAction
extends JobConfigHistoryBaseAction {
    private static final Logger LOG = Logger.getLogger(JobConfigHistoryProjectAction.class.getName());
    private final transient AbstractItem project;

    public JobConfigHistoryProjectAction(AbstractItem project) {
        this.project = project;
    }

    public JobConfigHistoryProjectAction(Jenkins jenkins, AbstractItem project) {
        super(jenkins);
        this.project = project;
    }

    public final String getIconFileName() {
        if (!this.hasConfigurePermission() && !this.hasReadExtensionPermission()) {
            return null;
        }
        if (this.project instanceof TopLevelItem) {
            return "/plugin/jobConfigHistory/img/confighistory.png";
        }
        if (this.getPlugin().getSaveModuleConfiguration() && PluginUtils.isMavenPluginAvailable() && this.project instanceof MavenModule) {
            return "/plugin/jobConfigHistory/img/confighistory.png";
        }
        return null;
    }

    public final List<ConfigInfo> getJobConfigs() throws IOException {
        if (!this.hasConfigurePermission() && !this.hasReadExtensionPermission()) {
            this.checkConfigurePermission();
            return Collections.emptyList();
        }
        ArrayList<HistoryDescr> values = new ArrayList<HistoryDescr>(this.getHistoryDao().getRevisions(this.project.getConfigFile()).values());
        String maxEntriesPerPageAsString = this.getPlugin().getMaxEntriesPerPage();
        int maxEntriesPerPage = maxEntriesPerPageAsString != null && !maxEntriesPerPageAsString.isEmpty() ? Math.min(values.size(), Integer.parseInt(maxEntriesPerPageAsString)) : values.size();
        List<ConfigInfo> configs = this.toConfigInfoList(values, values.size() - maxEntriesPerPage, values.size());
        Collections.sort(configs, ParsedDateComparator.DESCENDING);
        return configs;
    }

    public final List<ConfigInfo> getJobConfigs(int from, int to) {
        if (from > to) {
            throw new IllegalArgumentException("start index is greater than end index: (" + from + ", " + to + ")");
        }
        int revisionAmount = this.getRevisionAmount();
        if (from > revisionAmount) {
            LOG.log(Level.FINEST, "Unexpected arguments while generating overview page: start index ({0}) is greater than total revision amount ({1})!", new Object[]{from, revisionAmount});
            return Collections.emptyList();
        }
        if (to > revisionAmount) {
            to = revisionAmount;
        }
        if (!this.hasConfigurePermission() && !this.hasReadExtensionPermission()) {
            this.checkConfigurePermission();
            return Collections.emptyList();
        }
        SortedMap<String, HistoryDescr> historyDescrSortedMap = this.getHistoryDao().getRevisions(this.project.getConfigFile());
        ArrayList<HistoryDescr> mapValues = new ArrayList<HistoryDescr>(historyDescrSortedMap.values());
        Collections.reverse(mapValues);
        List<HistoryDescr> cuttedHistoryDescrs = mapValues.subList(from, to);
        return this.toConfigInfoList(cuttedHistoryDescrs, 0, cuttedHistoryDescrs.size());
    }

    @Override
    public int getRevisionAmount() {
        return this.getHistoryDao().getRevisionAmount(this.project.getConfigFile());
    }

    private List<ConfigInfo> toConfigInfoList(List<HistoryDescr> historyDescrs, int from, int to) {
        ArrayList<ConfigInfo> configs = new ArrayList<ConfigInfo>();
        for (HistoryDescr historyDescr : historyDescrs.subList(from, to)) {
            String timestamp = historyDescr.getTimestamp();
            XmlFile oldRevision = this.getHistoryDao().getOldRevision(this.project, timestamp);
            if (oldRevision.getFile() != null) {
                configs.add(ConfigInfo.create(this.project.getFullName(), true, historyDescr, true));
                continue;
            }
            if (!"Deleted".equals(historyDescr.getOperation())) continue;
            configs.add(ConfigInfo.create(this.project.getFullName(), false, historyDescr, true));
        }
        return configs;
    }

    @Exported(name="jobConfigHistory", visibility=1)
    public final List<ConfigInfo> getJobConfigsREST() throws IOException {
        List<ConfigInfo> configs = null;
        try {
            configs = this.getJobConfigs();
        }
        catch (AccessDeniedException e) {
            configs = new ArrayList<ConfigInfo>();
        }
        return configs;
    }

    public final String getFile() throws IOException {
        if (!this.hasConfigurePermission() && !this.hasReadExtensionPermission()) {
            this.checkConfigurePermission();
            return null;
        }
        String timestamp = this.getRequestParameter("timestamp");
        XmlFile xmlFile = this.getOldConfigXml(timestamp);
        return xmlFile.asString();
    }

    public final AbstractItem getProject() {
        return this.project;
    }

    @Override
    public AccessControlled getAccessControlledObject() {
        return this.project;
    }

    @Override
    public void checkConfigurePermission() {
        this.getAccessControlledObject().checkPermission(Item.CONFIGURE);
    }

    @Override
    protected void checkDeleteEntryPermission() {
        this.getAccessControlledObject().checkPermission(JobConfigHistory.DELETEENTRY_PERMISSION);
    }

    @Override
    public boolean hasAdminPermission() {
        return this.getAccessControlledObject().hasPermission(Jenkins.ADMINISTER);
    }

    @Override
    public boolean hasDeleteEntryPermission() {
        return this.getAccessControlledObject().hasPermission(JobConfigHistory.DELETEENTRY_PERMISSION);
    }

    @Override
    public boolean hasConfigurePermission() {
        return this.getAccessControlledObject().hasPermission(Item.CONFIGURE);
    }

    public boolean hasReadExtensionPermission() {
        return this.getAccessControlledObject().hasPermission(Item.EXTENDED_READ);
    }

    public final String getTimestamp(int timestampNumber) {
        if (!this.hasConfigurePermission() && !this.hasReadExtensionPermission()) {
            this.checkConfigurePermission();
            return null;
        }
        String timeStamp = this.getRequestParameter("timestamp" + timestampNumber);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        try {
            format.setLenient(false);
            format.parse(timeStamp);
            return timeStamp;
        }
        catch (ParseException e) {
            return null;
        }
    }

    public final String getUser(int timestampNumber) {
        this.checkConfigurePermission();
        return ((HistoryDescr)this.getHistoryDao().getRevisions(this.project.getConfigFile()).get(this.getTimestamp(timestampNumber))).getUser();
    }

    public final String getUserID(int timestamp) {
        this.checkConfigurePermission();
        return ((HistoryDescr)this.getHistoryDao().getRevisions(this.project.getConfigFile()).get(this.getTimestamp(timestamp))).getUserID();
    }

    public final String getChangeReasonComment(int timestamp) {
        if (!this.hasConfigurePermission() && !this.hasReadExtensionPermission()) {
            this.checkConfigurePermission();
            return null;
        }
        return ((HistoryDescr)this.getHistoryDao().getRevisions(this.project.getConfigFile()).get(this.getTimestamp(timestamp))).getChangeReasonComment();
    }

    public final boolean hasChangeReasonComment(int timestamp) {
        if (!this.hasConfigurePermission() && !this.hasReadExtensionPermission()) {
            this.checkConfigurePermission();
            return false;
        }
        String comment = ((HistoryDescr)this.getHistoryDao().getRevisions(this.project.getConfigFile()).get(this.getTimestamp(timestamp))).getChangeReasonComment();
        return comment != null && !comment.isEmpty();
    }

    public final String getOperation(int timestampNumber) {
        if (!this.hasConfigurePermission() && !this.hasReadExtensionPermission()) {
            this.checkConfigurePermission();
            return null;
        }
        return ((HistoryDescr)this.getHistoryDao().getRevisions(this.project.getConfigFile()).get(this.getTimestamp(timestampNumber))).getOperation();
    }

    public final String getNextTimestamp(int timestampNumber) {
        if (!this.hasConfigurePermission() && !this.hasReadExtensionPermission()) {
            this.checkConfigurePermission();
            return null;
        }
        String timestamp = this.getRequestParameter("timestamp" + timestampNumber);
        SortedMap<String, HistoryDescr> revisions = this.getHistoryDao().getRevisions(this.project.getConfigFile());
        Iterator<Map.Entry<String, HistoryDescr>> itr = revisions.entrySet().iterator();
        while (itr.hasNext()) {
            if (!itr.next().getValue().getTimestamp().equals(timestamp) || !itr.hasNext()) continue;
            return itr.next().getValue().getTimestamp();
        }
        return timestamp;
    }

    public final String getPrevTimestamp(int timestampNumber) {
        if (!this.hasConfigurePermission() && !this.hasReadExtensionPermission()) {
            this.checkConfigurePermission();
            return null;
        }
        String timestamp = this.getRequestParameter("timestamp" + timestampNumber);
        SortedMap<String, HistoryDescr> revisions = this.getHistoryDao().getRevisions(this.project.getConfigFile());
        Iterator<Map.Entry<String, HistoryDescr>> itr = revisions.entrySet().iterator();
        String prevTimestamp = timestamp;
        while (itr.hasNext()) {
            String checkTimestamp = itr.next().getValue().getTimestamp();
            if (checkTimestamp.equals(timestamp)) {
                return prevTimestamp;
            }
            prevTimestamp = checkTimestamp;
        }
        return timestamp;
    }

    @Override
    public final List<SideBySideView.Line> getLines(boolean hideVersionDiffs) throws IOException {
        if (!this.hasConfigurePermission() && !this.hasReadExtensionPermission()) {
            this.checkConfigurePermission();
            return null;
        }
        String timestamp1 = this.getRequestParameter("timestamp1");
        String timestamp2 = this.getRequestParameter("timestamp2");
        return this.getLines(this.getOldConfigXml(timestamp1), this.getOldConfigXml(timestamp2), hideVersionDiffs);
    }

    public XmlSyntaxChecker.Answer checkXmlSyntax(String timestamp) {
        return XmlSyntaxChecker.check(this.getOldConfigXml(timestamp).getFile());
    }

    private XmlFile getOldConfigXml(String timestamp) {
        if (!this.hasConfigurePermission() && !this.hasReadExtensionPermission()) {
            this.checkConfigurePermission();
            return null;
        }
        XmlFile oldRevision = this.getHistoryDao().getOldRevision(this.project, timestamp);
        if (oldRevision.getFile() != null) {
            return oldRevision;
        }
        throw new IllegalArgumentException("Non existent timestamp " + timestamp);
    }

    public final void doRestore(StaplerRequest req, StaplerResponse rsp) throws IOException {
        this.checkConfigurePermission();
        String timestamp = req.getParameter("timestamp");
        XmlFile xmlFile = this.getHistoryDao().getOldRevision(this.project, timestamp);
        ByteArrayInputStream is = new ByteArrayInputStream(xmlFile.asString().getBytes(StandardCharsets.UTF_8));
        this.project.updateByXml((Source)new StreamSource(is));
        this.project.save();
        rsp.sendRedirect(this.getJenkins().getRootUrl() + this.project.getUrl());
    }

    public final void doForwardToRestoreQuestion(StaplerRequest req, StaplerResponse rsp) throws IOException {
        String timestamp = req.getParameter("timestamp");
        rsp.sendRedirect("restoreQuestion?timestamp=" + timestamp);
    }

    public final void doDeleteRevision(StaplerRequest req, StaplerResponse rsp) {
        this.checkDeleteEntryPermission();
        String timestamp = req.getParameter("timestamp");
        PluginUtils.getHistoryDao().deleteRevision(this.getProject(), timestamp);
    }

    public boolean revisionEqualsCurrent(String timestamp) {
        return PluginUtils.getHistoryDao().revisionEqualsCurrent(this.getProject(), timestamp);
    }

    @Override
    protected HistoryDao getHistoryDao() {
        return PluginUtils.getHistoryDao();
    }

    public Api getApi() {
        return new Api((Object)this);
    }

    public int getLeadingWhitespace(String str) {
        return str == null ? 0 : str.indexOf(str.trim());
    }
}

