/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import com.google.common.collect.Lists;
import difflib.Delta;
import difflib.DiffUtils;
import difflib.Patch;
import difflib.StringUtills;
import hudson.XmlFile;
import hudson.model.Action;
import hudson.plugins.jobConfigHistory.GetDiffLines;
import hudson.plugins.jobConfigHistory.HistoryDao;
import hudson.plugins.jobConfigHistory.JobConfigHistory;
import hudson.plugins.jobConfigHistory.Messages;
import hudson.plugins.jobConfigHistory.PluginUtils;
import hudson.plugins.jobConfigHistory.SideBySideView;
import hudson.security.AccessControlled;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.builder.Input;
import org.xmlunit.diff.Comparison;
import org.xmlunit.diff.ComparisonResult;
import org.xmlunit.diff.ComparisonType;
import org.xmlunit.diff.Diff;
import org.xmlunit.diff.Difference;
import org.xmlunit.diff.DifferenceEvaluator;

public abstract class JobConfigHistoryBaseAction
implements Action {
    private final Jenkins jenkins;
    private final TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private static final Logger LOG = Logger.getLogger(JobConfigHistoryBaseAction.class.getName());

    public JobConfigHistoryBaseAction() {
        this.jenkins = Jenkins.getInstance();
    }

    JobConfigHistoryBaseAction(Jenkins jenkins) {
        this.jenkins = jenkins;
    }

    public String getDisplayName() {
        return Messages.displayName();
    }

    public String getUrlName() {
        return "jobConfigHistory";
    }

    public final String getOutputType() {
        if ("xml".equalsIgnoreCase(this.getRequestParameter("type"))) {
            return "xml";
        }
        return "plain";
    }

    protected boolean checkTimestamp(String timestamp) {
        if (timestamp == null || "null".equals(timestamp)) {
            return false;
        }
        PluginUtils.parsedDate(timestamp);
        return true;
    }

    protected String getRequestParameter(String parameterName) {
        return this.getCurrentRequest().getParameter(parameterName);
    }

    protected abstract void checkConfigurePermission();

    protected abstract boolean hasConfigurePermission();

    protected Jenkins getJenkins() {
        return this.jenkins;
    }

    protected abstract AccessControlled getAccessControlledObject();

    public final List<SideBySideView.Line> getDiffLines(List<String> diffLines) {
        return new GetDiffLines(diffLines).get();
    }

    protected final String getDiffAsString(File file1, File file2, String[] file1Lines, String[] file2Lines) {
        return this.getDiffAsString(file1, file2, file1Lines, file2Lines, false);
    }

    private Diff getVersionDiffsOnly(String file1Str, String file2Str) {
        DifferenceEvaluator versionDifferenceEvaluator = new DifferenceEvaluator(){

            public ComparisonResult evaluate(Comparison comparison, ComparisonResult comparisonResult) {
                String[] testValue;
                if (comparison.getType() != ComparisonType.ATTR_VALUE) {
                    return ComparisonResult.EQUAL;
                }
                Node controlNode = comparison.getControlDetails().getTarget();
                Node testNode = comparison.getTestDetails().getTarget();
                if (controlNode == null || testNode == null) {
                    return ComparisonResult.EQUAL;
                }
                String[] controlValue = controlNode.getNodeValue().split("@");
                if (!controlValue[0].equals((testValue = testNode.getNodeValue().split("@"))[0]) || controlValue.length != 2 || testValue.length != 2) {
                    return ComparisonResult.EQUAL;
                }
                if (controlValue[1].equals(testValue[1])) {
                    return ComparisonResult.EQUAL;
                }
                return ComparisonResult.DIFFERENT;
            }
        };
        return DiffBuilder.compare((Object)Input.fromString((String)file1Str)).withTest((Object)Input.fromString((String)file2Str)).ignoreWhitespace().withDifferenceEvaluator(versionDifferenceEvaluator).build();
    }

    public String getShowVersionDiffs() {
        String showVersionDiffs = this.getRequestParameter("showVersionDiffs");
        return showVersionDiffs == null ? "True" : showVersionDiffs;
    }

    public final List<SideBySideView.Line> getLines() throws IOException {
        boolean hideVersionDiffs = !Boolean.parseBoolean(this.getShowVersionDiffs());
        return this.getLines(hideVersionDiffs);
    }

    public abstract List<SideBySideView.Line> getLines(boolean var1) throws IOException;

    private String reformatAndConcatStringArray(String[] arr) {
        String ret = "";
        String firstLineRegex = "<[^<>]*>";
        String firstLine = arr[0];
        if (firstLine.matches("<[^<>]*>")) {
            ret = ret + firstLine;
        } else {
            String tagThatBelongsInTheNextLine = firstLine.replaceFirst("<[^<>]*>", "");
            ret = ret + firstLine.substring(0, firstLine.length() - tagThatBelongsInTheNextLine.length()) + "\n" + tagThatBelongsInTheNextLine + "\n";
        }
        for (int i = 1; i < arr.length; ++i) {
            ret = i < arr.length - 1 ? ret.concat(arr[i]).concat("\n") : ret.concat(arr[i]);
        }
        return ret;
    }

    protected final String getDiffAsString(File file1, File file2, String[] file1Lines, String[] file2Lines, boolean hideVersionDiffs) {
        Patch patch = DiffUtils.diff(Arrays.asList(file1Lines), Arrays.asList(file2Lines));
        if (hideVersionDiffs) {
            Diff versionDiffs = this.getVersionDiffsOnly(this.reformatAndConcatStringArray(file1Lines), this.reformatAndConcatStringArray(file2Lines));
            LinkedList<Delta> deltasToBeRemovedAfterTheMainLoop = new LinkedList<Delta>();
            for (Delta delta : patch.getDeltas()) {
                ArrayList originalLines = Lists.newArrayList((Iterable)delta.getOriginal().getLines());
                ArrayList revisedLines = Lists.newArrayList((Iterable)delta.getRevised().getLines());
                for (Difference versionDifference : versionDiffs.getDifferences()) {
                    String controlValue = versionDifference.getComparison().getControlDetails().getValue().toString();
                    String testValue = versionDifference.getComparison().getTestDetails().getValue().toString();
                    for (int oriLineNumber = 0; oriLineNumber < originalLines.size(); ++oriLineNumber) {
                        String currentOriLine = (String)originalLines.get(oriLineNumber);
                        String otherValue = "";
                        if (currentOriLine.contains(controlValue)) {
                            otherValue = testValue;
                        } else {
                            if (!currentOriLine.contains(testValue)) continue;
                            otherValue = controlValue;
                        }
                        for (int revLineNumber = 0; revLineNumber < revisedLines.size(); ++revLineNumber) {
                            String currentRevLine = (String)revisedLines.get(revLineNumber);
                            if (!currentRevLine.contains(otherValue)) continue;
                            originalLines.remove(oriLineNumber);
                            revisedLines.remove(revLineNumber);
                        }
                    }
                }
                if (originalLines.isEmpty() && revisedLines.isEmpty()) {
                    deltasToBeRemovedAfterTheMainLoop.add(delta);
                }
                delta.getOriginal().setLines((List)originalLines);
                delta.getRevised().setLines((List)revisedLines);
            }
            patch.getDeltas().removeAll(deltasToBeRemovedAfterTheMainLoop);
        }
        List unifiedDiff = DiffUtils.generateUnifiedDiff((String)file1.getPath(), (String)file2.getPath(), Arrays.asList(file1Lines), (Patch)patch, (int)3);
        return StringUtills.join((Iterable)unifiedDiff, (String)"\n") + "\n";
    }

    public void doDiffFiles(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
        String timestamp1 = req.getParameter("timestamp1");
        String timestamp2 = req.getParameter("timestamp2");
        if (PluginUtils.parsedDate(timestamp1).after(PluginUtils.parsedDate(timestamp2))) {
            timestamp1 = req.getParameter("timestamp2");
            timestamp2 = req.getParameter("timestamp1");
        }
        rsp.sendRedirect("showDiffFiles?timestamp1=" + timestamp1 + "&timestamp2=" + timestamp2);
    }

    public final void doDiffFilesPrevNext(StaplerRequest req, StaplerResponse rsp) throws IOException {
        String timestamp1 = req.getParameter("timestamp1");
        String timestamp2 = req.getParameter("timestamp2");
        rsp.sendRedirect("showDiffFiles?timestamp1=" + timestamp1 + "&timestamp2=" + timestamp2);
    }

    protected StaplerRequest getCurrentRequest() {
        return Stapler.getCurrentRequest();
    }

    protected JobConfigHistory getPlugin() {
        return PluginUtils.getPlugin();
    }

    protected HistoryDao getHistoryDao() {
        return PluginUtils.getHistoryDao();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Writer sort(File file) throws IOException {
        try (BufferedReader source = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
            InputStream xslt = JobConfigHistoryBaseAction.class.getResourceAsStream("xslt/sort.xslt");
            Objects.requireNonNull(xslt);
            Transformer transformer = this.transformerFactory.newTransformer(new StreamSource(xslt));
            StringWriter result = new StringWriter();
            transformer.transform(new SAXSource(new InputSource(source)), new StreamResult(result));
            transformer.reset();
            StringWriter stringWriter = result;
            return stringWriter;
        }
        catch (NullPointerException | TransformerException | TransformerFactoryConfigurationError e) {
            LogRecord lr = new LogRecord(Level.WARNING, "Diff may have extra changes for XML config {0}");
            lr.setParameters(new Object[]{file.toPath()});
            lr.setThrown(e);
            LOG.log(lr);
            StringWriter fallback = new StringWriter();
            new XmlFile(file).writeRawTo((Writer)fallback);
            return fallback;
        }
    }

    protected final List<SideBySideView.Line> getLines(XmlFile leftConfig, XmlFile rightConfig, boolean hideVersionDiffs) throws IOException {
        String[] leftLines = this.sort(leftConfig.getFile()).toString().split("\\n");
        String[] rightLines = this.sort(rightConfig.getFile()).toString().split("\\n");
        String diffAsString = this.getDiffAsString(leftConfig.getFile(), rightConfig.getFile(), leftLines, rightLines, hideVersionDiffs);
        List<String> diffLines = Arrays.asList(diffAsString.split("\n"));
        return this.getDiffLines(diffLines);
    }
}

