/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import hudson.Plugin;
import hudson.model.User;
import hudson.plugins.jobConfigHistory.FileHistoryDao;
import hudson.plugins.jobConfigHistory.JobConfigHistory;
import hudson.plugins.jobConfigHistory.JobConfigHistoryStrategy;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;

public final class PluginUtils {
    private PluginUtils() {
    }

    public static JobConfigHistory getPlugin() {
        Jenkins jenkins = Jenkins.getInstance();
        return (JobConfigHistory)jenkins.getPlugin(JobConfigHistory.class);
    }

    public static JobConfigHistoryStrategy getHistoryDao() {
        JobConfigHistory plugin = PluginUtils.getPlugin();
        return PluginUtils.getHistoryDao(plugin);
    }

    public static JobConfigHistoryStrategy getAnonymousHistoryDao() {
        JobConfigHistory plugin = PluginUtils.getPlugin();
        return PluginUtils.getAnonymousHistoryDao(plugin);
    }

    public static JobConfigHistoryStrategy getHistoryDao(JobConfigHistory plugin) {
        return PluginUtils.getHistoryDao(plugin, User.current());
    }

    public static JobConfigHistoryStrategy getAnonymousHistoryDao(JobConfigHistory plugin) {
        return PluginUtils.getHistoryDao(plugin, null);
    }

    public static JobConfigHistoryStrategy getHistoryDao(JobConfigHistory plugin, User user) {
        String maxHistoryEntriesAsString = plugin.getMaxHistoryEntries();
        int maxHistoryEntries = 0;
        try {
            maxHistoryEntries = Integer.parseInt(maxHistoryEntriesAsString);
        }
        catch (NumberFormatException e) {
            maxHistoryEntries = 0;
        }
        Jenkins jenkins = Jenkins.getInstance();
        return new FileHistoryDao(plugin.getConfiguredHistoryRootDir(), new File(jenkins.root.getPath()), user, maxHistoryEntries, !plugin.getSkipDuplicateHistory());
    }

    public static boolean isUserExcluded(JobConfigHistory plugin) {
        String user = Jenkins.getAuthentication().getName();
        if (plugin.getExcludedUsers() != null) {
            String[] segs;
            String excludedUsers = plugin.getExcludedUsers().trim();
            for (String seg : segs = excludedUsers.split(Pattern.quote(","))) {
                if (!seg.trim().equals(user)) continue;
                return true;
            }
        }
        return false;
    }

    public static Date parsedDate(String timeStamp) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").parse(timeStamp);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Could not parse Date" + timeStamp, ex);
        }
    }

    public static boolean isMavenPluginAvailable() {
        Jenkins jenkins = Jenkins.getInstance();
        try {
            Plugin plugin = jenkins.getPlugin("maven-plugin");
            return plugin != null && plugin.getWrapper().isActive();
        }
        catch (Exception e) {
            return false;
        }
    }
}

