/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import hudson.model.Hudson;
import hudson.model.User;
import hudson.plugins.jobConfigHistory.FileHistoryDao;
import hudson.plugins.jobConfigHistory.JobConfigHistory;
import hudson.plugins.jobConfigHistory.JobConfigHistoryStrategy;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public final class PluginUtils {
    private PluginUtils() {
    }

    public static JobConfigHistory getPlugin() {
        return (JobConfigHistory)Hudson.getInstance().getPlugin(JobConfigHistory.class);
    }

    public static JobConfigHistoryStrategy getHistoryDao() {
        JobConfigHistory plugin = PluginUtils.getPlugin();
        return PluginUtils.getHistoryDao(plugin);
    }

    public static JobConfigHistoryStrategy getAnonymousHistoryDao() {
        JobConfigHistory plugin = PluginUtils.getPlugin();
        return PluginUtils.getAnonymousHistoryDao(plugin);
    }

    public static JobConfigHistoryStrategy getHistoryDao(JobConfigHistory plugin) {
        return PluginUtils.getHistoryDao(plugin, User.current());
    }

    public static JobConfigHistoryStrategy getAnonymousHistoryDao(JobConfigHistory plugin) {
        return PluginUtils.getHistoryDao(plugin, null);
    }

    private static int valueOfStringOrDefault(String s, int x) {
        try {
            return Integer.valueOf(s);
        }
        catch (NumberFormatException e) {
            return x;
        }
    }

    private static File getFileFromURL(URL url) {
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(PluginUtils.class.getName()).log(Level.SEVERE, null, ex);
            return new File(url.getPath());
        }
    }

    public static JobConfigHistoryStrategy getHistoryDao(JobConfigHistory plugin, User user) {
        String maxHistoryEntriesAsString = plugin.getMaxHistoryEntries();
        int maxHistoryEntries = 0;
        try {
            maxHistoryEntries = Integer.valueOf(maxHistoryEntriesAsString);
        }
        catch (NumberFormatException e) {
            maxHistoryEntries = 0;
        }
        return new FileHistoryDao(plugin.getConfiguredHistoryRootDir(), new File(Hudson.getInstance().root.getPath()), user, maxHistoryEntries, !plugin.getSkipDuplicateHistory());
    }

    public static boolean isUserExcluded(JobConfigHistory plugin) {
        User user = User.current();
        if (plugin.getExcludedUsers() != null) {
            String[] segs;
            String excludedUsers = plugin.getExcludedUsers().trim();
            for (String seg : segs = excludedUsers.split(Pattern.quote(","))) {
                if (user == null || user.getId() == null || !seg.trim().equals(user.getId())) continue;
                return true;
            }
        }
        return false;
    }

    public static Date parsedDate(String timeStamp) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").parse(timeStamp);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Could not parse Date" + timeStamp, ex);
        }
    }
}

