/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import hudson.Extension;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.plugins.jobConfigHistory.FileHistoryDao;
import hudson.plugins.jobConfigHistory.NodeListenerHistoryDao;
import hudson.plugins.jobConfigHistory.PluginUtils;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.ComputerListener;
import hudson.slaves.EphemeralNode;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

@Extension
public class ComputerHistoryListener
extends ComputerListener {
    List<Node> nodes = Jenkins.getInstance().getNodes();
    private static final Logger LOG = Logger.getLogger(ComputerHistoryListener.class.getName());

    public void onConfigurationChange() {
        if (this.nodes == null) {
            this.nodes = Jenkins.getInstance().getNodes();
        }
        if (this.nodes.size() < Jenkins.getInstance().getNodes().size()) {
            this.onAdd();
            this.nodes = Jenkins.getInstance().getNodes();
            return;
        }
        if (this.nodes.size() > Jenkins.getInstance().getNodes().size()) {
            this.onRemove();
            this.nodes = Jenkins.getInstance().getNodes();
            return;
        }
        if (!this.nodes.equals(Jenkins.getInstance().getNodes())) {
            this.onRename();
            this.nodes = Jenkins.getInstance().getNodes();
        }
        if (this.nodes.size() == Jenkins.getInstance().getNodes().size()) {
            this.onChange();
        }
    }

    private void onAdd() {
        for (Node node : Jenkins.getInstance().getNodes()) {
            if (this.nodes.contains(node) || !this.isTracked(node)) continue;
            this.switchHistoryDao(node).createNewNode(node);
            return;
        }
    }

    private boolean isTracked(Node node) {
        return node != null && !(node instanceof AbstractCloudSlave) && !(node instanceof EphemeralNode);
    }

    private void onRemove() {
        for (Node node : this.nodes) {
            if (Jenkins.getInstance().getNodes().contains(node) || !this.isTracked(node)) continue;
            this.switchHistoryDao(node).deleteNode(node);
            return;
        }
    }

    private void onChange() {
        FileHistoryDao hdao = PluginUtils.getHistoryDao();
        for (Node node : Jenkins.getInstance().getNodes()) {
            if (!this.isTracked(node) || hdao.hasDuplicateHistory(node)) continue;
            PluginUtils.getHistoryDao().saveNode(node);
            return;
        }
    }

    private void onRename() {
        Node originalNode = null;
        for (Node node : this.nodes) {
            if (Jenkins.getInstance().getNodes().contains(node) || !this.isTracked(node)) continue;
            originalNode = node;
        }
        if (originalNode == null) {
            LOG.log(Level.WARNING, "Can not find changed node.");
            return;
        }
        Node newNode = null;
        for (Node node : Jenkins.getInstance().getNodes()) {
            if (this.nodes.contains(node) || !this.isTracked(node)) continue;
            newNode = node;
        }
        if (!originalNode.getNodeName().equals(newNode.getNodeName())) {
            this.switchHistoryDao(originalNode).renameNode(newNode, originalNode.getNodeName(), newNode.getNodeName());
        }
    }

    private NodeListenerHistoryDao switchHistoryDao(Node node) {
        return node instanceof Slave ? this.getHistoryDao() : NoOpNodeListenerHistoryDao.INSTANCE;
    }

    NodeListenerHistoryDao getHistoryDao() {
        return PluginUtils.getHistoryDao();
    }

    private static class NoOpNodeListenerHistoryDao
    implements NodeListenerHistoryDao {
        static final NoOpNodeListenerHistoryDao INSTANCE = new NoOpNodeListenerHistoryDao();

        private NoOpNodeListenerHistoryDao() {
        }

        @Override
        public void createNewNode(Node node) {
            LOG.log(Level.FINEST, "onCreated: not an Slave {0}, skipping.", node);
        }

        @Override
        public void renameNode(Node node, String oldName, String newName) {
            LOG.log(Level.FINEST, "onRenamed: not an Slave {0}, skipping.", node);
        }

        @Override
        public void deleteNode(Node node) {
            LOG.log(Level.FINEST, "onDeleted: not an Slave {0}, skipping.", node);
        }
    }
}

