/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import difflib.Chunk;
import difflib.Delta;
import difflib.DiffRow;
import difflib.DiffRowGenerator;
import difflib.DiffUtils;
import difflib.Patch;
import hudson.plugins.jobConfigHistory.SideBySideView;
import java.util.List;
import org.apache.commons.lang.StringUtils;

class GetDiffLines {
    private final List<String> diffLines;
    private final SideBySideView view;
    private final DiffRowGenerator dfg;

    public GetDiffLines(List<String> diffLines) {
        DiffRowGenerator.Builder builder = new DiffRowGenerator.Builder();
        builder.columnWidth(Integer.MAX_VALUE);
        this.dfg = builder.build();
        this.diffLines = diffLines;
        this.view = new SideBySideView();
    }

    public List<SideBySideView.Line> get() {
        Patch diff = DiffUtils.parseUnifiedDiff(this.diffLines);
        int previousLeftPos = 0;
        for (Delta delta : diff.getDeltas()) {
            previousLeftPos = this.deltaLoop(delta, previousLeftPos);
        }
        this.view.clearDuplicateLines();
        return this.view.getLines();
    }

    int deltaLoop(Delta delta, int previousLeftPos) {
        return new DeltaLoop(this.view, this.dfg, delta).loop(previousLeftPos);
    }

    static class DeltaLoop {
        private final SideBySideView view;
        private final DiffRowGenerator dfg;
        private final Delta delta;
        private int leftPos;
        private int rightPos;

        public DeltaLoop(SideBySideView view, DiffRowGenerator dfg, Delta delta) {
            this.view = view;
            this.dfg = dfg;
            this.delta = delta;
        }

        int loop(int previousLeftPos) {
            Chunk original = this.delta.getOriginal();
            Chunk revised = this.delta.getRevised();
            List diffRows = this.dfg.generateDiffRows(original.getLines(), revised.getLines());
            this.leftPos = original.getPosition() + 1;
            this.rightPos = revised.getPosition() + 1;
            if (previousLeftPos > 0 && this.leftPos - previousLeftPos > 1) {
                SideBySideView.Line skippingLine = new SideBySideView.Line();
                skippingLine.setSkipping(true);
                this.view.addLine(skippingLine);
            }
            for (DiffRow row : diffRows) {
                previousLeftPos = this.processDiffRow(row);
            }
            return previousLeftPos;
        }

        int processDiffRow(DiffRow row) {
            DiffRow.Tag tag = row.getTag();
            SideBySideView.Line line = new SideBySideView.Line();
            SideBySideView.Line.Item left = line.getLeft();
            SideBySideView.Line.Item right = line.getRight();
            if (tag == DiffRow.Tag.INSERT) {
                left.setCssClass("diff_original");
                right.setLineNumber(this.rightPos);
                right.setText(row.getNewLine());
                right.setCssClass("diff_revised");
                ++this.rightPos;
            } else if (tag == DiffRow.Tag.CHANGE) {
                if (StringUtils.isNotEmpty((String)row.getOldLine())) {
                    left.setLineNumber(this.leftPos);
                    left.setText(row.getOldLine());
                    ++this.leftPos;
                }
                left.setCssClass("diff_original");
                if (StringUtils.isNotEmpty((String)row.getNewLine())) {
                    right.setLineNumber(this.rightPos);
                    right.setText(row.getNewLine());
                    ++this.rightPos;
                }
                right.setCssClass("diff_revised");
            } else if (tag == DiffRow.Tag.DELETE) {
                left.setLineNumber(this.leftPos);
                left.setText(row.getOldLine());
                left.setCssClass("diff_original");
                ++this.leftPos;
                right.setCssClass("diff_revised");
            } else if (tag == DiffRow.Tag.EQUAL) {
                left.setLineNumber(this.leftPos);
                left.setText(row.getOldLine());
                ++this.leftPos;
                right.setLineNumber(this.rightPos);
                right.setText(row.getNewLine());
                ++this.rightPos;
            } else {
                throw new IllegalStateException("Unknown tag pattern: " + tag);
            }
            line.setTag(tag);
            this.view.addLine(line);
            return this.leftPos;
        }
    }
}

