/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import hudson.model.Hudson;
import hudson.model.User;
import hudson.plugins.jobConfigHistory.FileHistoryDao;
import hudson.plugins.jobConfigHistory.JobConfigHistory;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

final class PluginUtils {
    private PluginUtils() {
    }

    public static JobConfigHistory getPlugin() {
        return (JobConfigHistory)Hudson.getInstance().getPlugin(JobConfigHistory.class);
    }

    public static FileHistoryDao getHistoryDao() {
        JobConfigHistory plugin = PluginUtils.getPlugin();
        return PluginUtils.getHistoryDao(plugin);
    }

    public static FileHistoryDao getHistoryDao(JobConfigHistory plugin) {
        return PluginUtils.getHistoryDao(plugin, User.current());
    }

    static FileHistoryDao getHistoryDao(JobConfigHistory plugin, User user) {
        String maxHistoryEntriesAsString = plugin.getMaxHistoryEntries();
        int maxHistoryEntries = 0;
        try {
            maxHistoryEntries = Integer.valueOf(maxHistoryEntriesAsString);
        }
        catch (NumberFormatException e) {
            maxHistoryEntries = 0;
        }
        return new FileHistoryDao(plugin.getConfiguredHistoryRootDir(), new File(Hudson.getInstance().root.getPath()), user, maxHistoryEntries, !plugin.getSkipDuplicateHistory());
    }

    public static Date parsedDate(String timeStamp) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").parse(timeStamp);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Could not parse Date" + timeStamp, ex);
        }
    }
}

