/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import hudson.Extension;
import hudson.XmlFile;
import hudson.model.AbstractBuild;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildBadgeAction;
import hudson.model.Hudson;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.plugins.jobConfigHistory.ConfigInfo;
import hudson.plugins.jobConfigHistory.ConfigInfoComparator;
import hudson.plugins.jobConfigHistory.HistoryDescr;
import hudson.plugins.jobConfigHistory.JobConfigHistory;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class JobConfigBadgeAction
extends RunListener<AbstractBuild>
implements BuildBadgeAction {
    private static final Logger LOG = Logger.getLogger(JobConfigBadgeAction.class.getName());
    private String[] configDates;
    private AbstractBuild build;

    public JobConfigBadgeAction() {
    }

    public JobConfigBadgeAction(String[] configDates, AbstractBuild build) {
        super(AbstractBuild.class);
        this.configDates = (String[])configDates.clone();
        this.build = build;
    }

    public void onStarted(AbstractBuild build, TaskListener listener) {
        AbstractProject project = build.getProject();
        if (project.getNextBuildNumber() == 2) {
            super.onStarted((Run)build, listener);
            return;
        }
        Date lastBuildDate = ((AbstractBuild)((AbstractBuild)project.getLastBuild()).getPreviousBuild()).getTime();
        ArrayList<ConfigInfo> configs = new ArrayList<ConfigInfo>();
        File historyRootDir = ((JobConfigHistory)Hudson.getInstance().getPlugin(JobConfigHistory.class)).getHistoryDir(project.getConfigFile());
        if (historyRootDir.exists()) {
            try {
                for (File historyDir : historyRootDir.listFiles(JobConfigHistory.HISTORY_FILTER)) {
                    XmlFile historyXml = new XmlFile(new File(historyDir, "history.xml"));
                    HistoryDescr histDescr = (HistoryDescr)historyXml.read();
                    ConfigInfo config = ConfigInfo.create((AbstractItem)project, historyDir, histDescr);
                    configs.add(config);
                }
            }
            catch (IOException ex) {
                LOG.finest("Could not parse history files: " + ex);
            }
        }
        Collections.sort(configs, ConfigInfoComparator.INSTANCE);
        ConfigInfo lastChange = Collections.min(configs, ConfigInfoComparator.INSTANCE);
        ConfigInfo penultimateChange = (ConfigInfo)configs.get(1);
        try {
            Date lastConfigChange = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").parse(lastChange.getDate());
            if (lastConfigChange.after(lastBuildDate)) {
                String[] dates = new String[]{lastChange.getDate(), penultimateChange.getDate()};
                build.addAction((Action)new JobConfigBadgeAction(dates, build));
            }
        }
        catch (ParseException e) {
            LOG.finest("Could not parse Date: " + e);
        }
        super.onStarted((Run)build, listener);
    }

    public String createLink() {
        return Hudson.getInstance().getRootUrl() + "job/" + this.build.getProject().getName() + "/" + "jobConfigHistory" + "/showDiffFiles?timestamp1=" + this.configDates[1] + "&timestamp2=" + this.configDates[0] + "&name=" + this.build.getProject().getName() + "&isJob=true";
    }

    public String getTooltip() {
        return "Config changed since last build.";
    }

    public String getIcon() {
        return "/plugin/jobConfigHistory/img/buildbadge.png";
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "";
    }
}

