/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.ci.plugins.jobimport.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.bind.DatatypeConverter;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;

public final class URLUtils {
    public static InputStream fetchUrl2(String url, String username, String password) throws MalformedURLException, IOException {
        URLUtils.notNull(url);
        URLUtils.notNull(username);
        URLUtils.notNull(password);
        URLConnection conn = new URL(url).openConnection();
        if (!username.isEmpty()) {
            conn.setRequestProperty("Authorization", "Basic " + DatatypeConverter.printBase64Binary((byte[])(username + ":" + password).getBytes()));
        }
        return conn.getInputStream();
    }

    public static void notNull(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
    }

    public static InputStream fetchUrl(String url, String username, String password) throws MalformedURLException, IOException {
        URLUtils.notNull(url);
        URLUtils.notNull(username);
        URLUtils.notNull(password);
        HttpClientBuilder builder = HttpClients.custom();
        HttpClientContext localContext = HttpClientContext.create();
        URL _url = new URL(url);
        HttpHost target = new HttpHost(_url.getHost(), _url.getPort(), _url.getProtocol());
        if (!username.isEmpty()) {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(_url.getHost(), _url.getPort()), (Credentials)new UsernamePasswordCredentials(username, password));
            builder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicAuth = new BasicScheme();
            authCache.put(target, (AuthScheme)basicAuth);
            localContext.setAuthCache((AuthCache)authCache);
        }
        return builder.build().execute(target, (HttpRequest)new HttpGet(url), (HttpContext)localContext).getEntity().getContent();
    }

    public static String safeURL(String base, String sufix) {
        if (base.endsWith("/") && sufix.startsWith("/")) {
            return base.substring(0, base.length() - 1) + sufix;
        }
        if (base.endsWith("/") && !sufix.startsWith("/")) {
            return base + sufix;
        }
        if (!base.endsWith("/") && sufix.startsWith("/")) {
            return base + sufix;
        }
        return base + "/" + sufix;
    }

    private URLUtils() {
    }
}

