/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.ci.plugins.jobimport;

import com.cloudbees.hudson.plugins.folder.Folder;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import hudson.Extension;
import hudson.PluginManager;
import hudson.model.AbstractItem;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Node;
import hudson.model.RootAction;
import hudson.model.TopLevelItem;
import hudson.security.ACL;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.security.PermissionScope;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkins.ci.plugins.jobimport.JobImportGlobalConfig;
import org.jenkins.ci.plugins.jobimport.Messages;
import org.jenkins.ci.plugins.jobimport.MessagesUtils;
import org.jenkins.ci.plugins.jobimport.RemoteItemImportStatus;
import org.jenkins.ci.plugins.jobimport.client.RestApiClient;
import org.jenkins.ci.plugins.jobimport.model.JenkinsSite;
import org.jenkins.ci.plugins.jobimport.model.RemoteFolder;
import org.jenkins.ci.plugins.jobimport.model.RemoteItem;
import org.jenkins.ci.plugins.jobimport.utils.CredentialsUtils;
import org.jenkins.ci.plugins.jobimport.utils.RemoteItemUtils;
import org.jenkins.ci.plugins.jobimport.utils.URLUtils;
import org.kohsuke.stapler.ForwardToView;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Extension
public final class JobImportAction
implements RootAction,
Describable<JobImportAction> {
    public static final PermissionGroup JOB_IMPORT_PERMISSIONS = new PermissionGroup(JobImportAction.class, Messages._Job_Import_Plugin_PermissionGroup());
    public static final Permission JOB_IMPORT = new Permission(JOB_IMPORT_PERMISSIONS, "JobImport", Messages._Job_Import_Plugin_Permission(), Jenkins.ADMINISTER, PermissionScope.JENKINS);
    private static final Logger LOG = Logger.getLogger(JobImportAction.class.getName());

    public void doClear(StaplerRequest request, StaplerResponse response) throws ServletException, IOException {
        response.sendRedirect(Jenkins.get().getRootUrl() + this.getUrlName());
    }

    public void doImport(StaplerRequest request, StaplerResponse response) throws ServletException, IOException {
        TreeMap<RemoteItem, RemoteItemImportStatus> remoteJobsImportStatus = new TreeMap<RemoteItem, RemoteItemImportStatus>();
        String localFolder = request.getParameter("localFolder");
        String remoteJobsAvailable = request.getParameter("remoteJobsAvailable");
        String site = request.getParameter("remoteJenkins");
        JenkinsSite remoteJenkins = new JenkinsSite("", "");
        for (JenkinsSite js : JobImportGlobalConfig.get().getSites()) {
            if (!(js.getName() + "-" + js.getUrl() + "-" + js.getDefaultCredentialsId()).equals(site)) continue;
            remoteJenkins = js;
            break;
        }
        String credentialId = remoteJenkins.getDefaultCredentialsId();
        TreeSet<RemoteItem> remoteJobs = new TreeSet<RemoteItem>();
        String remoteFolder = request.getParameter("remoteFolder");
        String remoteUrl = URLUtils.safeURL(remoteJenkins.getUrl(), remoteFolder);
        String recursiveSearch = request.getParameter("recursiveSearch");
        this.doQueryInternal(null, remoteUrl, CredentialsUtils.getCredentials(credentialId), recursiveSearch, remoteJobs);
        if (remoteJobsAvailable != null && remoteJobsAvailable.equalsIgnoreCase("true") && request.hasParameter("jobUrl")) {
            for (String jobUrl : Arrays.asList(request.getParameterValues("jobUrl"))) {
                this.doImportInternal(jobUrl, localFolder, credentialId, this.shouldInstallPlugins(request.getParameter("plugins")), this.shouldUpdate(request.getParameter("update")), remoteJobs, remoteJobsImportStatus);
            }
        }
        new ForwardToView((Object)this, "index").with("step2", (Object)"true").with("remoteJobsAvailable", (Object)remoteJobsAvailable).with("remoteJobsImportStatus", remoteJobsImportStatus).with("remoteJobsImportStatusAvailable", (Object)(remoteJobsImportStatus.size() > 0 ? 1 : 0)).generateResponse(request, response, (Object)this);
    }

    public void doQuery(StaplerRequest request, StaplerResponse response) throws ServletException, IOException {
        TreeSet<RemoteItem> remoteJobs = new TreeSet<RemoteItem>();
        String remoteFolder = request.getParameter("remoteFolder");
        String site = request.getParameter("_.jenkinsSites");
        JenkinsSite remoteJenkins = new JenkinsSite("", "");
        for (JenkinsSite js : JobImportGlobalConfig.get().getSites()) {
            if (!(js.getName() + "-" + js.getUrl() + "-" + js.getDefaultCredentialsId()).equals(site)) continue;
            remoteJenkins = js;
            break;
        }
        String credentialId = remoteJenkins.getDefaultCredentialsId();
        String remoteUrl = URLUtils.safeURL(remoteJenkins.getUrl(), remoteFolder);
        String recursiveSearch = request.getParameter("recursiveSearch");
        this.doQueryInternal(null, remoteUrl, CredentialsUtils.getCredentials(credentialId), recursiveSearch, remoteJobs);
        new ForwardToView((Object)this, "index").with("step1", (Object)"true").with("remoteJenkins", (Object)(remoteJenkins.getName() + "-" + remoteJenkins.getUrl() + "-" + remoteJenkins.getDefaultCredentialsId())).with("remoteJobs", remoteJobs).with("remoteFolder", (Object)remoteFolder).with("recursiveSearch", (Object)recursiveSearch).with("remoteJobsAvailable", (Object)(remoteJobs.size() > 0 ? 1 : 0)).generateResponse(request, response, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doImportInternal(String jobUrl, String localPath, String credentialId, boolean installPlugins, boolean update, SortedSet<RemoteItem> remoteJobs, SortedMap<RemoteItem, RemoteItemImportStatus> remoteJobsImportStatus) throws IOException {
        InputStream inputStream;
        block20: {
            RemoteItem remoteJob = RemoteItemUtils.getRemoteJob(remoteJobs, jobUrl);
            if (remoteJob == null) return;
            if (!remoteJobsImportStatus.containsKey(remoteJob)) {
                remoteJobsImportStatus.put(remoteJob, new RemoteItemImportStatus(remoteJob));
            }
            if (!update && StringUtils.isNotEmpty((String)localPath) && Jenkins.get().getItemByFullName(localPath + remoteJob.getName()) != null) {
                ((RemoteItemImportStatus)remoteJobsImportStatus.get(remoteJob)).setStatus(MessagesUtils.formatFailedDuplicateJobName());
                return;
            }
            if (!update && StringUtils.isEmpty((String)localPath) && Jenkins.get().getItem(remoteJob.getName()) != null) {
                ((RemoteItemImportStatus)remoteJobsImportStatus.get(remoteJob)).setStatus(MessagesUtils.formatFailedDuplicateJobName());
                return;
            }
            inputStream = null;
            CredentialsUtils.NullSafeCredentials credentials = CredentialsUtils.getCredentials(credentialId);
            try {
                TopLevelItem newItem;
                inputStream = URLUtils.fetchUrl(remoteJob.getUrl() + "/config.xml", credentials.username, credentials.password);
                if (StringUtils.isNotEmpty((String)localPath) && !StringUtils.equals((String)"/", (String)localPath.trim())) {
                    String fullName = localPath.endsWith("/") ? localPath + remoteJob.getFullName() : localPath + "/" + remoteJob.getFullName();
                    Item currentItem = Jenkins.get().getItemByFullName(localPath);
                    if (update && currentItem instanceof AbstractItem) {
                        ((AbstractItem)currentItem).updateByXml((Source)new StreamSource(inputStream));
                        newItem = currentItem;
                    } else {
                        newItem = ((Folder)Jenkins.get().getItemByFullName(localPath, Folder.class)).createProjectFromXML(remoteJob.getFullName(), inputStream);
                    }
                } else {
                    Item currentItem = Jenkins.get().getItemByFullName(remoteJob.getFullName());
                    if (update && currentItem instanceof AbstractItem) {
                        ((AbstractItem)currentItem).updateByXml((Source)new StreamSource(inputStream));
                        newItem = currentItem;
                    } else {
                        newItem = Jenkins.get().createProjectFromXML(remoteJob.getFullName(), inputStream);
                    }
                }
                if (newItem != null) {
                    if (installPlugins) {
                        Jenkins instance = Jenkins.get();
                        instance.getAuthorizationStrategy().getACL((Node)instance).checkPermission(Jenkins.ADMINISTER);
                        PluginManager.createDefault((Jenkins)Jenkins.get()).prevalidateConfig(URLUtils.fetchUrl(remoteJob.getUrl() + "/config.xml", credentials.username, credentials.password));
                    }
                    newItem.save();
                }
                ((RemoteItemImportStatus)remoteJobsImportStatus.get(remoteJob)).setStatus(MessagesUtils.formatSuccess());
                if (!remoteJob.isFolder() || !((RemoteFolder)remoteJob).hasChildren()) break block20;
                for (RemoteItem childJob : ((RemoteFolder)remoteJob).getChildren()) {
                    this.doImportInternal(childJob.getUrl(), newItem.getFullName(), credentialId, installPlugins, update, remoteJobs, remoteJobsImportStatus);
                }
            }
            catch (Exception e) {
                try {
                    LOG.warning("Job Import Failed: " + e.getMessage());
                    if (LOG.isLoggable(Level.INFO)) {
                        LOG.log(Level.INFO, e.getMessage(), e);
                    }
                    ((RemoteItemImportStatus)remoteJobsImportStatus.get(remoteJob)).setStatus(MessagesUtils.formatFailedException(e));
                    try {
                        TopLevelItem created = Jenkins.get().getItem(remoteJob.getName());
                        if (created != null) {
                            created.delete();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)inputStream);
                return;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return;
    }

    private void doQueryInternal(RemoteFolder parent, String url, CredentialsUtils.NullSafeCredentials credentials, String recursiveSearch, SortedSet<RemoteItem> remoteJobs) {
        remoteJobs.addAll(RestApiClient.getRemoteItems(parent, url, credentials, this.isRecursive(recursiveSearch)));
    }

    private boolean isRecursive(String param) {
        return StringUtils.equals((String)"on", (String)param);
    }

    private boolean shouldInstallPlugins(String param) {
        return StringUtils.equals((String)"on", (String)param);
    }

    private boolean shouldUpdate(String param) {
        return StringUtils.equals((String)"on", (String)param);
    }

    public String getRootUrl() {
        return Jenkins.get().getRootUrl();
    }

    public String getDisplayName() {
        return Messages.DisplayName();
    }

    public String getIconFileName() {
        return "/images/32x32/setting.png";
    }

    public String getUrlName() {
        return "/job-import";
    }

    public Descriptor<JobImportAction> getDescriptor() {
        return Jenkins.get().getDescriptorOrDie(this.getClass());
    }

    @Extension
    public static final class JobImportActionDescriptor
    extends Descriptor<JobImportAction> {
        public String getDisplayName() {
            return "";
        }

        public ListBoxModel doFillCredentialIdItems() {
            return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(Jenkins.getAuthentication(), (ItemGroup)Jenkins.getInstanceOrNull(), StandardUsernamePasswordCredentials.class, Collections.emptyList(), CredentialsMatchers.always()).includeMatchingAs(ACL.SYSTEM, (ItemGroup)Jenkins.getInstanceOrNull(), StandardUsernamePasswordCredentials.class, Collections.emptyList(), CredentialsMatchers.always());
        }

        public ListBoxModel doFillJenkinsSitesItems() {
            ListBoxModel listBoxModel = new ListBoxModel();
            JobImportGlobalConfig.get().getSites().stream().forEach(s -> listBoxModel.add(s.getName(), s.getName() + "-" + s.getUrl() + "-" + s.getDefaultCredentialsId()));
            return listBoxModel;
        }
    }
}

