/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.utils;

import com.redhat.jenkins.plugins.ci.GlobalCIConfiguration;
import com.redhat.jenkins.plugins.ci.messaging.JMSMessagingWorker;
import com.redhat.jenkins.plugins.ci.messaging.data.SendResult;
import com.redhat.jenkins.plugins.ci.provider.data.ProviderData;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Logger;

public class MessageUtils {
    private static final Logger log = Logger.getLogger(MessageUtils.class.getName());
    public static final String JSON_TYPE = "application/json";

    public static SendResult sendMessage(Run<?, ?> build, TaskListener listener, ProviderData pdata) throws InterruptedException, IOException {
        log.info("Sending message for job '" + build.getParent().getName() + "'.");
        listener.getLogger().println("Sending message for job '" + build.getParent().getName() + "'.");
        GlobalCIConfiguration config = GlobalCIConfiguration.get();
        JMSMessagingWorker worker = config.getProvider(pdata.getName()).createWorker(pdata, build.getParent().getName());
        return worker.sendMessage(build, listener, pdata);
    }

    private static void logIfPossible(PrintStream stream, String logMessage) {
        if (stream != null) {
            stream.println(logMessage);
        }
    }

    public static enum MESSAGE_TYPE {
        CodeQualityChecksDone("code-quality-checks-done"),
        ComponentBuildDone("component-build-done"),
        Custom("custom"),
        EarlyPerformanceTestingDone("early-performance-testing-done"),
        EarlySecurityTestingDone("early-security-testing-done"),
        ImageUploaded("image-uploaded"),
        FunctionalTestCoverageDone("functional-test-coverage-done"),
        FunctionalTestingDone("functional-testing-done"),
        NonfunctionalTestingDone("nonfunctional-testing-done"),
        OotbTestingDone("ootb-testing-done"),
        PeerReviewDone("peer-review-done"),
        ProductAcceptedForReleaseTesting("product-accepted-for-release-testing"),
        ProductBuildDone("product-build-done"),
        ProductBuildInStaging("product-build-in-staging"),
        ProductTestCoverageDone("product-test-coverage-done"),
        PullRequest("pull-request"),
        SecurityChecksDone("security-checks-done"),
        TestingStarted("testing-started"),
        TestingCompleted("testing-completed"),
        Tier0TestingDone("tier-0-testing-done"),
        Tier1TestingDone("tier-1-testing-done"),
        Tier2IntegrationTestingDone("tier-2-integration-testing-done"),
        Tier2ValidationTestingDone("tier-2-validation-testing-done"),
        Tier3TestingDone("tier-3-testing-done"),
        UnitTestCoverageDone("unit-test-coverage-done"),
        UpdateDefectStatus("update-defect-status");

        private String message;

        private MESSAGE_TYPE(String value) {
            this.message = value;
        }

        public String getMessage() {
            return this.message;
        }

        public static MESSAGE_TYPE fromString(String value) {
            for (MESSAGE_TYPE t : MESSAGE_TYPE.values()) {
                if (!value.equalsIgnoreCase(t.name())) continue;
                return t;
            }
            return null;
        }

        public String toDisplayName() {
            String v = this.name();
            if (v == null || v.isEmpty()) {
                return v;
            }
            StringBuilder result = new StringBuilder();
            result.append(v.charAt(0));
            for (int i = 1; i < v.length(); ++i) {
                if (Character.isUpperCase(v.charAt(i))) {
                    result.append(" ");
                }
                result.append(v.charAt(i));
            }
            return result.toString();
        }
    }
}

