/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.jenkins.plugins.ci.pipeline;

import com.google.common.collect.ImmutableSet;
import com.redhat.jenkins.plugins.ci.CIMessageNotifier;
import com.redhat.jenkins.plugins.ci.GlobalCIConfiguration;
import com.redhat.jenkins.plugins.ci.Messages;
import com.redhat.jenkins.plugins.ci.messaging.ActiveMqMessagingProvider;
import com.redhat.jenkins.plugins.ci.messaging.FedMsgMessagingProvider;
import com.redhat.jenkins.plugins.ci.messaging.JMSMessagingProvider;
import com.redhat.jenkins.plugins.ci.messaging.MessagingProviderOverrides;
import com.redhat.jenkins.plugins.ci.messaging.data.SendResult;
import com.redhat.jenkins.plugins.ci.provider.data.ActiveMQPublisherProviderData;
import com.redhat.jenkins.plugins.ci.provider.data.FedMsgPublisherProviderData;
import com.redhat.jenkins.plugins.ci.provider.data.ProviderData;
import com.redhat.utils.MessageUtils;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import jenkins.util.Timer;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public class CIMessageSenderStep
extends Step {
    private String providerName;
    private MessagingProviderOverrides overrides;
    private MessageUtils.MESSAGE_TYPE messageType;
    private String messageProperties;
    private String messageContent;
    private boolean failOnError;

    public CIMessageSenderStep(String providerName, MessagingProviderOverrides overrides, MessageUtils.MESSAGE_TYPE messageType, String messageProperties, String messageContent) {
        this(providerName, overrides, messageType, messageProperties, messageContent, false);
    }

    @DataBoundConstructor
    public CIMessageSenderStep(String providerName, MessagingProviderOverrides overrides, MessageUtils.MESSAGE_TYPE messageType, String messageProperties, String messageContent, Boolean failOnError) {
        this.providerName = providerName;
        this.overrides = overrides;
        this.messageType = messageType;
        this.messageProperties = messageProperties;
        this.messageContent = messageContent;
        if (failOnError == null) {
            failOnError = false;
        }
        this.failOnError = failOnError;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public MessagingProviderOverrides getOverrides() {
        return this.overrides;
    }

    public void setOverrides(MessagingProviderOverrides overrides) {
        this.overrides = overrides;
    }

    public MessageUtils.MESSAGE_TYPE getMessageType() {
        return this.messageType;
    }

    public void setMessageType(MessageUtils.MESSAGE_TYPE messageType) {
        this.messageType = messageType;
    }

    public String getMessageProperties() {
        return this.messageProperties;
    }

    public void setMessageProperties(String messageProperties) {
        this.messageProperties = messageProperties;
    }

    public String getMessageContent() {
        return this.messageContent;
    }

    public void setMessageContent(String messageContent) {
        this.messageContent = messageContent;
    }

    public boolean getFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    @Extension(optional=true)
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, Launcher.class, TaskListener.class);
        }

        public String getFunctionName() {
            return "sendCIMessage";
        }

        public String getDisplayName() {
            return Messages.MessageNotifier();
        }
    }

    public static final class Execution
    extends AbstractStepExecutionImpl {
        @Inject
        private transient CIMessageSenderStep step;
        private transient Future<?> task;
        private static final long serialVersionUID = 1L;

        Execution(CIMessageSenderStep step, StepContext context) {
            super(context);
            this.step = step;
        }

        public boolean start() throws Exception {
            if (this.step.getProviderName() == null) {
                throw new Exception("providerName not specified!");
            }
            this.task = Timer.get().submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        ProviderData pd = null;
                        JMSMessagingProvider p = GlobalCIConfiguration.get().getProvider(Execution.this.step.getProviderName());
                        if (p instanceof ActiveMqMessagingProvider) {
                            ActiveMQPublisherProviderData apd = new ActiveMQPublisherProviderData(Execution.this.step.getProviderName());
                            apd.setOverrides(Execution.this.step.getOverrides());
                            apd.setMessageType(Execution.this.step.getMessageType());
                            apd.setMessageProperties(Execution.this.step.getMessageProperties());
                            apd.setMessageContent(Execution.this.step.getMessageContent());
                            apd.setFailOnError(Execution.this.step.getFailOnError());
                            pd = apd;
                        } else if (p instanceof FedMsgMessagingProvider) {
                            FedMsgPublisherProviderData fpd = new FedMsgPublisherProviderData(Execution.this.step.getProviderName());
                            fpd.setOverrides(Execution.this.step.getOverrides());
                            fpd.setMessageContent(Execution.this.step.getMessageContent());
                            fpd.setFailOnError(Execution.this.step.getFailOnError());
                            pd = fpd;
                        }
                        CIMessageNotifier notifier = new CIMessageNotifier(pd);
                        StepContext c = Execution.this.getContext();
                        SendResult status = notifier.doMessageNotifier((Run)c.get(Run.class), (Launcher)c.get(Launcher.class), (TaskListener)c.get(TaskListener.class));
                        if (status.isSucceeded()) {
                            Execution.this.getContext().onSuccess((Object)status);
                        } else {
                            Execution.this.getContext().onFailure((Throwable)new Exception("Exception sending message. Please check server logs."));
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        Execution.this.getContext().onFailure((Throwable)e);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        Execution.this.getContext().onFailure((Throwable)e);
                    }
                }
            });
            return false;
        }

        public void stop(@Nonnull Throwable throwable) throws Exception {
            this.task.cancel(true);
        }
    }
}

