/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.jenkins.plugins.ci.messaging;

import com.redhat.jenkins.plugins.ci.CIMessageBuilder;
import com.redhat.jenkins.plugins.ci.CIMessageNotifier;
import com.redhat.jenkins.plugins.ci.CIMessageSubscriberBuilder;
import com.redhat.jenkins.plugins.ci.GlobalCIConfiguration;
import com.redhat.jenkins.plugins.ci.messaging.ActiveMqMessagingProvider;
import com.redhat.jenkins.plugins.ci.messaging.JMSMessagingProvider;
import com.redhat.jenkins.plugins.ci.provider.data.ActiveMQPublisherProviderData;
import com.redhat.jenkins.plugins.ci.provider.data.ActiveMQSubscriberProviderData;
import com.redhat.jenkins.plugins.ci.provider.data.FedMsgPublisherProviderData;
import com.redhat.jenkins.plugins.ci.provider.data.FedMsgSubscriberProviderData;
import hudson.Extension;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractProject;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.Job;
import hudson.model.Project;
import java.io.IOException;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

@Extension
public class MessageProviderMigrator {
    private static final Logger log = Logger.getLogger(MessageProviderMigrator.class.getName());

    private static boolean updateCIMessageBuilder(AbstractProject<?, ?> p, CIMessageBuilder builder) {
        if (builder.getProviderData() == null) {
            JMSMessagingProvider prov;
            if (builder.getProviderName() == null) {
                builder.setProviderName(GlobalCIConfiguration.get().getConfigs().get(0).getName());
                try {
                    p.save();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if ((prov = GlobalCIConfiguration.get().getProvider(builder.getProviderName())) instanceof ActiveMqMessagingProvider) {
                ActiveMQPublisherProviderData apd = new ActiveMQPublisherProviderData(builder.getProviderName());
                apd.setOverrides(builder.getOverrides());
                apd.setMessageType(builder.getMessageType());
                apd.setMessageProperties(builder.getMessageProperties());
                apd.setMessageContent(builder.getMessageContent());
                apd.setFailOnError(builder.isFailOnError());
                builder.setProviderData(apd);
            } else {
                FedMsgPublisherProviderData fpd = new FedMsgPublisherProviderData(builder.getProviderName());
                fpd.setOverrides(builder.getOverrides());
                fpd.setMessageContent(builder.getMessageContent());
                fpd.setFailOnError(builder.isFailOnError());
                builder.setProviderData(fpd);
            }
            try {
                p.save();
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private static boolean updateCIMessageNotifier(AbstractProject<?, ?> p, CIMessageNotifier builder) {
        if (builder.getProviderData() == null) {
            JMSMessagingProvider prov;
            if (builder.getProviderName() == null) {
                builder.setProviderName(GlobalCIConfiguration.get().getConfigs().get(0).getName());
                try {
                    p.save();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if ((prov = GlobalCIConfiguration.get().getProvider(builder.getProviderName())) instanceof ActiveMqMessagingProvider) {
                ActiveMQPublisherProviderData apd = new ActiveMQPublisherProviderData(builder.getProviderName());
                apd.setOverrides(builder.getOverrides());
                apd.setMessageType(builder.getMessageType());
                apd.setMessageProperties(builder.getMessageProperties());
                apd.setMessageContent(builder.getMessageContent());
                apd.setFailOnError(builder.isFailOnError());
                builder.setProviderData(apd);
            } else {
                FedMsgPublisherProviderData fpd = new FedMsgPublisherProviderData(builder.getProviderName());
                fpd.setOverrides(builder.getOverrides());
                fpd.setMessageContent(builder.getMessageContent());
                fpd.setFailOnError(builder.isFailOnError());
                builder.setProviderData(fpd);
            }
            try {
                p.save();
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private static boolean updateCIMessageSubscriberBuilder(AbstractProject<?, ?> p, CIMessageSubscriberBuilder builder) {
        if (builder.getProviderData() == null) {
            JMSMessagingProvider prov;
            if (builder.getProviderName() == null) {
                builder.setProviderName(GlobalCIConfiguration.get().getConfigs().get(0).getName());
                try {
                    p.save();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if ((prov = GlobalCIConfiguration.get().getProvider(builder.getProviderName())) instanceof ActiveMqMessagingProvider) {
                ActiveMQSubscriberProviderData apd = new ActiveMQSubscriberProviderData(builder.getProviderName());
                apd.setOverrides(builder.getOverrides());
                apd.setSelector(builder.getSelector());
                apd.setChecks(builder.getChecks());
                apd.setVariable(builder.getVariable());
                apd.setTimeout(builder.getTimeout());
                builder.setProviderData(apd);
            } else {
                FedMsgSubscriberProviderData fpd = new FedMsgSubscriberProviderData(builder.getProviderName());
                fpd.setOverrides(builder.getOverrides());
                fpd.setVariable(builder.getVariable());
                fpd.setTimeout(builder.getTimeout());
                builder.setProviderData(fpd);
            }
            try {
                p.save();
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Initializer(after=InitMilestone.JOB_LOADED)
    public static void migrateCIMessageBuilders() {
        Jenkins instance = Jenkins.getInstance();
        if (instance == null) {
            return;
        }
        if (GlobalCIConfiguration.get().isMigrationInProgress()) {
            log.info("isMigrationInProgress - > true | Forcing GlobalCIConfiguration.save()");
            GlobalCIConfiguration.get().save();
        }
        int updatedCount = 0;
        log.info("Attempting to migrate all CIMessageBuilders, CIMessageNotifier and CIMessageSubscriberBuilders build/publish steps");
        for (BuildableItemWithBuildWrappers item : instance.getItems(BuildableItemWithBuildWrappers.class)) {
            Project p;
            Job job = (Job)item;
            if (job instanceof Project) {
                p = (Project)item.asProject();
                for (Object builderObj : p.getBuildersList().getAll(CIMessageBuilder.class)) {
                    if (!MessageProviderMigrator.updateCIMessageBuilder(p, (CIMessageBuilder)((Object)builderObj))) continue;
                    ++updatedCount;
                }
                for (Object notifierObj : p.getPublishersList().getAll(CIMessageNotifier.class)) {
                    if (!MessageProviderMigrator.updateCIMessageNotifier(p, (CIMessageNotifier)((Object)notifierObj))) continue;
                    ++updatedCount;
                }
                for (Object builderObj : p.getBuildersList().getAll(CIMessageSubscriberBuilder.class)) {
                    if (!MessageProviderMigrator.updateCIMessageSubscriberBuilder(p, (CIMessageSubscriberBuilder)((Object)builderObj))) continue;
                    ++updatedCount;
                }
            }
            if (!(job instanceof MatrixProject)) continue;
            p = (MatrixProject)item.asProject();
            for (Object builderObj : p.getBuildersList().getAll(CIMessageBuilder.class)) {
                if (!MessageProviderMigrator.updateCIMessageBuilder(p, (CIMessageBuilder)((Object)builderObj))) continue;
                ++updatedCount;
            }
            for (Object notifierObj : p.getPublishersList().getAll(CIMessageNotifier.class)) {
                if (!MessageProviderMigrator.updateCIMessageNotifier(p, (CIMessageNotifier)((Object)notifierObj))) continue;
                ++updatedCount;
            }
            for (Object builderObj : p.getBuildersList().getAll(CIMessageSubscriberBuilder.class)) {
                if (!MessageProviderMigrator.updateCIMessageSubscriberBuilder(p, (CIMessageSubscriberBuilder)((Object)builderObj))) continue;
                ++updatedCount;
            }
        }
        log.info("Updated " + updatedCount + " build/publish step(s)");
    }
}

