/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.jenkins.plugins.ci.messaging;

import com.redhat.jenkins.plugins.ci.CIBuildTrigger;
import com.redhat.jenkins.plugins.ci.messaging.JMSMessagingProvider;
import com.redhat.jenkins.plugins.ci.messaging.MessagingProviderOverrides;
import com.redhat.jenkins.plugins.ci.messaging.data.SendResult;
import com.redhat.jenkins.plugins.ci.provider.data.ProviderData;
import com.redhat.utils.PluginUtils;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class JMSMessagingWorker {
    public static final String MESSAGECONTENTFIELD = "message-content";
    public String jobname;
    private static final Logger log = Logger.getLogger(JMSMessagingWorker.class.getName());
    public static final Integer RETRY_MINUTES = 1;
    protected MessagingProviderOverrides overrides;
    protected String topic;

    public boolean subscribe(String jobname) {
        return this.subscribe(jobname, null);
    }

    public abstract boolean subscribe(String var1, String var2);

    public abstract void unsubscribe(String var1);

    public abstract void receive(String var1, ProviderData var2);

    public abstract boolean connect() throws Exception;

    public abstract boolean isConnected();

    public abstract boolean isConnectedAndSubscribed();

    public abstract void disconnect();

    public abstract SendResult sendMessage(Run<?, ?> var1, TaskListener var2, ProviderData var3);

    public abstract String waitForMessage(Run<?, ?> var1, TaskListener var2, ProviderData var3);

    public void trigger(String jobname, String messageSummary, Map<String, String> params) {
        CIBuildTrigger trigger = CIBuildTrigger.findTrigger(jobname);
        if (trigger != null) {
            log.info("Scheduling job '" + jobname + "' based on message:\n" + messageSummary);
            trigger.scheduleBuild(params);
        } else {
            log.log(Level.WARNING, "Unable to find CIBuildTrigger for '" + jobname + "'.");
        }
    }

    public abstract void prepareForInterrupt();

    public abstract boolean isBeingInterrupted();

    protected String getTopic(JMSMessagingProvider provider) {
        String ltopic = this.overrides != null && this.overrides.getTopic() != null && !this.overrides.getTopic().isEmpty() ? this.overrides.getTopic() : (provider.getTopic() != null && !provider.getTopic().isEmpty() ? provider.getTopic() : "org.fedoraproject");
        return PluginUtils.getSubstitutedValue(ltopic, null);
    }
}

