/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.jenkins.plugins.ci.messaging;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.redhat.jenkins.plugins.ci.messaging.JMSMessageWatcher;
import com.redhat.jenkins.plugins.ci.messaging.JMSMessagingWorker;
import com.redhat.jenkins.plugins.ci.messaging.checks.MsgCheck;
import com.redhat.jenkins.plugins.ci.provider.data.ProviderData;
import hudson.ExtensionList;
import hudson.model.Describable;
import hudson.model.Descriptor;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public abstract class JMSMessagingProvider
implements Describable<JMSMessagingProvider>,
Serializable {
    private static final long serialVersionUID = -4572907003185115933L;
    protected String name;
    protected String topic;
    protected static final Logger log = Logger.getLogger(JMSMessagingProvider.class.getName());
    public static final String DEFAULT_PROVIDERNAME = "default";

    public String getName() {
        return this.name;
    }

    public String getTopic() {
        return this.topic;
    }

    public abstract JMSMessagingWorker createWorker(ProviderData var1, String var2);

    public abstract JMSMessageWatcher createWatcher();

    public boolean verify(String json, List<MsgCheck> checks) {
        if (checks != null && checks.size() > 0) {
            if (StringUtils.isBlank((CharSequence)json)) {
                return false;
            }
            DocumentContext context = JsonPath.parse((String)json);
            for (MsgCheck check : checks) {
                if (this.verify(context, check)) continue;
                log.fine("msg check: " + check.toString() + " failed against: " + json);
                return false;
            }
            log.fine("All msg checks have passed.");
        }
        return true;
    }

    private boolean verify(DocumentContext context, MsgCheck check) {
        String aVal = "";
        String field = StringUtils.prependIfMissing((String)check.getField(), (CharSequence)"$.", (CharSequence[])new CharSequence[0]);
        try {
            aVal = context.read(field, new Predicate[0]).toString();
        }
        catch (PathNotFoundException pnfe) {
            log.fine(pnfe.getMessage());
            return false;
        }
        String eVal = StringUtils.defaultString((String)check.getExpectedValue());
        return Pattern.compile(eVal).matcher(aVal).find();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JMSMessagingProvider that = (JMSMessagingProvider)o;
        return new EqualsBuilder().append((Object)this.name, (Object)that.name).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.name).toHashCode();
    }

    public static abstract class MessagingProviderDescriptor
    extends Descriptor<JMSMessagingProvider> {
        public static ExtensionList<MessagingProviderDescriptor> all() {
            return Jenkins.getInstance().getExtensionList(MessagingProviderDescriptor.class);
        }
    }
}

