/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.jenkins.plugins.ci;

import com.redhat.jenkins.plugins.ci.CIBuildTrigger;
import com.redhat.jenkins.plugins.ci.CITriggerThread;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.BuildableItem;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.listeners.ItemListener;
import java.util.logging.Logger;
import jenkins.model.ParameterizedJobMixIn;

@Extension
public class ProjectChangeListener
extends ItemListener {
    private static final Logger log = Logger.getLogger(ProjectChangeListener.class.getName());

    public void onDeleted(Item item) {
        if (item instanceof Job) {
            CIBuildTrigger.force(item.getFullName());
        }
    }

    public void onLocationChanged(Item item, String oldFullName, String newFullName) {
        CIBuildTrigger cibt;
        if (item instanceof Job && (cibt = (CIBuildTrigger)ParameterizedJobMixIn.getTrigger((Job)((Job)item), CIBuildTrigger.class)) != null) {
            cibt.rename(oldFullName);
        }
    }

    public void onUpdated(Item item) {
        super.onUpdated(item);
        CIBuildTrigger cibt = CIBuildTrigger.findTrigger(item.getFullName());
        if (cibt != null) {
            if (item instanceof AbstractProject) {
                AbstractProject project = (AbstractProject)item;
                CITriggerThread triggerThread = (CITriggerThread)CIBuildTrigger.triggerInfo.get(item.getFullName());
                if (triggerThread != null) {
                    log.info("Getting thread: " + triggerThread.getId());
                }
                if (triggerThread != null && project.isDisabled()) {
                    log.info("Job " + item.getFullName() + " may have been previously been enabled. But now disabled. Attempting to stop Trigger Thread...");
                    CIBuildTrigger.force(item.getFullName());
                } else if (triggerThread == null && !project.isDisabled()) {
                    log.info("Job " + item.getFullName() + " may have been previously been disabled. Attempting to start Trigger Thread...");
                    cibt.start((BuildableItem)item, false);
                }
            }
        } else {
            log.info("No CIBuildTrigger found, forcing thread stop.");
            CIBuildTrigger.force(item.getFullName());
        }
    }
}

