/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.jenkins.plugins.ci;

import com.redhat.jenkins.plugins.ci.GlobalCIConfiguration;
import com.redhat.jenkins.plugins.ci.Messages;
import com.redhat.jenkins.plugins.ci.messaging.JMSMessagingProvider;
import com.redhat.jenkins.plugins.ci.messaging.JMSMessagingWorker;
import com.redhat.jenkins.plugins.ci.messaging.MessagingProviderOverrides;
import com.redhat.jenkins.plugins.ci.messaging.checks.MsgCheck;
import com.redhat.jenkins.plugins.ci.provider.data.ProviderData;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

public class CIMessageSubscriberBuilder
extends Builder {
    private static final Logger log = Logger.getLogger(CIMessageSubscriberBuilder.class.getName());
    private static final String BUILDER_NAME = Messages.SubscriberBuilder();
    private transient String providerName;
    private transient MessagingProviderOverrides overrides;
    private transient String selector;
    private transient String variable;
    private transient List<MsgCheck> checks = new ArrayList<MsgCheck>();
    private transient Integer timeout;
    private ProviderData providerData;

    @DataBoundConstructor
    public CIMessageSubscriberBuilder() {
    }

    public CIMessageSubscriberBuilder(ProviderData providerData) {
        this.providerData = providerData;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public MessagingProviderOverrides getOverrides() {
        return this.overrides;
    }

    public void setOverrides(MessagingProviderOverrides overrides) {
        this.overrides = overrides;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public String getVariable() {
        return this.variable;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    public List<MsgCheck> getChecks() {
        return this.checks;
    }

    public void setChecks(List<MsgCheck> checks) {
        this.checks = checks;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public ProviderData getProviderData() {
        return this.providerData;
    }

    @DataBoundSetter
    public void setProviderData(ProviderData providerData) {
        this.providerData = providerData;
    }

    public JMSMessagingProvider getProvider() {
        return GlobalCIConfiguration.get().getProvider(this.providerData.getName());
    }

    public String waitforCIMessage(Run<?, ?> build, Launcher launcher, TaskListener listener) {
        JMSMessagingProvider provider = GlobalCIConfiguration.get().getProvider(this.providerData.getName());
        if (provider == null) {
            listener.error("Failed to locate JMSMessagingProvider with name " + this.providerData.getName() + ". You must update the job configuration.");
            return null;
        }
        JMSMessagingWorker worker = provider.createWorker(this.providerData, build.getParent().getName());
        return worker.waitForMessage(build, listener, this.providerData);
    }

    public boolean doMessageSubscribe(Run<?, ?> run, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        return this.waitforCIMessage(run, launcher, listener) != null;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        return this.doMessageSubscribe((Run<?, ?>)build, launcher, (TaskListener)listener);
    }

    @Extension
    public static class CIMessageSubscriberBuilderDescriptor
    extends BuildStepDescriptor<Builder> {
        public String getDisplayName() {
            return BUILDER_NAME;
        }

        public CIMessageSubscriberBuilder newInstance(StaplerRequest sr, JSONObject jo) {
            try {
                jo.getJSONObject("providerData").put("name", jo.remove(""));
                return (CIMessageSubscriberBuilder)super.newInstance(sr, jo);
            }
            catch (Descriptor.FormException e) {
                log.log(Level.SEVERE, "Unable to create new instance.", e);
                return null;
            }
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public boolean configure(StaplerRequest sr, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(sr, formData);
        }
    }
}

