/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.jenkins.plugins.ci;

import com.redhat.jenkins.plugins.ci.Messages;
import com.redhat.jenkins.plugins.ci.messaging.MessagingProviderOverrides;
import com.redhat.jenkins.plugins.ci.messaging.data.SendResult;
import com.redhat.jenkins.plugins.ci.provider.data.ProviderData;
import com.redhat.utils.MessageUtils;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

public class CIMessageNotifier
extends Notifier {
    private static final Logger log = Logger.getLogger(CIMessageNotifier.class.getName());
    private static final String BUILDER_NAME = Messages.MessageNotifier();
    private transient String providerName;
    private transient MessagingProviderOverrides overrides;
    private transient MessageUtils.MESSAGE_TYPE messageType;
    private transient String messageProperties;
    private transient String messageContent;
    private transient boolean failOnError = false;
    private ProviderData providerData;

    @DataBoundConstructor
    public CIMessageNotifier() {
    }

    public CIMessageNotifier(ProviderData providerData) {
        this.providerData = providerData;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public MessagingProviderOverrides getOverrides() {
        return this.overrides;
    }

    public void setOverrides(MessagingProviderOverrides overrides) {
        this.overrides = overrides;
    }

    public MessageUtils.MESSAGE_TYPE getMessageType() {
        return this.messageType;
    }

    public void setMessageType(MessageUtils.MESSAGE_TYPE messageType) {
        this.messageType = messageType;
    }

    public String getMessageProperties() {
        return this.messageProperties;
    }

    public void setMessageProperties(String messageProperties) {
        this.messageProperties = messageProperties;
    }

    public String getMessageContent() {
        return this.messageContent;
    }

    public void setMessageContent(String messageContent) {
        this.messageContent = messageContent;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public ProviderData getProviderData() {
        return this.providerData;
    }

    @DataBoundSetter
    public void setProviderData(ProviderData providerData) {
        this.providerData = providerData;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public SendResult doMessageNotifier(Run<?, ?> run, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        return MessageUtils.sendMessage(run, listener, this.providerData);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        return this.doMessageNotifier((Run<?, ?>)build, launcher, (TaskListener)listener).isSucceeded();
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> arg0) {
            return true;
        }

        public CIMessageNotifier newInstance(StaplerRequest sr, JSONObject jo) {
            try {
                jo.getJSONObject("providerData").put("name", jo.remove(""));
                return (CIMessageNotifier)super.newInstance(sr, jo);
            }
            catch (Descriptor.FormException e) {
                log.log(Level.SEVERE, "Unable to create new instance.", e);
                return null;
            }
        }

        public String getDisplayName() {
            return BUILDER_NAME;
        }
    }
}

