/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.jenkins.plugins.ci;

import com.redhat.jenkins.plugins.ci.messaging.MessagingProviderOverrides;
import com.redhat.jenkins.plugins.ci.provider.data.ProviderData;
import com.redhat.utils.MessageUtils;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

public class CIMessageBuilder
extends Builder {
    private static final Logger log = Logger.getLogger(CIMessageBuilder.class.getName());
    private transient String providerName;
    private transient MessagingProviderOverrides overrides;
    private transient MessageUtils.MESSAGE_TYPE messageType;
    private transient String messageProperties;
    private transient String messageContent;
    private transient boolean failOnError = false;
    private ProviderData providerData;

    @DataBoundConstructor
    public CIMessageBuilder() {
    }

    public CIMessageBuilder(ProviderData providerData) {
        this.providerData = providerData;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public MessagingProviderOverrides getOverrides() {
        return this.overrides;
    }

    public void setOverrides(MessagingProviderOverrides overrides) {
        this.overrides = overrides;
    }

    public MessageUtils.MESSAGE_TYPE getMessageType() {
        return this.messageType;
    }

    public void setMessageType(MessageUtils.MESSAGE_TYPE messageType) {
        this.messageType = messageType;
    }

    public String getMessageProperties() {
        return this.messageProperties;
    }

    public void setMessageProperties(String messageProperties) {
        this.messageProperties = messageProperties;
    }

    public String getMessageContent() {
        return this.messageContent;
    }

    public void setMessageContent(String messageContent) {
        this.messageContent = messageContent;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public ProviderData getProviderData() {
        return this.providerData;
    }

    @DataBoundSetter
    public void setProviderData(ProviderData providerData) {
        this.providerData = providerData;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        return MessageUtils.sendMessage(build, (TaskListener)listener, this.providerData).isSucceeded();
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> arg0) {
            return true;
        }

        public CIMessageBuilder newInstance(StaplerRequest sr, JSONObject jo) {
            try {
                jo.getJSONObject("providerData").put("name", jo.remove(""));
                return (CIMessageBuilder)super.newInstance(sr, jo);
            }
            catch (Descriptor.FormException e) {
                log.log(Level.SEVERE, "Unable to create new instance.", e);
                return null;
            }
        }

        public String getDisplayName() {
            return "CI Notifier";
        }
    }
}

