/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.jenkins.plugins.ci;

import com.redhat.jenkins.plugins.ci.CIBuildCause;
import com.redhat.jenkins.plugins.ci.CIEnvironmentContributingAction;
import com.redhat.jenkins.plugins.ci.CIShouldScheduleQueueAction;
import com.redhat.jenkins.plugins.ci.CITriggerThread;
import com.redhat.jenkins.plugins.ci.GlobalCIConfiguration;
import com.redhat.jenkins.plugins.ci.Messages;
import com.redhat.jenkins.plugins.ci.messaging.ActiveMqMessagingProvider;
import com.redhat.jenkins.plugins.ci.messaging.FedMsgMessagingProvider;
import com.redhat.jenkins.plugins.ci.messaging.JMSMessagingProvider;
import com.redhat.jenkins.plugins.ci.messaging.MessagingProviderOverrides;
import com.redhat.jenkins.plugins.ci.messaging.checks.MsgCheck;
import com.redhat.jenkins.plugins.ci.provider.data.ActiveMQSubscriberProviderData;
import com.redhat.jenkins.plugins.ci.provider.data.FedMsgSubscriberProviderData;
import com.redhat.jenkins.plugins.ci.provider.data.ProviderData;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildableItem;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.StringParameterValue;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class CIBuildTrigger
extends Trigger<BuildableItem> {
    private static final Logger log = Logger.getLogger(CIBuildTrigger.class.getName());
    private transient String providerName;
    private transient String selector;
    private transient List<MsgCheck> checks = new ArrayList<MsgCheck>();
    private transient MessagingProviderOverrides overrides;
    private Boolean noSquash;
    private ProviderData providerData;
    public static final transient ConcurrentMap<String, CITriggerThread> triggerInfo = new ConcurrentHashMap<String, CITriggerThread>();
    public static final transient ConcurrentMap<String, Object> locks = new ConcurrentHashMap<String, Object>();
    private transient boolean providerUpdated;
    private static volatile ParametersActionInspection parametersInspectionCache = null;

    @DataBoundConstructor
    public CIBuildTrigger() {
    }

    public CIBuildTrigger(Boolean noSquash, ProviderData providerData) {
        this.noSquash = noSquash;
        this.providerData = providerData;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public List<MsgCheck> getChecks() {
        return this.checks;
    }

    public void setChecks(List<MsgCheck> checks) {
        this.checks = checks;
    }

    public MessagingProviderOverrides getOverrides() {
        return this.overrides;
    }

    public void setOverrides(MessagingProviderOverrides overrides) {
        this.overrides = overrides;
    }

    public Boolean getNoSquash() {
        return this.noSquash;
    }

    @DataBoundSetter
    public void setNoSquash(Boolean noSquash) {
        this.noSquash = noSquash;
    }

    public ProviderData getProviderData() {
        return this.providerData;
    }

    @DataBoundSetter
    public void setProviderData(ProviderData providerData) {
        this.providerData = providerData;
    }

    public static CIBuildTrigger findTrigger(String fullname) {
        Jenkins jenkins = Jenkins.getInstance();
        Job p = (Job)jenkins.getItemByFullName(fullname, Job.class);
        if (p != null) {
            return (CIBuildTrigger)ParameterizedJobMixIn.getTrigger((Job)p, CIBuildTrigger.class);
        }
        return null;
    }

    protected Object readResolve() throws ObjectStreamException {
        if (this.providerData == null) {
            JMSMessagingProvider provider;
            if (this.providerName == null) {
                log.info("Provider is null for trigger for job '" + this.getJobName() + "'.");
                provider = GlobalCIConfiguration.get().getConfigs().get(0);
                if (provider != null) {
                    this.providerName = provider.getName();
                    this.providerUpdated = true;
                    this.saveJob();
                }
            }
            if ((provider = GlobalCIConfiguration.get().getProvider(this.providerName)) != null) {
                if (provider instanceof ActiveMqMessagingProvider) {
                    log.info("Creating '" + this.providerName + "' trigger provider data for job '" + this.getJobName() + "'.");
                    ActiveMQSubscriberProviderData a = new ActiveMQSubscriberProviderData(this.providerName);
                    a.setSelector(this.selector);
                    a.setOverrides(this.overrides);
                    a.setChecks(this.checks);
                    this.providerData = a;
                    this.providerUpdated = true;
                    this.saveJob();
                } else if (provider instanceof FedMsgMessagingProvider) {
                    log.info("Creating '" + this.providerName + "' trigger provider data for job '" + this.getJobName() + "'.");
                    FedMsgSubscriberProviderData f = new FedMsgSubscriberProviderData(this.providerName);
                    f.setOverrides(this.overrides);
                    f.setChecks(this.checks);
                    this.providerData = f;
                    this.providerUpdated = true;
                    this.saveJob();
                }
            } else {
                log.warning("Unable to find provider '" + this.providerName + "', so unable to upgrade job.");
            }
        }
        return this;
    }

    public void start(BuildableItem project, boolean newInstance) {
        super.start((Item)project, newInstance);
        this.startTriggerThread();
    }

    public void stop() {
        super.stop();
        if (this.job != null) {
            this.stopTriggerThread(((BuildableItem)this.job).getFullName());
        } else {
            log.info("job is null! Not stopping trigger thread!");
        }
    }

    public static void force(String fullName) {
        CIBuildTrigger.stopTriggerThread(fullName, null);
    }

    public void rename(String oldFullName) {
        this.stopTriggerThread(oldFullName);
        this.startTriggerThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTriggerThread() {
        Object aJob;
        if (this.providerUpdated) {
            log.info("Saving job since messaging provider was migrated...");
            try {
                ((BuildableItem)this.job).save();
            }
            catch (IOException e) {
                log.warning("Exception while trying to save job: " + e.getMessage());
            }
        }
        if (this.job instanceof AbstractProject && (aJob = (AbstractProject)this.job).isDisabled()) {
            log.info("Job '" + ((BuildableItem)this.job).getFullName() + "' is disabled, not subscribing.");
            return;
        }
        try {
            aJob = CIBuildTrigger.getLock(((BuildableItem)this.job).getFullName());
            synchronized (aJob) {
                if (this.stopTriggerThread(((BuildableItem)this.job).getFullName()) == null) {
                    JMSMessagingProvider provider = GlobalCIConfiguration.get().getProvider(this.providerData.getName());
                    if (provider == null) {
                        log.log(Level.SEVERE, "Failed to locate JMSMessagingProvider with name " + this.providerData.getName() + ". You must update the job configuration. Trigger not started.");
                        return;
                    }
                    CITriggerThread trigger = new CITriggerThread(provider, this.providerData, ((BuildableItem)this.job).getFullName());
                    trigger.setName("CIBuildTrigger-" + ((BuildableItem)this.job).getFullName() + "-" + provider.getClass().getSimpleName());
                    trigger.setDaemon(true);
                    trigger.start();
                    log.info("Adding thread: " + trigger.getId());
                    triggerInfo.put(((BuildableItem)this.job).getFullName(), trigger);
                }
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Unhandled exception in trigger start.", e);
        }
    }

    private CITriggerThread stopTriggerThread(String fullName) {
        return CIBuildTrigger.stopTriggerThread(fullName, this.getComparisonThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CITriggerThread stopTriggerThread(String fullName, CITriggerThread comparisonThread) {
        Object object = CIBuildTrigger.getLock(fullName);
        synchronized (object) {
            CITriggerThread thread = (CITriggerThread)triggerInfo.get(fullName);
            if (thread != null) {
                if (thread.equals(comparisonThread)) {
                    log.info("Already have thread " + thread.getId() + "...");
                    return thread;
                }
                log.info("Stopping thread: " + thread.getId());
                try {
                    int waitCount;
                    for (waitCount = 0; waitCount <= 60 && !thread.isMessageProviderConnected(); ++waitCount) {
                        log.info("Thread " + thread.getId() + ": Message Provider is NOT connected AND subscribed. Sleeping 1 sec");
                        Thread.sleep(1000L);
                    }
                    if (waitCount > 60) {
                        log.warning("Wait time of 60 secs elapsed trying to connect before interrupting...");
                    }
                    thread.sendInterrupt();
                    thread.interrupt();
                    if (thread.isMessageProviderConnected()) {
                        log.info("Thread " + thread.getId() + ": Message Provider is connected and subscribed");
                        log.info("Thread " + thread.getId() + ": trying to join");
                        thread.join();
                    } else {
                        log.warning("Thread " + thread.getId() + " Message Provider is NOT connected AND subscribed;  join!");
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Unhandled exception in trigger stop.", e);
                }
                CITriggerThread thread2 = (CITriggerThread)triggerInfo.remove(fullName);
                if (thread2 != null) {
                    log.info("Removed thread: " + thread2.getId());
                }
                locks.remove(fullName);
                log.info("Removed thread LOCK");
            }
            return null;
        }
    }

    private CITriggerThread getComparisonThread() {
        if (this.providerData != null) {
            JMSMessagingProvider provider = GlobalCIConfiguration.get().getProvider(this.providerData.getName());
            CITriggerThread newThread = new CITriggerThread(provider, this.providerData, ((BuildableItem)this.job).getFullName());
            newThread.setName("CIBuildTrigger-" + ((BuildableItem)this.job).getFullName() + "-" + provider.getClass().getSimpleName());
            return newThread;
        }
        return null;
    }

    private static synchronized ParametersActionInspection getParametersInspection() {
        if (parametersInspectionCache == null) {
            parametersInspectionCache = new ParametersActionInspection();
        }
        return parametersInspectionCache;
    }

    protected ParametersAction createParameters(BuildableItem project, Map<String, String> messageParams) {
        List<ParameterValue> definedParameters = this.getDefinedParameters(project);
        List<ParameterValue> parameters = this.getUpdatedParameters(messageParams, definedParameters);
        try {
            Constructor constructor = ParametersAction.class.getConstructor(List.class);
            return (ParametersAction)constructor.newInstance(parameters);
        }
        catch (NoSuchMethodException e) {
            ParametersActionInspection inspection = CIBuildTrigger.getParametersInspection();
            if (inspection.isInspectionFailure()) {
                log.log(Level.WARNING, "Failed to inspect ParametersAction to determine if we can behave normally around SECURITY-170.\nSee https://wiki.jenkins-ci.org/display/SECURITY/Jenkins+Security+Advisory+2016-05-11 for information.");
            } else if (inspection.isHasSafeParameterConfig()) {
                StringBuilder txt = new StringBuilder("Running on a core with SECURITY-170 fixed but no direct way for Gerrit Trigger to self-specify safe parameters.");
                txt.append(" You should consider upgrading to a new Jenkins core version.\n");
                if (inspection.isKeepUndefinedParameters()) {
                    txt.append(".keepUndefinedParameters is set so the trigger should behave normally.");
                } else {
                    txt.append("No overriding system properties appears to be set,");
                    txt.append(" your builds might not work as expected.\n");
                    txt.append("See https://wiki.jenkins-ci.org/display/SECURITY/Jenkins+Security+Advisory+2016-05-11");
                    txt.append(" for information.");
                }
                log.log(Level.WARNING, txt.toString());
            } else {
                log.log(Level.FINE, "Running on an old core before safe parameters, we should be safe.");
            }
        }
        catch (IllegalAccessException e) {
            log.log(Level.WARNING, "Running on a core with safe parameters fix available, but not allowed to specify them");
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Running on a core with safe parameters fix available, but failed to provide them");
        }
        return new ParametersAction(parameters);
    }

    public void scheduleBuild(Map<String, String> messageParams) {
        ParametersAction parameters = this.createParameters((BuildableItem)this.job, messageParams);
        List<ParameterValue> definedParameters = this.getDefinedParameters((BuildableItem)this.job);
        List<ParameterValue> buildParameters = this.getUpdatedParameters(messageParams, definedParameters);
        ParameterizedJobMixIn jobMixIn = new ParameterizedJobMixIn(){

            protected Job<?, ?> asJob() {
                return (Job)CIBuildTrigger.this.job;
            }
        };
        jobMixIn.scheduleBuild2(0, new Action[]{new CauseAction((Cause)new CIBuildCause()), parameters, new CIEnvironmentContributingAction(messageParams, buildParameters), new CIShouldScheduleQueueAction(this.noSquash)});
    }

    private List<ParameterValue> getUpdatedParameters(Map<String, String> messageParams, List<ParameterValue> definedParams) {
        HashMap<String, Object> newParams = new HashMap<String, Object>();
        for (ParameterValue def : definedParams) {
            newParams.put(def.getName(), def);
        }
        for (String key : messageParams.keySet()) {
            if (!newParams.containsKey(key)) continue;
            StringParameterValue spv = new StringParameterValue(key, messageParams.get(key));
            newParams.put(key, spv);
        }
        return new ArrayList<ParameterValue>(newParams.values());
    }

    private List<ParameterValue> getDefinedParameters(BuildableItem project) {
        ArrayList<ParameterValue> parameters = new ArrayList<ParameterValue>();
        ParametersDefinitionProperty properties = (ParametersDefinitionProperty)((Job)project).getProperty(ParametersDefinitionProperty.class);
        if (properties != null && properties.getParameterDefinitions() != null) {
            for (ParameterDefinition paramDef : properties.getParameterDefinitions()) {
                ParameterValue param = paramDef.getDefaultParameterValue();
                if (param == null) continue;
                parameters.add(param);
            }
        }
        return parameters;
    }

    private void saveJob() {
        try {
            if (this.job != null) {
                ((BuildableItem)this.job).save();
            }
        }
        catch (IOException e) {
            log.warning("Exception while trying to save job: " + e.getMessage());
        }
    }

    private String getJobName() {
        return this.job != null ? ((BuildableItem)this.job).getName() : "<unknown>";
    }

    public CIBuildTriggerDescriptor getDescriptor() {
        return (CIBuildTriggerDescriptor)Jenkins.getInstance().getDescriptor(((Object)((Object)this)).getClass());
    }

    static Object getLock(String name) {
        Object newLock;
        Object lock = locks.get(name);
        if (lock == null && (lock = locks.putIfAbsent(name, newLock = new Object())) == null) {
            lock = newLock;
        }
        return lock;
    }

    @Extension
    public static class CIBuildTriggerDescriptor
    extends TriggerDescriptor {
        public FormValidation doCheckField(@QueryParameter String value) {
            String field = Util.fixEmptyAndTrim((String)value);
            if (field == null) {
                return FormValidation.error((String)"Field cannot be empty");
            }
            return FormValidation.ok();
        }

        public CIBuildTriggerDescriptor() {
            super(CIBuildTrigger.class);
        }

        public boolean isApplicable(Item item) {
            return true;
        }

        public String getDisplayName() {
            return Messages.PluginName();
        }

        public String getHelpFile() {
            return "/plugin/jms-messaging/help-trigger.html";
        }

        public CIBuildTrigger newInstance(StaplerRequest sr, JSONObject jo) {
            try {
                jo.getJSONObject("providerData").put("name", jo.remove(""));
                return (CIBuildTrigger)super.newInstance(sr, jo);
            }
            catch (Descriptor.FormException e) {
                log.log(Level.SEVERE, "Unable to create new instance.", e);
                return null;
            }
        }
    }

    private static class ParametersActionInspection {
        private static final Class<ParametersAction> KLASS = ParametersAction.class;
        private boolean inspectionFailure;
        private boolean safeParametersSet = false;
        private boolean keepUndefinedParameters = false;
        private boolean hasSafeParameterConfig = false;

        ParametersActionInspection() {
            try {
                for (Field field : KLASS.getDeclaredFields()) {
                    if (!Modifier.isStatic(field.getModifiers()) || !field.getName().equals("KEEP_UNDEFINED_PARAMETERS_SYSTEM_PROPERTY_NAME") && !field.getName().equals("SAFE_PARAMETERS_SYSTEM_PROPERTY_NAME")) continue;
                    this.hasSafeParameterConfig = true;
                    break;
                }
                if (this.hasSafeParameterConfig) {
                    if (Boolean.getBoolean(KLASS.getName() + ".keepUndefinedParameters")) {
                        this.keepUndefinedParameters = true;
                    }
                    this.safeParametersSet = false;
                }
                this.inspectionFailure = false;
            }
            catch (Exception e) {
                this.inspectionFailure = true;
            }
        }

        boolean isKeepUndefinedParameters() {
            return this.keepUndefinedParameters;
        }

        boolean isHasSafeParameterConfig() {
            return this.hasSafeParameterConfig;
        }

        public boolean isInspectionFailure() {
            return this.inspectionFailure;
        }
    }
}

