/*
 * Decompiled with CFR 0.152.
 */
package com.tikal.jenkins.plugins.multijob.views;

import com.tikal.jenkins.plugins.multijob.MultiJobProject;
import com.tikal.jenkins.plugins.multijob.views.AbstractWrapper;
import com.tikal.jenkins.plugins.multijob.views.BuildState;
import hudson.model.AbstractProject;
import hudson.model.BallColor;
import hudson.model.HealthReport;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TopLevelItemDescriptor;
import hudson.search.Search;
import hudson.search.SearchIndex;
import hudson.security.ACL;
import hudson.security.Permission;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.acegisecurity.AccessDeniedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectWrapper
extends AbstractWrapper {
    final MultiJobProject multijob;
    final BuildState buildState;
    final Job project;
    final int nestLevel;

    public ProjectWrapper(MultiJobProject multijob, Job project, BuildState buildState, int nestLevel) {
        this.project = project;
        this.multijob = multijob;
        this.nestLevel = nestLevel;
        this.buildState = buildState;
    }

    public Collection<? extends Job> getAllJobs() {
        return this.project.getAllJobs();
    }

    public String getName() {
        return this.project.getName();
    }

    public String getFullName() {
        return this.project.getFullName();
    }

    public String getDisplayName() {
        return this.project.getDisplayName();
    }

    public String getFullDisplayName() {
        return this.project.getFullDisplayName();
    }

    @Override
    public String getUrl() {
        return this.project.getUrl();
    }

    @Override
    public String getShortUrl() {
        return this.project.getShortUrl();
    }

    @Override
    @Deprecated
    public String getAbsoluteUrl() {
        return this.project.getAbsoluteUrl();
    }

    @Override
    public void onLoad(ItemGroup<? extends Item> parent, String name) throws IOException {
        this.project.onLoad(parent, name);
    }

    @Override
    public void onCopiedFrom(Item src) {
        this.project.onCopiedFrom(src);
    }

    @Override
    public void onCreatedFromScratch() {
        this.project.onCreatedFromScratch();
    }

    @Override
    public void save() throws IOException {
        this.project.save();
    }

    @Override
    public void delete() throws IOException, InterruptedException {
        this.project.delete();
    }

    @Override
    public File getRootDir() {
        return this.project.getRootDir();
    }

    @Override
    public Search getSearch() {
        return this.project.getSearch();
    }

    @Override
    public String getSearchName() {
        return this.project.getSearchName();
    }

    @Override
    public String getSearchUrl() {
        return this.project.getSearchUrl();
    }

    @Override
    public SearchIndex getSearchIndex() {
        return this.project.getSearchIndex();
    }

    @Override
    public ACL getACL() {
        return this.project.getACL();
    }

    @Override
    public void checkPermission(Permission permission) throws AccessDeniedException {
        this.project.checkPermission(permission);
    }

    @Override
    public boolean hasPermission(Permission permission) {
        return this.project.hasPermission(permission);
    }

    @Override
    public Hudson getParent() {
        return Hudson.getInstance();
    }

    public int getNestLevel() {
        return this.nestLevel;
    }

    @Override
    public TopLevelItemDescriptor getDescriptor() {
        return (TopLevelItemDescriptor)this.project.getDescriptorByName(this.project.getClass().getName());
    }

    Run findLastBuildForResult(Result result) {
        if (this.buildState == null) {
            return null;
        }
        if (Result.SUCCESS.equals(result)) {
            return this.project.getBuildByNumber(this.buildState.getLastSuccessBuildNumber());
        }
        if (Result.FAILURE.equals(result)) {
            return this.project.getBuildByNumber(this.buildState.getLastFailureBuildNumber());
        }
        return this.project.getBuildByNumber(this.buildState.getLastBuildNumber());
    }

    public Run getLastFailedBuild() {
        return this.findLastBuildForResult(Result.FAILURE);
    }

    public Run getLastSuccessfulBuild() {
        return this.findLastBuildForResult(Result.SUCCESS);
    }

    public Run getLastBuild() {
        return this.findLastBuildForResult(null);
    }

    public Job getProject() {
        return this.project;
    }

    public BallColor getIconColor() {
        Run lastBuild;
        if (this.project instanceof AbstractProject && ((AbstractProject)this.project).isDisabled()) {
            return BallColor.DISABLED;
        }
        for (lastBuild = this.getLastBuild(); lastBuild != null && lastBuild.hasntStartedYet(); lastBuild = lastBuild.getPreviousBuild()) {
        }
        if (lastBuild != null) {
            return lastBuild.getIconColor();
        }
        return BallColor.GREY;
    }

    public String getCss() {
        StringBuilder builder = new StringBuilder();
        if (this.project instanceof MultiJobProject) {
            builder.append("font-weight:bold;");
        }
        builder.append("padding-left:");
        builder.append(String.valueOf((this.getNestLevel() + 1) * 20));
        builder.append("px");
        return builder.toString();
    }

    @Override
    public HealthReport getBuildHealth() {
        return this.getProject().getBuildHealth();
    }

    @Override
    public List<HealthReport> getBuildHealthReports() {
        return this.getProject().getBuildHealthReports();
    }

    @Override
    public boolean isBuildable() {
        return this.multijob == null && this.getProject().isBuildable();
    }

    public String getRelativeNameFrom(ItemGroup g) {
        return null;
    }

    public String getRelativeNameFrom(Item item) {
        return null;
    }
}

