/*
 * Decompiled with CFR 0.152.
 */
package com.tikal.jenkins.plugins.multijob;

import com.tikal.jenkins.plugins.multijob.MultiJobChangeLogSet;
import com.tikal.jenkins.plugins.multijob.MultiJobProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Project;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.StringParameterValue;
import hudson.scm.ChangeLogSet;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExportedBean(defaultVisibility=999)
public class MultiJobBuild
extends Build<MultiJobProject, MultiJobBuild> {
    private List<SubBuild> subBuilds;
    private MultiJobChangeLogSet changeSets = new MultiJobChangeLogSet((AbstractBuild)this);
    private Map<String, SubBuild> subBuildsMap = new HashMap<String, SubBuild>();

    public MultiJobBuild(MultiJobProject project) throws IOException {
        super((Project)project);
    }

    public ChangeLogSet<? extends ChangeLogSet.Entry> getChangeSet() {
        return super.getChangeSet();
    }

    public void addChangeLogSet(ChangeLogSet<? extends ChangeLogSet.Entry> changeLogSet) {
        if (changeLogSet != null) {
            this.changeSets.addChangeLogSet(changeLogSet);
        }
    }

    public MultiJobBuild(MultiJobProject project, File buildDir) throws IOException {
        super((Project)project, buildDir);
    }

    public synchronized void doStop(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        super.doStop(req, rsp);
    }

    public void addAction(Action a) {
        super.addAction(a);
    }

    public void run() {
        this.execute((Run.RunExecution)new MultiJobRunnerImpl());
    }

    public List<SubBuild> getBuilders() {
        MultiJobBuild multiJobBuild = (MultiJobBuild)((MultiJobProject)this.getParent()).getNearestBuild(this.getNumber());
        return multiJobBuild.getSubBuilds();
    }

    public String getBuildParams(SubBuild subBuild) {
        try {
            AbstractProject project = (AbstractProject)Jenkins.getInstance().getItem(subBuild.getJobName());
            Run build = project.getBuildByNumber(subBuild.getBuildNumber());
            ParametersAction action = (ParametersAction)build.getAction(ParametersAction.class);
            List parameters = action.getParameters();
            StringBuffer buffer = new StringBuffer();
            for (ParameterValue parameterValue : parameters) {
                StringParameterValue stringParameter;
                try {
                    stringParameter = (StringParameterValue)parameterValue;
                }
                catch (Exception e) {
                    continue;
                }
                String value = stringParameter.value;
                String name = stringParameter.getName();
                buffer.append("<input type='text' size='15' value='" + name + "' readonly/>").append("&nbsp;").append("<input type='text' size='35' value='" + value + "'/ readonly>").append("</br>");
            }
            return buffer.toString();
        }
        catch (Exception e) {
            return "Failed to retrieve build parameters.";
        }
    }

    public void addSubBuild(SubBuild subBuild) {
        String key = subBuild.getPhaseName().concat(subBuild.getJobName()).concat(String.valueOf(subBuild.getBuildNumber()));
        if (this.subBuildsMap.containsKey(key)) {
            SubBuild e = this.subBuildsMap.get(key);
            Collections.replaceAll(this.getSubBuilds(), e, subBuild);
        } else {
            this.getSubBuilds().add(subBuild);
        }
        this.subBuildsMap.put(key, subBuild);
    }

    @Exported
    public List<SubBuild> getSubBuilds() {
        if (this.subBuilds == null) {
            this.subBuilds = new CopyOnWriteArrayList<SubBuild>();
        }
        return this.subBuilds;
    }

    @ExportedBean(defaultVisibility=999)
    public static class SubBuild {
        private final String parentJobName;
        private final int parentBuildNumber;
        private final String jobName;
        private final int buildNumber;
        private final String phaseName;
        private final Result result;
        private final String icon;
        private final String duration;
        private final String url;

        public SubBuild(String parentJobName, int parentBuildNumber, String jobName, int buildNumber, String phaseName, Result result, String icon, String duration, String url) {
            this.parentJobName = parentJobName;
            this.parentBuildNumber = parentBuildNumber;
            this.jobName = jobName;
            this.buildNumber = buildNumber;
            this.phaseName = phaseName;
            this.result = result;
            this.icon = icon;
            this.duration = duration;
            this.url = url;
        }

        @Exported
        public String getDuration() {
            return this.duration;
        }

        @Exported
        public String getIcon() {
            return this.icon;
        }

        @Exported
        public String getUrl() {
            return this.url;
        }

        @Exported
        public String getPhaseName() {
            return this.phaseName;
        }

        @Exported
        public String getParentJobName() {
            return this.parentJobName;
        }

        @Exported
        public int getParentBuildNumber() {
            return this.parentBuildNumber;
        }

        @Exported
        public String getJobName() {
            return this.jobName;
        }

        @Exported
        public int getBuildNumber() {
            return this.buildNumber;
        }

        @Exported
        public Result getResult() {
            return this.result;
        }

        public String toString() {
            return "SubBuild [parentJobName=" + this.parentJobName + ", parentBuildNumber=" + this.parentBuildNumber + ", jobName=" + this.jobName + ", buildNumber=" + this.buildNumber + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MultiJobRunnerImpl
    extends Build.BuildExecution {
        protected MultiJobRunnerImpl() {
            super((Build)MultiJobBuild.this);
        }

        public Result run(BuildListener listener) throws Exception {
            Result result = super.run(listener);
            if (this.isAborted()) {
                return Result.ABORTED;
            }
            if (this.isFailure()) {
                return Result.FAILURE;
            }
            if (this.isUnstable()) {
                return Result.UNSTABLE;
            }
            return result;
        }

        private boolean isAborted() {
            return this.evaluateResult(Result.FAILURE);
        }

        private boolean isFailure() {
            return this.evaluateResult(Result.UNSTABLE);
        }

        private boolean isUnstable() {
            return this.evaluateResult(Result.SUCCESS);
        }

        private boolean evaluateResult(Result result) {
            List<SubBuild> builders = MultiJobBuild.this.getBuilders();
            for (SubBuild subBuild : builders) {
                Result buildResult = subBuild.getResult();
                if (buildResult == null || !buildResult.isWorseThan(result)) continue;
                return true;
            }
            return false;
        }
    }
}

