/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jacococoveragecolumn;

import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.jacoco.JacocoBuildAction;
import hudson.plugins.jacococoveragecolumn.CoverageRange;
import hudson.views.ListViewColumn;
import java.awt.Color;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.function.Function;

public abstract class AbstractJaCoCoCoverageColumn
extends ListViewColumn {
    protected abstract Float getPercentageFloat(Run<?, ?> var1);

    protected Float getPercentageFloat(Run<?, ?> lastSuccessfulBuild, Function<JacocoBuildAction, Float> percentageFunction) {
        if (lastSuccessfulBuild == null) {
            return Float.valueOf(0.0f);
        }
        JacocoBuildAction action = (JacocoBuildAction)lastSuccessfulBuild.getAction(JacocoBuildAction.class);
        if (action == null) {
            return Float.valueOf(0.0f);
        }
        return percentageFunction.apply(action);
    }

    public boolean hasCoverage(Job<?, ?> job) {
        Run lastSuccessfulBuild = job.getLastSuccessfulBuild();
        return lastSuccessfulBuild != null && lastSuccessfulBuild.getAction(JacocoBuildAction.class) != null;
    }

    public String getPercent(Job<?, ?> job) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.hasCoverage(job)) {
            stringBuilder.append("N/A");
        } else {
            Run lastSuccessfulBuild = job.getLastSuccessfulBuild();
            Double percent = this.getPercent(lastSuccessfulBuild);
            stringBuilder.append(percent);
        }
        return stringBuilder.toString();
    }

    public String getColor(Job<?, ?> job, BigDecimal amount) {
        if (amount == null) {
            return null;
        }
        if (job != null && !this.hasCoverage(job)) {
            return CoverageRange.NA.getLineHexString();
        }
        return CoverageRange.valueOf(amount.doubleValue()).getLineHexString();
    }

    public String getFillColor(Job<?, ?> job, BigDecimal amount) {
        if (amount == null) {
            return null;
        }
        if (job != null && !this.hasCoverage(job)) {
            return CoverageRange.NA.getFillHexString();
        }
        Color c = CoverageRange.fillColorOf(amount.doubleValue());
        return CoverageRange.colorAsHexString(c);
    }

    public BigDecimal getCoverage(Job<?, ?> job) {
        Run lastSuccessfulBuild = job.getLastSuccessfulBuild();
        return BigDecimal.valueOf(this.getPercent(lastSuccessfulBuild));
    }

    private Double getPercent(Run<?, ?> lastSuccessfulBuild) {
        Float percentageFloat = this.getPercentageFloat(lastSuccessfulBuild);
        double doubleValue = percentageFloat.doubleValue();
        int decimalPlaces = 2;
        BigDecimal bigDecimal = new BigDecimal(doubleValue);
        bigDecimal = bigDecimal.setScale(2, RoundingMode.HALF_UP);
        return bigDecimal.doubleValue();
    }
}

