/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jacoco.report;

import hudson.plugins.jacoco.report.AggregatedReport;
import hudson.plugins.jacoco.report.MethodReport;
import hudson.plugins.jacoco.report.PackageReport;
import hudson.plugins.jacoco.report.SourceAnnotator;
import java.io.File;
import java.io.Writer;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ISourceNode;

public final class ClassReport
extends AggregatedReport<PackageReport, ClassReport, MethodReport> {
    private String sourceFilePath;
    private IClassCoverage classCov;

    @Override
    public void setName(String name) {
        super.setName(name.replace('/', '.'));
    }

    @Override
    public void add(MethodReport child) {
        String newChildName = child.getName();
        child.setName(newChildName);
        this.getChildren().put(child.getName(), child);
    }

    public void setSrcFileInfo(IClassCoverage classCov, String sourceFilePath) {
        this.sourceFilePath = sourceFilePath;
        this.classCov = classCov;
    }

    public File getSourceFilePath() {
        return new File(this.sourceFilePath);
    }

    public void printHighlightedSrcFile(Writer output) {
        new SourceAnnotator(this.getSourceFilePath()).printHighlightedSrcFile((ISourceNode)this.classCov, output);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": instruction=" + this.instruction + " branch=" + this.branch + " complexity=" + this.complexity + " line=" + this.line + " method=" + this.method;
    }
}

