/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jacoco.portlet.utils;

import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.List;

public final class Utils {
    private Utils() {
    }

    public static int validateChartAttributes(String attribute, int defaultValue) {
        if (attribute != null) {
            if (attribute.equals("") || attribute.equals("0")) {
                return defaultValue;
            }
            try {
                int validAttributeValue = Integer.parseInt(attribute);
                if (validAttributeValue < 0) {
                    return defaultValue;
                }
                return validAttributeValue;
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static Calendar getLastDate(List<Job<?, ?>> jobs) {
        Calendar lastDate = null;
        for (Job<?, ?> job : jobs) {
            Run lastRun = job.getLastCompletedBuild();
            if (lastRun == null) continue;
            Calendar date = lastRun.getTimestamp();
            if (lastDate == null) {
                lastDate = date;
            }
            if (!date.after(lastDate)) continue;
            lastDate = date;
        }
        return lastDate;
    }

    public static float roundFloat(int scale, RoundingMode roundingMode, float value) {
        BigDecimal bigDecimal = new BigDecimal(value);
        bigDecimal = bigDecimal.setScale(scale, roundingMode);
        return bigDecimal.floatValue();
    }

    public static int nthOccurrence(String str, char c, int n) {
        int pos = str.indexOf(c, 0);
        while (n-- > 0 && pos != -1) {
            pos = str.indexOf(c, pos + 1);
        }
        return pos;
    }

    public static Result applyLogicalAnd(Result op1, Result op2) {
        if (op1.toString().equals("FAILURE") || op2.toString().equals("FAILURE")) {
            return Result.FAILURE;
        }
        if (op1.toString().equals("UNSTABLE") || op2.toString().equals("UNSTABLE")) {
            return Result.UNSTABLE;
        }
        if (op1.toString().equals("SUCCESS") && op2.toString().equals("SUCCESS")) {
            return Result.SUCCESS;
        }
        return Result.FAILURE;
    }
}

