/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jacoco.portlet.chart;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.jacoco.portlet.JacocoLoadData;
import hudson.plugins.jacoco.portlet.Messages;
import hudson.plugins.jacoco.portlet.bean.JacocoCoverageResultSummary;
import hudson.plugins.jacoco.portlet.utils.Utils;
import hudson.plugins.view.dashboard.DashboardPortlet;
import hudson.util.DataSetBuilder;
import hudson.util.Graph;
import hudson.util.ShiftedCategoryAxis;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.List;
import java.util.Map;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.kohsuke.stapler.DataBoundConstructor;

public class JacocoBuilderTrendChart
extends DashboardPortlet {
    private final int width;
    private final int height;
    private final int daysNumber;

    @DataBoundConstructor
    public JacocoBuilderTrendChart(String name, String width, String height, String daysNumber) {
        super(name);
        this.width = Utils.validateChartAttributes(width, 500);
        this.height = Utils.validateChartAttributes(height, 250);
        this.daysNumber = Utils.validateChartAttributes(daysNumber, 30);
    }

    public Graph getSummaryGraph() {
        List jobs = this.getDashboard().getJobs();
        Map<String, JacocoCoverageResultSummary> summaries = JacocoLoadData.loadChartDataWithinRange(jobs, this.daysNumber);
        return JacocoBuilderTrendChart.createTrendChart(summaries, this.width, this.height);
    }

    private static Graph createTrendChart(final Map<String, JacocoCoverageResultSummary> summaries, int widthParam, int heightParam) {
        return new Graph(-1L, widthParam, heightParam){

            protected JFreeChart createGraph() {
                if (summaries == null) {
                    return ChartFactory.createStackedAreaChart(null, (String)"Days", (String)"Coverage(%)", null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
                }
                int lineNumber = 0;
                JFreeChart chart = ChartFactory.createLineChart((String)"", (String)"Days", (String)"Coverage(%)", (CategoryDataset)JacocoBuilderTrendChart.buildDataSet(summaries), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
                chart.setBackgroundPaint((Paint)Color.white);
                CategoryPlot plot = chart.getCategoryPlot();
                CategoryItemRenderer renderer = plot.getRenderer();
                BasicStroke stroke = new BasicStroke(3.5f, 1, 1);
                renderer.setSeriesStroke(lineNumber++, (Stroke)stroke);
                renderer.setSeriesStroke(lineNumber++, (Stroke)stroke);
                renderer.setSeriesStroke(lineNumber++, (Stroke)stroke);
                renderer.setSeriesStroke(lineNumber, (Stroke)stroke);
                plot.setBackgroundPaint((Paint)Color.WHITE);
                plot.setOutlinePaint(null);
                plot.setForegroundAlpha(0.8f);
                plot.setRangeGridlinesVisible(true);
                plot.setRangeGridlinePaint((Paint)Color.black);
                ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
                plot.setDomainAxis((CategoryAxis)domainAxis);
                domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
                domainAxis.setLowerMargin(0.0);
                domainAxis.setUpperMargin(0.0);
                domainAxis.setCategoryMargin(0.0);
                NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
                rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
                rangeAxis.setLowerBound(0.0);
                return chart;
            }
        };
    }

    private static CategoryDataset buildDataSet(Map<String, JacocoCoverageResultSummary> summaries) {
        DataSetBuilder dataSetBuilder = new DataSetBuilder();
        for (Map.Entry<String, JacocoCoverageResultSummary> entry : summaries.entrySet()) {
            float classCoverage = 0.0f;
            float lineCoverage = 0.0f;
            float methodCoverage = 0.0f;
            float branchCoverage = 0.0f;
            float instructionCoverage = 0.0f;
            float complexityScore = 0.0f;
            int count = 0;
            List<JacocoCoverageResultSummary> list = entry.getValue().getJacocoCoverageResults();
            for (JacocoCoverageResultSummary item : list) {
                classCoverage += item.getClassCoverage();
                lineCoverage += item.getLineCoverage();
                methodCoverage += item.getMethodCoverage();
                branchCoverage += item.getBranchCoverage();
                instructionCoverage += item.getInstructionCoverage();
                complexityScore += item.getComplexityScore();
                ++count;
            }
            if (count == 0) continue;
            dataSetBuilder.add((Number)Float.valueOf(classCoverage / (float)count), (Comparable)((Object)"class"), (Comparable)((Object)entry.getKey()));
            dataSetBuilder.add((Number)Float.valueOf(lineCoverage / (float)count), (Comparable)((Object)"line"), (Comparable)((Object)entry.getKey()));
            dataSetBuilder.add((Number)Float.valueOf(methodCoverage / (float)count), (Comparable)((Object)"method"), (Comparable)((Object)entry.getKey()));
            dataSetBuilder.add((Number)Float.valueOf(branchCoverage / (float)count), (Comparable)((Object)"branch"), (Comparable)((Object)entry.getKey()));
            dataSetBuilder.add((Number)Float.valueOf(instructionCoverage / (float)count), (Comparable)((Object)"instruction"), (Comparable)((Object)entry.getKey()));
            dataSetBuilder.add((Number)Float.valueOf(complexityScore / (float)count), (Comparable)((Object)"complexity"), (Comparable)((Object)entry.getKey()));
        }
        return dataSetBuilder.build();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getDaysNumber() {
        return this.daysNumber;
    }

    @Extension(optional=true)
    public static class DescriptorImpl
    extends Descriptor<DashboardPortlet> {
        public String getDisplayName() {
            return Messages.chartTitle();
        }
    }
}

