/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jacoco.portlet.bean;

import hudson.model.Run;
import hudson.plugins.jacoco.portlet.JacocoLoadData;
import hudson.plugins.jacoco.portlet.bean.JacocoCoverageResultSummary;

public class JacocoDeltaCoverageResultSummary {
    private float instructionCoverage;
    private float branchCoverage;
    private float complexityCoverage;
    private float lineCoverage;
    private float methodCoverage;
    private float classCoverage;

    public static JacocoDeltaCoverageResultSummary build(Run<?, ?> run) {
        Run lastSuccessfulBuild = run.getParent().getLastSuccessfulBuild();
        JacocoCoverageResultSummary lastBuildCoverage = lastSuccessfulBuild != null ? JacocoLoadData.getResult(lastSuccessfulBuild) : new JacocoCoverageResultSummary();
        JacocoCoverageResultSummary currentBuildCoverage = JacocoLoadData.getResult(run);
        JacocoDeltaCoverageResultSummary jacocoDeltaCoverageResultSummary = new JacocoDeltaCoverageResultSummary();
        jacocoDeltaCoverageResultSummary.instructionCoverage = currentBuildCoverage.getInstructionCoverage() - lastBuildCoverage.getInstructionCoverage();
        jacocoDeltaCoverageResultSummary.branchCoverage = currentBuildCoverage.getBranchCoverage() - lastBuildCoverage.getBranchCoverage();
        jacocoDeltaCoverageResultSummary.complexityCoverage = currentBuildCoverage.getComplexityScore() - lastBuildCoverage.getComplexityScore();
        jacocoDeltaCoverageResultSummary.lineCoverage = currentBuildCoverage.getLineCoverage() - lastBuildCoverage.getLineCoverage();
        jacocoDeltaCoverageResultSummary.methodCoverage = currentBuildCoverage.getMethodCoverage() - lastBuildCoverage.getMethodCoverage();
        jacocoDeltaCoverageResultSummary.classCoverage = currentBuildCoverage.getClassCoverage() - lastBuildCoverage.getClassCoverage();
        return jacocoDeltaCoverageResultSummary;
    }

    public float getInstructionCoverage() {
        return this.instructionCoverage;
    }

    public float getBranchCoverage() {
        return this.branchCoverage;
    }

    public float getComplexityCoverage() {
        return this.complexityCoverage;
    }

    public float getLineCoverage() {
        return this.lineCoverage;
    }

    public float getMethodCoverage() {
        return this.methodCoverage;
    }

    public float getClassCoverage() {
        return this.classCoverage;
    }

    public void setInstructionCoverage(float instructionCoverage) {
        this.instructionCoverage = instructionCoverage;
    }

    public void setBranchCoverage(float branchCoverage) {
        this.branchCoverage = branchCoverage;
    }

    public void setComplexityCoverage(float complexityCoverage) {
        this.complexityCoverage = complexityCoverage;
    }

    public void setLineCoverage(float lineCoverage) {
        this.lineCoverage = lineCoverage;
    }

    public void setMethodCoverage(float methodCoverage) {
        this.methodCoverage = methodCoverage;
    }

    public void setClassCoverage(float classCoverage) {
        this.classCoverage = classCoverage;
    }

    public String toString() {
        return "JacocoDeltaCoverageResultSummary [instructionCoverage=" + this.instructionCoverage + ", branchCoverage=" + this.branchCoverage + ", complexityCoverage=" + this.complexityCoverage + ", lineCoverage=" + this.lineCoverage + ", methodCoverage=" + this.methodCoverage + ", classCoverage=" + this.classCoverage + ']';
    }
}

