/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jacoco.portlet.bean;

import hudson.model.Job;
import hudson.plugins.jacoco.portlet.utils.Utils;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;

public class JacocoCoverageResultSummary {
    private Job<?, ?> job;
    private float lineCoverage;
    private float methodCoverage;
    private float classCoverage;
    private float instructionCoverage;
    private float branchCoverage;
    private float complexityScore;
    private List<JacocoCoverageResultSummary> coverageResults = new ArrayList<JacocoCoverageResultSummary>();

    public JacocoCoverageResultSummary() {
    }

    public JacocoCoverageResultSummary(Job<?, ?> job, float lineCoverage, float methodCoverage, float classCoverage, float branchCoverage, float instructionCoverage, float complexityScore) {
        this.job = job;
        this.lineCoverage = lineCoverage;
        this.methodCoverage = methodCoverage;
        this.classCoverage = classCoverage;
        this.branchCoverage = branchCoverage;
        this.instructionCoverage = instructionCoverage;
        this.complexityScore = complexityScore;
    }

    public JacocoCoverageResultSummary addCoverageResult(JacocoCoverageResultSummary coverageResult) {
        this.setLineCoverage(this.getLineCoverage() + coverageResult.getLineCoverage());
        this.setMethodCoverage(this.getMethodCoverage() + coverageResult.getMethodCoverage());
        this.setClassCoverage(this.getClassCoverage() + coverageResult.getClassCoverage());
        this.setBranchCoverage(this.getBranchCoverage() + coverageResult.getBranchCoverage());
        this.setInstructionCoverage(this.getInstructionCoverage() + coverageResult.getInstructionCoverage());
        this.setComplexityScore(this.getComplexityScore() + coverageResult.getComplexityScore());
        this.getCoverageResults().add(coverageResult);
        return this;
    }

    public List<JacocoCoverageResultSummary> getJacocoCoverageResults() {
        return this.getCoverageResults();
    }

    public float getTotalClassCoverage() {
        if (this.getCoverageResults().size() <= 0) {
            return 0.0f;
        }
        float totalClass = this.getClassCoverage() / (float)this.getCoverageResults().size();
        totalClass = Utils.roundFloat(1, RoundingMode.HALF_EVEN, totalClass);
        return totalClass;
    }

    public float getTotalBranchCoverage() {
        if (this.getCoverageResults().size() <= 0) {
            return 0.0f;
        }
        float totalBranch = this.getBranchCoverage() / (float)this.getCoverageResults().size();
        totalBranch = Utils.roundFloat(1, RoundingMode.HALF_EVEN, totalBranch);
        return totalBranch;
    }

    public float getTotalInstructionCoverage() {
        if (this.getCoverageResults().size() <= 0) {
            return 0.0f;
        }
        float totalInstr = this.getInstructionCoverage() / (float)this.getCoverageResults().size();
        totalInstr = Utils.roundFloat(1, RoundingMode.HALF_EVEN, totalInstr);
        return totalInstr;
    }

    public float getTotalComplexityScore() {
        if (this.getCoverageResults().size() <= 0) {
            return 0.0f;
        }
        float totalComplex = this.getComplexityScore() / (float)this.getCoverageResults().size();
        totalComplex = Utils.roundFloat(1, RoundingMode.HALF_EVEN, totalComplex);
        return totalComplex;
    }

    public float getTotalLineCoverage() {
        if (this.getCoverageResults().size() <= 0) {
            return 0.0f;
        }
        float totalLine = this.getLineCoverage() / (float)this.getCoverageResults().size();
        totalLine = Utils.roundFloat(1, RoundingMode.HALF_EVEN, totalLine);
        return totalLine;
    }

    public float getTotalMethodCoverage() {
        if (this.getCoverageResults().size() <= 0) {
            return 0.0f;
        }
        float totalMethod = this.getMethodCoverage() / (float)this.getCoverageResults().size();
        totalMethod = Utils.roundFloat(1, RoundingMode.HALF_EVEN, totalMethod);
        return totalMethod;
    }

    public Job<?, ?> getJob() {
        return this.job;
    }

    public float getInstructionCoverage() {
        return this.instructionCoverage;
    }

    public float getBranchCoverage() {
        return this.branchCoverage;
    }

    public float getComplexityScore() {
        return this.complexityScore;
    }

    public float getLineCoverage() {
        return this.lineCoverage;
    }

    public float getMethodCoverage() {
        return this.methodCoverage;
    }

    public float getClassCoverage() {
        return this.classCoverage;
    }

    public void setJob(Job<?, ?> job) {
        this.job = job;
    }

    public void setInstructionCoverage(float instructionCoverage) {
        this.instructionCoverage = instructionCoverage;
    }

    public void setBranchCoverage(float branchCoverage) {
        this.branchCoverage = branchCoverage;
    }

    public void setComplexityScore(float complexityScore) {
        this.complexityScore = complexityScore;
    }

    public void setLineCoverage(float lineCoverage) {
        this.lineCoverage = lineCoverage;
    }

    public void setMethodCoverage(float methodCoverage) {
        this.methodCoverage = methodCoverage;
    }

    public void setClassCoverage(float classCoverage) {
        this.classCoverage = classCoverage;
    }

    public List<JacocoCoverageResultSummary> getCoverageResults() {
        return this.coverageResults;
    }

    public void setCoverageResults(List<JacocoCoverageResultSummary> coverageResults) {
        this.coverageResults = coverageResults;
    }
}

