/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jacoco.portlet;

import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.jacoco.JacocoBuildAction;
import hudson.plugins.jacoco.portlet.bean.JacocoCoverageResultSummary;
import hudson.plugins.jacoco.portlet.utils.Utils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class JacocoLoadData {
    private JacocoLoadData() {
    }

    public static Map<String, JacocoCoverageResultSummary> loadChartDataWithinRange(List<Job<?, ?>> jobs, int daysNumber) {
        HashMap<String, JacocoCoverageResultSummary> summaries = new HashMap<String, JacocoCoverageResultSummary>();
        Calendar firstDate = Utils.getLastDate(jobs);
        if (firstDate == null) {
            return null;
        }
        firstDate.add(5, -daysNumber);
        block0: for (Job<?, ?> job : jobs) {
            Run run = job.getLastCompletedBuild();
            if (null == run) continue;
            Calendar runDate = run.getTimestamp();
            while (runDate.after(firstDate)) {
                JacocoLoadData.summarize(summaries, run, runDate, job);
                for (run = run.getPreviousBuild(); run != null && run.isBuilding(); run = run.getPreviousBuild()) {
                }
                if (null == run) continue block0;
                runDate = run.getTimestamp();
            }
        }
        return new TreeMap<String, JacocoCoverageResultSummary>(summaries);
    }

    private static void summarize(Map<String, JacocoCoverageResultSummary> summaries, Run<?, ?> run, Calendar runDate, Job<?, ?> job) {
        JacocoCoverageResultSummary jacocoCoverageResult = JacocoLoadData.getResult(run);
        String date = new SimpleDateFormat("yyyy-MM-dd").format(runDate.getTime());
        JacocoCoverageResultSummary jacocoCoverageResultSummary = summaries.get(date);
        if (jacocoCoverageResultSummary == null) {
            jacocoCoverageResultSummary = new JacocoCoverageResultSummary();
            jacocoCoverageResultSummary.addCoverageResult(jacocoCoverageResult);
            jacocoCoverageResultSummary.setJob(job);
        } else {
            List<JacocoCoverageResultSummary> listResults = jacocoCoverageResultSummary.getJacocoCoverageResults();
            boolean found = false;
            for (JacocoCoverageResultSummary item : listResults) {
                if (null == item.getJob() || null == item.getJob().getName() || null == job || !item.getJob().getName().equals(job.getName())) continue;
                found = true;
                break;
            }
            if (!found) {
                jacocoCoverageResultSummary.addCoverageResult(jacocoCoverageResult);
                jacocoCoverageResultSummary.setJob(job);
            }
        }
        summaries.put(date, jacocoCoverageResultSummary);
    }

    public static JacocoCoverageResultSummary getResult(Run<?, ?> run) {
        JacocoBuildAction jacocoAction = (JacocoBuildAction)run.getAction(JacocoBuildAction.class);
        float classCoverage = 0.0f;
        float lineCoverage = 0.0f;
        float methodCoverage = 0.0f;
        float branchCoverage = 0.0f;
        float instructionCoverage = 0.0f;
        float complexityScore = 0.0f;
        if (jacocoAction != null) {
            if (null != jacocoAction.getClassCoverage()) {
                classCoverage = jacocoAction.getClassCoverage().getPercentageFloat();
            }
            if (null != jacocoAction.getLineCoverage()) {
                lineCoverage = jacocoAction.getLineCoverage().getPercentageFloat();
            }
            if (null != jacocoAction.getMethodCoverage()) {
                methodCoverage = jacocoAction.getMethodCoverage().getPercentageFloat();
            }
            if (null != jacocoAction.getBranchCoverage()) {
                branchCoverage = jacocoAction.getBranchCoverage().getPercentageFloat();
            }
            if (null != jacocoAction.getInstructionCoverage()) {
                instructionCoverage = jacocoAction.getInstructionCoverage().getPercentageFloat();
            }
            if (null != jacocoAction.getComplexityScore()) {
                complexityScore = jacocoAction.getComplexityScore().getPercentageFloat();
            }
        }
        return new JacocoCoverageResultSummary(run.getParent(), lineCoverage, methodCoverage, classCoverage, branchCoverage, instructionCoverage, complexityScore);
    }

    public static JacocoCoverageResultSummary getResultSummary(Collection<Job<?, ?>> jobs) {
        JacocoCoverageResultSummary summary = new JacocoCoverageResultSummary();
        for (Job<?, ?> job : jobs) {
            JacocoBuildAction jacocoAction;
            float classCoverage = 0.0f;
            float lineCoverage = 0.0f;
            float methodCoverage = 0.0f;
            float branchCoverage = 0.0f;
            float instructionCoverage = 0.0f;
            float complexityScore = 0.0f;
            Run run = job.getLastSuccessfulBuild();
            if (run != null && null != (jacocoAction = (JacocoBuildAction)job.getLastSuccessfulBuild().getAction(JacocoBuildAction.class))) {
                if (null != jacocoAction.getClassCoverage()) {
                    classCoverage = jacocoAction.getClassCoverage().getPercentageFloat();
                    BigDecimal bigClassCoverage = new BigDecimal(classCoverage);
                    bigClassCoverage = bigClassCoverage.setScale(1, RoundingMode.HALF_EVEN);
                    classCoverage = bigClassCoverage.floatValue();
                }
                if (null != jacocoAction.getLineCoverage()) {
                    lineCoverage = jacocoAction.getLineCoverage().getPercentageFloat();
                    BigDecimal bigLineCoverage = new BigDecimal(lineCoverage);
                    bigLineCoverage = bigLineCoverage.setScale(1, RoundingMode.HALF_EVEN);
                    lineCoverage = bigLineCoverage.floatValue();
                }
                if (null != jacocoAction.getMethodCoverage()) {
                    methodCoverage = jacocoAction.getMethodCoverage().getPercentageFloat();
                    BigDecimal bigMethodCoverage = new BigDecimal(methodCoverage);
                    bigMethodCoverage = bigMethodCoverage.setScale(1, RoundingMode.HALF_EVEN);
                    methodCoverage = bigMethodCoverage.floatValue();
                }
                if (null != jacocoAction.getBranchCoverage()) {
                    branchCoverage = jacocoAction.getBranchCoverage().getPercentageFloat();
                    BigDecimal bigBranchCoverage = new BigDecimal(branchCoverage);
                    bigBranchCoverage = bigBranchCoverage.setScale(1, RoundingMode.HALF_EVEN);
                    branchCoverage = bigBranchCoverage.floatValue();
                }
                if (null != jacocoAction.getInstructionCoverage()) {
                    instructionCoverage = jacocoAction.getInstructionCoverage().getPercentageFloat();
                    BigDecimal bigInstructionCoverage = new BigDecimal(instructionCoverage);
                    bigInstructionCoverage = bigInstructionCoverage.setScale(1, RoundingMode.HALF_EVEN);
                    instructionCoverage = bigInstructionCoverage.floatValue();
                }
                if (null != jacocoAction.getComplexityScore()) {
                    complexityScore = jacocoAction.getComplexityScore().getPercentageFloat();
                    BigDecimal bigComplexityCoverage = new BigDecimal(complexityScore);
                    bigComplexityCoverage = bigComplexityCoverage.setScale(1, RoundingMode.HALF_EVEN);
                    complexityScore = bigComplexityCoverage.floatValue();
                }
            }
            summary.addCoverageResult(new JacocoCoverageResultSummary(job, lineCoverage, methodCoverage, classCoverage, branchCoverage, instructionCoverage, complexityScore));
        }
        return summary;
    }
}

