/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jacoco.model;

import hudson.plugins.jacoco.Messages;
import hudson.plugins.jacoco.model.Coverage;
import hudson.plugins.jacoco.model.CoverageObject;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;

public class CoverageGraphLayout {
    private float baseStroke = 4.0f;
    private Stack<Axis> axes = new Stack();
    private Stack<Plot> plots = new Stack();

    public CoverageGraphLayout baseStroke(float baseStroke) {
        this.baseStroke = baseStroke;
        return this;
    }

    public CoverageGraphLayout axis() {
        this.axes.push(new Axis());
        return this;
    }

    private void assureAxis() {
        if (this.axes.isEmpty()) {
            this.axis();
        }
    }

    public CoverageGraphLayout crop() {
        return this.crop(5);
    }

    public CoverageGraphLayout crop(int marginInPercent) {
        this.assureAxis();
        this.axes.peek().crop = marginInPercent;
        return this;
    }

    public CoverageGraphLayout label(String label) {
        this.assureAxis();
        this.axes.peek().label = label;
        return this;
    }

    public CoverageGraphLayout skipZero() {
        this.assureAxis();
        this.axes.peek().skipZero = true;
        return this;
    }

    public CoverageGraphLayout plot() {
        this.assureAxis();
        this.plots.add(new Plot(this.axes.peek()));
        return this;
    }

    private void assurePlot() {
        if (this.plots.isEmpty()) {
            this.plot();
        }
    }

    public CoverageGraphLayout type(CoverageType type) {
        this.assurePlot();
        this.plots.peek().type = type;
        return this;
    }

    public CoverageGraphLayout value(CoverageValue value) {
        this.assurePlot();
        this.plots.peek().value = value;
        return this;
    }

    public CoverageGraphLayout color(Color color) {
        this.assurePlot();
        this.plots.peek().color = color;
        return this;
    }

    public List<Axis> getAxes() {
        return Collections.unmodifiableList(this.axes);
    }

    public List<Plot> getPlots() {
        return Collections.unmodifiableList(this.plots);
    }

    public void apply(JFreeChart chart, boolean onlyOneBuild) {
        CategoryPlot plot = chart.getCategoryPlot();
        HashMap<Axis, Integer> axisIds = new HashMap<Axis, Integer>();
        int axisId = 0;
        for (Axis axis : this.axes) {
            LineAndShapeRenderer renderer = new LineAndShapeRenderer(true, onlyOneBuild);
            if (onlyOneBuild) {
                renderer.setUseOutlinePaint(true);
            }
            renderer.setBaseStroke((Stroke)new BasicStroke(this.baseStroke));
            plot.setRenderer(axisId, (CategoryItemRenderer)renderer);
            axisIds.put(axis, axisId);
            ++axisId;
        }
        for (Plot p : this.plots) {
            axisId = (Integer)axisIds.get(p.axis);
            int lineIdPerAxis = plot.getDataset(axisId).getRowIndex((Comparable)((Object)p.getMessage()));
            LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer(axisId);
            renderer.setSeriesPaint(lineIdPerAxis, (Paint)p.color);
            renderer.setSeriesItemLabelPaint(lineIdPerAxis, (Paint)p.color);
            renderer.setSeriesFillPaint(lineIdPerAxis, (Paint)p.color);
        }
        chart.getLegend().setPosition(RectangleEdge.RIGHT);
        chart.setBackgroundPaint((Paint)Color.white);
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        plot.setInsets(new RectangleInsets(5.0, 0.0, 0.0, 5.0));
    }

    static class Plot {
        private CoverageValue value;
        private CoverageType type;
        private Axis axis;
        private Color color;

        public Plot(Axis axis) {
            this.axis = axis;
        }

        public Number getValue(CoverageObject<?> a) {
            return this.type.getValue(a, this.value);
        }

        public String getMessage() {
            return this.value.getMessage(this.type);
        }

        public Axis getAxis() {
            return this.axis;
        }

        public String toString() {
            return this.axis + " " + (Object)((Object)this.type) + " " + (Object)((Object)this.value) + " " + this.color;
        }
    }

    static class Axis {
        private String label = null;
        private int crop = -1;
        private boolean skipZero = false;

        Axis() {
        }

        public boolean isCrop() {
            return this.crop != -1;
        }

        public boolean isSkipZero() {
            return this.skipZero;
        }

        public String getLabel() {
            return this.label;
        }

        public int getCrop() {
            return this.crop;
        }
    }

    static enum CoverageValue {
        MISSED{

            @Override
            public String getMessage(CoverageType type) {
                return Messages.CoverageObject_Legend_Missed(type.getMessage());
            }

            @Override
            public Number getValue(Coverage c) {
                return c.getMissed();
            }
        }
        ,
        COVERED{

            @Override
            public String getMessage(CoverageType type) {
                return Messages.CoverageObject_Legend_Covered(type.getMessage());
            }

            @Override
            public Number getValue(Coverage c) {
                return c.getCovered();
            }
        }
        ,
        PERCENTAGE{

            @Override
            public String getMessage(CoverageType type) {
                return type.getMessage();
            }

            @Override
            public Number getValue(Coverage c) {
                return Float.valueOf(c.getPercentageFloat());
            }
        };


        public abstract String getMessage(CoverageType var1);

        public abstract Number getValue(Coverage var1);
    }

    static enum CoverageType {
        INSTRUCTION{

            @Override
            public String getMessage() {
                return Messages.CoverageObject_Legend_Instructions();
            }

            @Override
            public Coverage getCoverage(CoverageObject<?> a) {
                return a.instruction;
            }
        }
        ,
        BRANCH{

            @Override
            public String getMessage() {
                return Messages.CoverageObject_Legend_Branch();
            }

            @Override
            public Coverage getCoverage(CoverageObject<?> a) {
                return a.branch;
            }
        }
        ,
        COMPLEXITY{

            @Override
            public String getMessage() {
                return Messages.CoverageObject_Legend_Complexity();
            }

            @Override
            public Coverage getCoverage(CoverageObject<?> a) {
                return a.complexity;
            }
        }
        ,
        METHOD{

            @Override
            public String getMessage() {
                return Messages.CoverageObject_Legend_Method();
            }

            @Override
            public Coverage getCoverage(CoverageObject<?> a) {
                return a.method;
            }
        }
        ,
        CLAZZ{

            @Override
            public String getMessage() {
                return Messages.CoverageObject_Legend_Class();
            }

            @Override
            public Coverage getCoverage(CoverageObject<?> a) {
                return a.clazz;
            }
        }
        ,
        LINE{

            @Override
            public String getMessage() {
                return Messages.CoverageObject_Legend_Line();
            }

            @Override
            public Coverage getCoverage(CoverageObject<?> a) {
                return a.line;
            }
        };


        public abstract String getMessage();

        public abstract Coverage getCoverage(CoverageObject<?> var1);

        public Number getValue(CoverageObject<?> a, CoverageValue value) {
            Coverage c = this.getCoverage(a);
            if (c == null) {
                return 0;
            }
            return value.getValue(c);
        }
    }
}

