/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jacoco.model;

import hudson.plugins.jacoco.model.Coverage;
import hudson.plugins.jacoco.report.AbstractReport;
import java.io.IOException;

public final class CoverageElement {
    private Type type;
    private int missed;
    private int covered;

    public Type getTypeAsEnum() {
        return this.type;
    }

    public void setType(String type) {
        this.type = Type.valueOf(type);
    }

    public void setMissed(int missed) {
        this.missed = missed;
    }

    public void setCovered(int covered) {
        this.covered = covered;
    }

    public void addTo(AbstractReport<?, ?> report) throws IOException {
        this.type.getAssociatedRatio(report).accumulate(this.missed, this.covered);
    }

    public static enum Type {
        INSTRUCTION{

            @Override
            public Coverage getAssociatedRatio(AbstractReport<?, ?> from) {
                return from.instruction;
            }
        }
        ,
        BRANCH{

            @Override
            public Coverage getAssociatedRatio(AbstractReport<?, ?> from) {
                return from.branch;
            }
        }
        ,
        LINE{

            @Override
            public Coverage getAssociatedRatio(AbstractReport<?, ?> from) {
                return from.line;
            }
        }
        ,
        COMPLEXITY{

            @Override
            public Coverage getAssociatedRatio(AbstractReport<?, ?> from) {
                return from.complexity;
            }
        }
        ,
        METHOD{

            @Override
            public Coverage getAssociatedRatio(AbstractReport<?, ?> from) {
                return from.method;
            }
        }
        ,
        CLASS{

            @Override
            public Coverage getAssociatedRatio(AbstractReport<?, ?> from) {
                return from.clazz;
            }
        };


        public abstract Coverage getAssociatedRatio(AbstractReport<?, ?> var1);
    }
}

