/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jacoco.model;

import hudson.plugins.jacoco.model.CoverageElement;
import java.io.Serializable;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public final class Coverage
implements Serializable {
    private int missed = 0;
    private int covered = 0;
    private CoverageElement.Type type;
    boolean initialized = false;
    private static final long serialVersionUID = 1L;

    public Coverage(int missed, int covered) {
        this.missed = missed;
        this.covered = covered;
        this.initialized = true;
    }

    public Coverage() {
    }

    @Exported
    public int getMissed() {
        return this.missed;
    }

    @Exported
    public int getCovered() {
        return this.covered;
    }

    @Exported
    public int getTotal() {
        return this.missed + this.covered;
    }

    public String toString() {
        return this.missed + "/" + this.covered;
    }

    @Exported
    public int getPercentage() {
        return Math.round(this.getPercentageFloat());
    }

    @Exported
    public float getPercentageFloat() {
        float numerator = this.covered;
        float denominator = this.missed + this.covered;
        return denominator <= 0.0f ? 100.0f : 100.0f * (numerator / denominator);
    }

    public CoverageElement.Type getType() {
        return this.type;
    }

    public void setType(CoverageElement.Type type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Coverage ratio = (Coverage)o;
        return ratio.covered == this.covered && ratio.missed == this.missed;
    }

    public int hashCode() {
        int result = this.missed;
        result = 31 * result + this.covered;
        return result;
    }

    public void accumulate(int missed, int covered) {
        this.missed = missed;
        this.covered = covered;
        this.initialized = true;
    }

    public void accumulatePP(int missed, int covered) {
        this.missed += missed;
        this.covered += covered;
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

