/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jacoco;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.jacoco.JacocoBuildAction;
import hudson.plugins.jacoco.JacocoHealthReportDeltaThresholds;
import hudson.plugins.jacoco.JacocoHealthReportThresholds;
import hudson.plugins.jacoco.JacocoReportDir;
import hudson.plugins.jacoco.Messages;
import hudson.plugins.jacoco.Rule;
import hudson.plugins.jacoco.portlet.bean.JacocoDeltaCoverageResultSummary;
import hudson.plugins.jacoco.portlet.utils.Utils;
import hudson.plugins.jacoco.report.CoverageReport;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import jenkins.MasterToSlaveFileCallable;
import jenkins.tasks.SimpleBuildStep;
import org.apache.tools.ant.DirectoryScanner;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class JacocoPublisher
extends Recorder
implements SimpleBuildStep {
    public Rule rule;
    @Deprecated
    public transient String includes;
    @Deprecated
    public transient int moduleNum;
    public JacocoHealthReportThresholds healthReports;
    public JacocoHealthReportDeltaThresholds deltaHealthReport;
    private String execPattern;
    private String classPattern;
    private String sourcePattern;
    private String sourceInclusionPattern;
    private String sourceExclusionPattern;
    private String inclusionPattern;
    private String exclusionPattern;
    private boolean skipCopyOfSrcFiles;
    private String minimumInstructionCoverage;
    private String minimumBranchCoverage;
    private String minimumComplexityCoverage;
    private String minimumLineCoverage;
    private String minimumMethodCoverage;
    private String minimumClassCoverage;
    private String maximumInstructionCoverage;
    private String maximumBranchCoverage;
    private String maximumComplexityCoverage;
    private String maximumLineCoverage;
    private String maximumMethodCoverage;
    private String maximumClassCoverage;
    private boolean changeBuildStatus;
    private boolean runAlways;
    private String deltaInstructionCoverage;
    private String deltaBranchCoverage;
    private String deltaComplexityCoverage;
    private String deltaLineCoverage;
    private String deltaMethodCoverage;
    private String deltaClassCoverage;
    private boolean buildOverBuild;
    private static final String DIR_SEP = "\\s*,\\s*";
    private static final Integer THRESHOLD_DEFAULT = 0;
    public static BuildStepDescriptor<Publisher> DESCRIPTOR;

    @DataBoundConstructor
    public JacocoPublisher() {
        this.execPattern = "**/**.exec";
        this.classPattern = "**/classes";
        this.sourcePattern = "**/src/main/java";
        this.sourceInclusionPattern = "**/*.java,**/*.groovy,**/*.kt,**/*.kts";
        this.sourceExclusionPattern = "";
        this.inclusionPattern = "";
        this.exclusionPattern = "";
        this.skipCopyOfSrcFiles = false;
        this.minimumInstructionCoverage = "0";
        this.minimumBranchCoverage = "0";
        this.minimumComplexityCoverage = "0";
        this.minimumLineCoverage = "0";
        this.minimumMethodCoverage = "0";
        this.minimumClassCoverage = "0";
        this.maximumInstructionCoverage = "0";
        this.maximumBranchCoverage = "0";
        this.maximumComplexityCoverage = "0";
        this.maximumLineCoverage = "0";
        this.maximumMethodCoverage = "0";
        this.maximumClassCoverage = "0";
        this.changeBuildStatus = false;
        this.runAlways = false;
        this.deltaInstructionCoverage = "0";
        this.deltaBranchCoverage = "0";
        this.deltaComplexityCoverage = "0";
        this.deltaLineCoverage = "0";
        this.deltaMethodCoverage = "0";
        this.deltaClassCoverage = "0";
        this.buildOverBuild = false;
    }

    @Deprecated
    public JacocoPublisher(String execPattern, String classPattern, String sourcePattern, String inclusionPattern, String exclusionPattern, boolean skipCopyOfSrcFiles, String maximumInstructionCoverage, String maximumBranchCoverage, String maximumComplexityCoverage, String maximumLineCoverage, String maximumMethodCoverage, String maximumClassCoverage, String minimumInstructionCoverage, String minimumBranchCoverage, String minimumComplexityCoverage, String minimumLineCoverage, String minimumMethodCoverage, String minimumClassCoverage, boolean changeBuildStatus, boolean runAlways, String deltaInstructionCoverage, String deltaBranchCoverage, String deltaComplexityCoverage, String deltaLineCoverage, String deltaMethodCoverage, String deltaClassCoverage, boolean buildOverBuild) {
        this.execPattern = execPattern;
        this.classPattern = classPattern;
        this.sourcePattern = sourcePattern;
        this.inclusionPattern = inclusionPattern;
        this.exclusionPattern = exclusionPattern;
        this.skipCopyOfSrcFiles = skipCopyOfSrcFiles;
        this.minimumInstructionCoverage = minimumInstructionCoverage;
        this.minimumBranchCoverage = minimumBranchCoverage;
        this.minimumComplexityCoverage = minimumComplexityCoverage;
        this.minimumLineCoverage = minimumLineCoverage;
        this.minimumMethodCoverage = minimumMethodCoverage;
        this.minimumClassCoverage = minimumClassCoverage;
        this.maximumInstructionCoverage = maximumInstructionCoverage;
        this.maximumBranchCoverage = maximumBranchCoverage;
        this.maximumComplexityCoverage = maximumComplexityCoverage;
        this.maximumLineCoverage = maximumLineCoverage;
        this.maximumMethodCoverage = maximumMethodCoverage;
        this.maximumClassCoverage = maximumClassCoverage;
        this.changeBuildStatus = changeBuildStatus;
        this.runAlways = runAlways;
        this.deltaInstructionCoverage = deltaInstructionCoverage;
        this.deltaBranchCoverage = deltaBranchCoverage;
        this.deltaComplexityCoverage = deltaComplexityCoverage;
        this.deltaLineCoverage = deltaLineCoverage;
        this.deltaMethodCoverage = deltaMethodCoverage;
        this.deltaClassCoverage = deltaClassCoverage;
        this.buildOverBuild = buildOverBuild;
    }

    private Integer convertThresholdInputToInteger(String input, EnvVars env) {
        if (input == null || "".equals(input)) {
            return THRESHOLD_DEFAULT;
        }
        try {
            String expandedInput = env.expand(input);
            return Integer.parseInt(expandedInput);
        }
        catch (NumberFormatException e) {
            return THRESHOLD_DEFAULT;
        }
    }

    public String toString() {
        return "JacocoPublisher [execPattern=" + this.execPattern + ", classPattern=" + this.classPattern + ", sourcePattern=" + this.sourcePattern + ", sourceExclusionPattern=" + this.sourceExclusionPattern + ", sourceInclusionPattern=" + this.sourceInclusionPattern + ", inclusionPattern=" + this.inclusionPattern + ", exclusionPattern=" + this.exclusionPattern + ", minimumInstructionCoverage=" + this.minimumInstructionCoverage + ", minimumBranchCoverage=" + this.minimumBranchCoverage + ", minimumComplexityCoverage=" + this.minimumComplexityCoverage + ", minimumLineCoverage=" + this.minimumLineCoverage + ", minimumMethodCoverage=" + this.minimumMethodCoverage + ", minimumClassCoverage=" + this.minimumClassCoverage + ", maximumInstructionCoverage=" + this.maximumInstructionCoverage + ", maximumBranchCoverage=" + this.maximumBranchCoverage + ", maximumComplexityCoverage=" + this.maximumComplexityCoverage + ", maximumLineCoverage=" + this.maximumLineCoverage + ", maximumMethodCoverage=" + this.maximumMethodCoverage + ", maximumClassCoverage=" + this.maximumClassCoverage + ", runAlways=" + this.runAlways + ", deltaInstructionCoverage=" + this.deltaInstructionCoverage + ", deltaBranchCoverage=" + this.deltaBranchCoverage + ", deltaComplexityCoverage=" + this.deltaComplexityCoverage + ", deltaLineCoverage=" + this.deltaLineCoverage + ", deltaMethodCoverage=" + this.deltaMethodCoverage + ", deltaClassCoverage=" + this.deltaClassCoverage + "]";
    }

    public String getExecPattern() {
        return this.execPattern;
    }

    public String getClassPattern() {
        return this.classPattern;
    }

    public String getSourcePattern() {
        return this.sourcePattern;
    }

    public String getSourceExclusionPattern() {
        return this.sourceExclusionPattern;
    }

    public String getSourceInclusionPattern() {
        return this.sourceInclusionPattern;
    }

    public String getInclusionPattern() {
        return this.inclusionPattern;
    }

    public String getExclusionPattern() {
        return this.exclusionPattern;
    }

    public boolean isSkipCopyOfSrcFiles() {
        return this.skipCopyOfSrcFiles;
    }

    public String getMinimumInstructionCoverage() {
        return this.minimumInstructionCoverage;
    }

    public String getMinimumBranchCoverage() {
        return this.minimumBranchCoverage;
    }

    public String getMinimumComplexityCoverage() {
        return this.minimumComplexityCoverage;
    }

    public String getMinimumLineCoverage() {
        return this.minimumLineCoverage;
    }

    public String getMinimumMethodCoverage() {
        return this.minimumMethodCoverage;
    }

    public String getMinimumClassCoverage() {
        return this.minimumClassCoverage;
    }

    public String getMaximumInstructionCoverage() {
        return this.maximumInstructionCoverage;
    }

    public String getMaximumBranchCoverage() {
        return this.maximumBranchCoverage;
    }

    public String getMaximumComplexityCoverage() {
        return this.maximumComplexityCoverage;
    }

    public String getMaximumLineCoverage() {
        return this.maximumLineCoverage;
    }

    public String getMaximumMethodCoverage() {
        return this.maximumMethodCoverage;
    }

    public String getMaximumClassCoverage() {
        return this.maximumClassCoverage;
    }

    public boolean isChangeBuildStatus() {
        return this.changeBuildStatus;
    }

    public boolean getChangeBuildStatus() {
        return this.changeBuildStatus;
    }

    public boolean isRunAlways() {
        return this.runAlways;
    }

    public String getDeltaInstructionCoverage() {
        return this.deltaInstructionCoverage;
    }

    public String getDeltaBranchCoverage() {
        return this.deltaBranchCoverage;
    }

    public String getDeltaComplexityCoverage() {
        return this.deltaComplexityCoverage;
    }

    public String getDeltaLineCoverage() {
        return this.deltaLineCoverage;
    }

    public String getDeltaMethodCoverage() {
        return this.deltaMethodCoverage;
    }

    public String getDeltaClassCoverage() {
        return this.deltaClassCoverage;
    }

    public boolean isBuildOverBuild() {
        return this.buildOverBuild;
    }

    @DataBoundSetter
    public void setExecPattern(String execPattern) {
        this.execPattern = execPattern;
    }

    @DataBoundSetter
    public void setClassPattern(String classPattern) {
        this.classPattern = classPattern;
    }

    @DataBoundSetter
    public void setSourcePattern(String sourcePattern) {
        this.sourcePattern = sourcePattern;
    }

    @DataBoundSetter
    public void setSourceInclusionPattern(String sourceInclusionPattern) {
        this.sourceInclusionPattern = sourceInclusionPattern;
    }

    @DataBoundSetter
    public void setSourceExclusionPattern(String sourceExclusionPattern) {
        this.sourceExclusionPattern = sourceExclusionPattern;
    }

    @DataBoundSetter
    public void setSkipCopyOfSrcFiles(boolean skipCopyOfSrcFiles) {
        this.skipCopyOfSrcFiles = skipCopyOfSrcFiles;
    }

    @DataBoundSetter
    public void setMinimumInstructionCoverage(String minimumInstructionCoverage) {
        this.minimumInstructionCoverage = minimumInstructionCoverage;
    }

    @DataBoundSetter
    public void setMinimumBranchCoverage(String minimumBranchCoverage) {
        this.minimumBranchCoverage = minimumBranchCoverage;
    }

    @DataBoundSetter
    public void setMinimumComplexityCoverage(String minimumComplexityCoverage) {
        this.minimumComplexityCoverage = minimumComplexityCoverage;
    }

    @DataBoundSetter
    public void setMinimumLineCoverage(String minimumLineCoverage) {
        this.minimumLineCoverage = minimumLineCoverage;
    }

    @DataBoundSetter
    public void setMinimumMethodCoverage(String minimumMethodCoverage) {
        this.minimumMethodCoverage = minimumMethodCoverage;
    }

    @DataBoundSetter
    public void setMinimumClassCoverage(String minimumClassCoverage) {
        this.minimumClassCoverage = minimumClassCoverage;
    }

    @DataBoundSetter
    public void setMaximumInstructionCoverage(String maximumInstructionCoverage) {
        this.maximumInstructionCoverage = maximumInstructionCoverage;
    }

    @DataBoundSetter
    public void setMaximumBranchCoverage(String maximumBranchCoverage) {
        this.maximumBranchCoverage = maximumBranchCoverage;
    }

    @DataBoundSetter
    public void setMaximumComplexityCoverage(String maximumComplexityCoverage) {
        this.maximumComplexityCoverage = maximumComplexityCoverage;
    }

    @DataBoundSetter
    public void setMaximumLineCoverage(String maximumLineCoverage) {
        this.maximumLineCoverage = maximumLineCoverage;
    }

    @DataBoundSetter
    public void setMaximumMethodCoverage(String maximumMethodCoverage) {
        this.maximumMethodCoverage = maximumMethodCoverage;
    }

    @DataBoundSetter
    public void setMaximumClassCoverage(String maximumClassCoverage) {
        this.maximumClassCoverage = maximumClassCoverage;
    }

    @DataBoundSetter
    public void setChangeBuildStatus(boolean changeBuildStatus) {
        this.changeBuildStatus = changeBuildStatus;
    }

    @DataBoundSetter
    public void setRunAlways(boolean runAlways) {
        this.runAlways = runAlways;
    }

    @DataBoundSetter
    public void setInclusionPattern(String inclusionPattern) {
        this.inclusionPattern = inclusionPattern;
    }

    @DataBoundSetter
    public void setExclusionPattern(String exclusionPattern) {
        this.exclusionPattern = exclusionPattern;
    }

    @DataBoundSetter
    public void setDeltaInstructionCoverage(String deltaInstructionCoverage) {
        this.deltaInstructionCoverage = deltaInstructionCoverage;
    }

    @DataBoundSetter
    public void setDeltaBranchCoverage(String deltaBranchCoverage) {
        this.deltaBranchCoverage = deltaBranchCoverage;
    }

    @DataBoundSetter
    public void setDeltaComplexityCoverage(String deltaComplexityCoverage) {
        this.deltaComplexityCoverage = deltaComplexityCoverage;
    }

    @DataBoundSetter
    public void setDeltaLineCoverage(String deltaLineCoverage) {
        this.deltaLineCoverage = deltaLineCoverage;
    }

    @DataBoundSetter
    public void setDeltaMethodCoverage(String deltaMethodCoverage) {
        this.deltaMethodCoverage = deltaMethodCoverage;
    }

    @DataBoundSetter
    public void setDeltaClassCoverage(String deltaClassCoverage) {
        this.deltaClassCoverage = deltaClassCoverage;
    }

    @DataBoundSetter
    public void setBuildOverBuild(boolean buildOverBuild) {
        this.buildOverBuild = buildOverBuild;
    }

    protected static void saveCoverageReports(FilePath destFolder, FilePath sourceFolder) throws IOException, InterruptedException {
        destFolder.mkdirs();
        sourceFolder.copyRecursiveTo(destFolder);
    }

    protected String resolveFilePaths(Run<?, ?> build, TaskListener listener, String input, Map<String, String> env) throws InterruptedException, IOException {
        try {
            EnvVars environment = build.getEnvironment(listener);
            environment.overrideAll(env);
            return environment.expand(input);
        }
        catch (IOException e) {
            throw new IOException("Failed to resolve parameters in string \"" + input + "\"", e);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Failed to resolve parameters in string \"" + input + "\"", e);
        }
    }

    protected String resolveFilePaths(AbstractBuild<?, ?> build, TaskListener listener, String input) throws InterruptedException, IOException {
        try {
            EnvVars environment = build.getEnvironment(listener);
            environment.overrideAll(build.getBuildVariables());
            return environment.expand(input);
        }
        catch (IOException e) {
            throw new IOException("Failed to resolve parameters in string \"" + input + "\"", e);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Failed to resolve parameters in string \"" + input + "\"", e);
        }
    }

    protected static FilePath[] resolveDirPaths(FilePath workspace, TaskListener listener, String input) throws InterruptedException, IOException {
        return (FilePath[])workspace.act((FilePath.FileCallable)new ResolveDirPaths(input));
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener taskListener) throws InterruptedException, IOException {
        Map envs = run instanceof AbstractBuild ? ((AbstractBuild)run).getBuildVariables() : Collections.emptyMap();
        EnvVars env = run.getEnvironment(taskListener);
        env.overrideAll(envs);
        this.healthReports = this.createJacocoHealthReportThresholds(env);
        this.deltaHealthReport = this.createJacocoDeltaHealthReportThresholds();
        if (!(run.getResult() != Result.FAILURE && run.getResult() != Result.ABORTED || this.runAlways)) {
            return;
        }
        PrintStream logger = taskListener.getLogger();
        logger.println("[JaCoCo plugin] Collecting JaCoCo coverage data...");
        if (this.execPattern == null || this.classPattern == null || this.sourcePattern == null) {
            if (run.getResult().isWorseThan(Result.UNSTABLE) && !this.runAlways) {
                return;
            }
            logger.println("[JaCoCo plugin] ERROR: Missing configuration!");
            run.setResult(Result.FAILURE);
            return;
        }
        logger.println("[JaCoCo plugin] " + this.execPattern + ";" + this.classPattern + ";" + this.sourcePattern + "; locations are configured");
        JacocoReportDir reportDir = new JacocoReportDir(run.getRootDir());
        if (run instanceof AbstractBuild) {
            this.execPattern = this.resolveFilePaths((AbstractBuild)run, taskListener, this.execPattern);
        }
        List<FilePath> matchedExecFiles = Arrays.asList(filePath.list(this.resolveFilePaths(run, taskListener, this.execPattern, (Map<String, String>)env)));
        logger.println("[JaCoCo plugin] Number of found exec files for pattern " + this.execPattern + ": " + matchedExecFiles.size());
        logger.print("[JaCoCo plugin] Saving matched execfiles: ");
        reportDir.addExecFiles(matchedExecFiles);
        logger.print(" " + matchedExecFiles.stream().map(Object::toString).collect(Collectors.joining(" ")));
        FilePath[] matchedClassDirs = JacocoPublisher.resolveDirPaths(filePath, taskListener, this.classPattern);
        logger.print("\n[JaCoCo plugin] Saving matched class directories for class-pattern: " + this.classPattern + ": ");
        String warning = "\n[JaCoCo plugin] WARNING: You are using directory patterns with trailing /, /* or /** . This will most likely multiply the copied files in your build directory. Check the list below and ignore this warning if you know what you are doing.";
        if (this.hasSubDirectories(this.classPattern)) {
            logger.print("\n[JaCoCo plugin] WARNING: You are using directory patterns with trailing /, /* or /** . This will most likely multiply the copied files in your build directory. Check the list below and ignore this warning if you know what you are doing.");
        }
        for (FilePath dir : matchedClassDirs) {
            int copied = reportDir.saveClassesFrom(dir, "**/*.class");
            logger.print("\n[JaCoCo plugin]  - " + dir + " " + copied + " files");
        }
        if (!this.skipCopyOfSrcFiles) {
            FilePath[] matchedSrcDirs = JacocoPublisher.resolveDirPaths(filePath, taskListener, this.sourcePattern);
            logger.print("\n[JaCoCo plugin] Saving matched source directories for source-pattern: " + this.sourcePattern + ": ");
            logger.print("\n[JaCoCo plugin] Source Inclusions: " + this.sourceInclusionPattern);
            logger.print("\n[JaCoCo plugin] Source Exclusions: " + this.sourceExclusionPattern);
            if (this.hasSubDirectories(this.sourcePattern)) {
                logger.print("\n[JaCoCo plugin] WARNING: You are using directory patterns with trailing /, /* or /** . This will most likely multiply the copied files in your build directory. Check the list below and ignore this warning if you know what you are doing.");
            }
            for (FilePath dir : matchedSrcDirs) {
                int copied = reportDir.saveSourcesFrom(dir, this.sourceInclusionPattern, this.sourceExclusionPattern);
                logger.print("\n[JaCoCo plugin] - " + dir + " " + copied + " files");
            }
        } else {
            logger.print("\n[JaCoCo plugin] Skipping save of matched source directories for source-pattern: " + this.sourcePattern);
        }
        logger.println("\n[JaCoCo plugin] Loading inclusions files..");
        Object[] includes = new String[]{};
        if (this.inclusionPattern != null) {
            String expandedInclusion = env.expand(this.inclusionPattern);
            includes = expandedInclusion.split(DIR_SEP);
            logger.println("[JaCoCo plugin] inclusions: " + Arrays.toString(includes));
        }
        Object[] excludes = new String[]{};
        if (this.exclusionPattern != null) {
            String expandedExclusion = env.expand(this.exclusionPattern);
            excludes = expandedExclusion.split(DIR_SEP);
            logger.println("[JaCoCo plugin] exclusions: " + Arrays.toString(excludes));
        }
        JacocoBuildAction action = JacocoBuildAction.load(this.healthReports, taskListener, reportDir, (String[])includes, (String[])excludes);
        action.getThresholds().ensureValid();
        logger.println("[JaCoCo plugin] Thresholds: " + action.getThresholds());
        run.addAction((Action)action);
        logger.println("[JaCoCo plugin] Publishing the results..");
        CoverageReport result = action.getResult();
        if (result == null) {
            logger.println("[JaCoCo plugin] Could not parse coverage results. Setting Build to failure.");
            run.setResult(Result.FAILURE);
        } else {
            logger.println("[JaCoCo plugin] Overall coverage: class: " + result.getClassCoverage().getPercentageFloat() + ", method: " + result.getMethodCoverage().getPercentageFloat() + ", line: " + result.getLineCoverage().getPercentageFloat() + ", branch: " + result.getBranchCoverage().getPercentageFloat() + ", instruction: " + result.getInstructionCoverage().getPercentageFloat() + ", complexity: " + result.getComplexityScore().getPercentageFloat());
            result.setThresholds(this.healthReports);
            Result applyMinMaxTh = Result.SUCCESS;
            Result applyDeltaTh = Result.SUCCESS;
            if (this.changeBuildStatus) {
                applyMinMaxTh = JacocoPublisher.checkResult(action);
                logger.println("[JaCoCo plugin] Health thresholds: " + this.healthReports.toString());
                logger.println("[JaCoCo plugin] Apply Min/Max thresholds result: " + applyMinMaxTh.toString());
            }
            if (this.buildOverBuild) {
                applyDeltaTh = this.checkBuildOverBuildResult(run, logger);
                logger.println("[JaCoCo plugin] Delta thresholds: " + this.deltaHealthReport.toString());
                logger.println("[JaCoCo plugin] Results of delta thresholds check: " + applyDeltaTh.toString());
            }
            if (this.changeBuildStatus || this.buildOverBuild) {
                run.setResult(Utils.applyLogicalAnd(applyMinMaxTh, applyDeltaTh));
            }
        }
    }

    private boolean hasSubDirectories(String pattern) {
        for (String dir : pattern.split(DIR_SEP)) {
            if (!dir.endsWith("\\") && !dir.endsWith("/") && !dir.endsWith("\\*") && !dir.endsWith("/*") && !dir.endsWith("\\**") && !dir.endsWith("/**")) continue;
            return true;
        }
        return false;
    }

    private JacocoHealthReportThresholds createJacocoHealthReportThresholds(EnvVars env) {
        try {
            this.healthReports = new JacocoHealthReportThresholds(this.convertThresholdInputToInteger(this.minimumClassCoverage, env), this.convertThresholdInputToInteger(this.maximumClassCoverage, env), this.convertThresholdInputToInteger(this.minimumMethodCoverage, env), this.convertThresholdInputToInteger(this.maximumMethodCoverage, env), this.convertThresholdInputToInteger(this.minimumLineCoverage, env), this.convertThresholdInputToInteger(this.maximumLineCoverage, env), this.convertThresholdInputToInteger(this.minimumBranchCoverage, env), this.convertThresholdInputToInteger(this.maximumBranchCoverage, env), this.convertThresholdInputToInteger(this.minimumInstructionCoverage, env), this.convertThresholdInputToInteger(this.maximumInstructionCoverage, env), this.convertThresholdInputToInteger(this.minimumComplexityCoverage, env), this.convertThresholdInputToInteger(this.maximumComplexityCoverage, env));
            return this.healthReports;
        }
        catch (NumberFormatException e) {
            this.healthReports = new JacocoHealthReportThresholds(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
            return this.healthReports;
        }
    }

    private JacocoHealthReportDeltaThresholds createJacocoDeltaHealthReportThresholds() {
        return new JacocoHealthReportDeltaThresholds(this.deltaInstructionCoverage, this.deltaBranchCoverage, this.deltaComplexityCoverage, this.deltaLineCoverage, this.deltaMethodCoverage, this.deltaClassCoverage);
    }

    public static Result checkResult(JacocoBuildAction action) {
        if (action.getBranchCoverage().getPercentageFloat() < (float)action.getThresholds().getMinBranch() || action.getInstructionCoverage().getPercentageFloat() < (float)action.getThresholds().getMinInstruction() || action.getClassCoverage().getPercentageFloat() < (float)action.getThresholds().getMinClass() || action.getLineCoverage().getPercentageFloat() < (float)action.getThresholds().getMinLine() || action.getComplexityScore().getPercentageFloat() < (float)action.getThresholds().getMinComplexity() || action.getMethodCoverage().getPercentageFloat() < (float)action.getThresholds().getMinMethod()) {
            return Result.FAILURE;
        }
        if (action.getBranchCoverage().getPercentageFloat() < (float)action.getThresholds().getMaxBranch() || action.getInstructionCoverage().getPercentageFloat() < (float)action.getThresholds().getMaxInstruction() || action.getClassCoverage().getPercentageFloat() < (float)action.getThresholds().getMaxClass() || action.getLineCoverage().getPercentageFloat() < (float)action.getThresholds().getMaxLine() || action.getComplexityScore().getPercentageFloat() < (float)action.getThresholds().getMaxComplexity() || action.getMethodCoverage().getPercentageFloat() < (float)action.getThresholds().getMaxMethod()) {
            return Result.UNSTABLE;
        }
        return Result.SUCCESS;
    }

    public Result checkBuildOverBuildResult(Run<?, ?> run, PrintStream logger) {
        JacocoDeltaCoverageResultSummary deltaCoverageResultSummary = JacocoDeltaCoverageResultSummary.build(run);
        logger.println("[JaCoCo plugin] Delta coverage: class: " + deltaCoverageResultSummary.getClassCoverage() + ", method: " + deltaCoverageResultSummary.getMethodCoverage() + ", line: " + deltaCoverageResultSummary.getLineCoverage() + ", branch: " + deltaCoverageResultSummary.getBranchCoverage() + ", instruction: " + deltaCoverageResultSummary.getInstructionCoverage() + ", complexity: " + deltaCoverageResultSummary.getComplexityCoverage());
        if ((deltaCoverageResultSummary.getInstructionCoverage() > 0.0f || Math.abs(deltaCoverageResultSummary.getInstructionCoverage()) <= this.deltaHealthReport.getDeltaInstruction()) && (deltaCoverageResultSummary.getBranchCoverage() > 0.0f || Math.abs(deltaCoverageResultSummary.getBranchCoverage()) <= this.deltaHealthReport.getDeltaBranch()) && (deltaCoverageResultSummary.getComplexityCoverage() > 0.0f || Math.abs(deltaCoverageResultSummary.getComplexityCoverage()) <= this.deltaHealthReport.getDeltaComplexity()) && (deltaCoverageResultSummary.getLineCoverage() > 0.0f || Math.abs(deltaCoverageResultSummary.getLineCoverage()) <= this.deltaHealthReport.getDeltaLine()) && (deltaCoverageResultSummary.getMethodCoverage() > 0.0f || Math.abs(deltaCoverageResultSummary.getMethodCoverage()) <= this.deltaHealthReport.getDeltaMethod()) && (deltaCoverageResultSummary.getClassCoverage() > 0.0f || Math.abs(deltaCoverageResultSummary.getClassCoverage()) <= this.deltaHealthReport.getDeltaClass())) {
            return Result.SUCCESS;
        }
        return Result.FAILURE;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return super.getDescriptor();
    }

    private static void setDescriptor(BuildStepDescriptor<Publisher> descriptor) {
        DESCRIPTOR = descriptor;
    }

    private static class ResolveDirPaths
    extends MasterToSlaveFileCallable<FilePath[]> {
        static final long serialVersionUID = 1552178457453558870L;
        private final String input;

        public ResolveDirPaths(String input) {
            this.input = input;
        }

        public FilePath[] invoke(File f, VirtualChannel channel) throws IOException {
            String[] dirs;
            FilePath base = new FilePath(f);
            ArrayList<FilePath> localDirectoryPaths = new ArrayList<FilePath>();
            String[] includes = this.input.split(JacocoPublisher.DIR_SEP);
            DirectoryScanner ds = new DirectoryScanner();
            ds.setIncludes(includes);
            ds.setCaseSensitive(false);
            ds.setBasedir(f);
            ds.scan();
            for (String dir : dirs = ds.getIncludedDirectories()) {
                localDirectoryPaths.add(base.child(dir));
            }
            FilePath[] lfp = new FilePath[]{};
            return localDirectoryPaths.toArray(lfp);
        }
    }

    @Extension
    @Symbol(value={"jacoco"})
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(JacocoPublisher.class);
            JacocoPublisher.setDescriptor((BuildStepDescriptor<Publisher>)this);
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.JacocoPublisher_DisplayName();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }
    }
}

