/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jacoco;

public class JacocoHealthReportDeltaThresholds {
    private float deltaInstruction;
    private float deltaBranch;
    private float deltaComplexity;
    private float deltaLine;
    private float deltaMethod;
    private float deltaClass;

    public JacocoHealthReportDeltaThresholds() {
    }

    public JacocoHealthReportDeltaThresholds(String deltaInstruction, String deltaBranch, String deltaComplexity, String deltaLine, String deltaMethod, String deltaClass) {
        this.deltaInstruction = deltaInstruction != null ? Float.parseFloat(deltaInstruction) : 0.0f;
        this.deltaBranch = deltaBranch != null ? Float.parseFloat(deltaBranch) : 0.0f;
        this.deltaComplexity = deltaComplexity != null ? Float.parseFloat(deltaComplexity) : 0.0f;
        this.deltaLine = deltaLine != null ? Float.parseFloat(deltaLine) : 0.0f;
        this.deltaMethod = deltaMethod != null ? Float.parseFloat(deltaMethod) : 0.0f;
        this.deltaClass = deltaClass != null ? Float.parseFloat(deltaClass) : 0.0f;
        this.ensureValid();
    }

    private float applyRange(float min, float value, float max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public void ensureValid() {
        float min = 0.0f;
        float max = 100.0f;
        this.deltaInstruction = this.applyRange(min, this.deltaInstruction, max);
        this.deltaBranch = this.applyRange(min, this.deltaBranch, max);
        this.deltaComplexity = this.applyRange(min, this.deltaComplexity, max);
        this.deltaLine = this.applyRange(min, this.deltaLine, max);
        this.deltaMethod = this.applyRange(min, this.deltaMethod, max);
        this.deltaClass = this.applyRange(min, this.deltaClass, max);
    }

    public float getDeltaInstruction() {
        return this.deltaInstruction;
    }

    public void setDeltaInstruction(float deltaInstruction) {
        this.deltaInstruction = deltaInstruction;
    }

    public float getDeltaBranch() {
        return this.deltaBranch;
    }

    public void setDeltaBranch(float deltaBranch) {
        this.deltaBranch = deltaBranch;
    }

    public float getDeltaComplexity() {
        return this.deltaComplexity;
    }

    public void setDeltaComplexity(float deltaComplexity) {
        this.deltaComplexity = deltaComplexity;
    }

    public float getDeltaLine() {
        return this.deltaLine;
    }

    public void setDeltaLine(float deltaLine) {
        this.deltaLine = deltaLine;
    }

    public float getDeltaMethod() {
        return this.deltaMethod;
    }

    public void setDeltaMethod(float deltaMethod) {
        this.deltaMethod = deltaMethod;
    }

    public float getDeltaClass() {
        return this.deltaClass;
    }

    public void setDeltaClass(float deltaClass) {
        this.deltaClass = deltaClass;
    }

    public String toString() {
        return "JacocoHealthReportDeltaThresholds [deltaInstruction=" + this.deltaInstruction + ", deltaBranch=" + this.deltaBranch + ", deltaComplexity=" + this.deltaComplexity + ", deltaLine=" + this.deltaLine + ", deltaMethod=" + this.deltaMethod + ", deltaClass=" + this.deltaClass + ']';
    }
}

