/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jacoco;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.HealthReport;
import hudson.model.HealthReportingAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.jacoco.ExecutionFileLoader;
import hudson.plugins.jacoco.JacocoHealthReportThresholds;
import hudson.plugins.jacoco.JacocoProjectAction;
import hudson.plugins.jacoco.JacocoReportDir;
import hudson.plugins.jacoco.Messages;
import hudson.plugins.jacoco.model.Coverage;
import hudson.plugins.jacoco.model.CoverageElement;
import hudson.plugins.jacoco.model.CoverageObject;
import hudson.plugins.jacoco.report.CoverageReport;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import jenkins.model.RunAction2;
import jenkins.tasks.SimpleBuildStep;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jvnet.localizer.Localizable;
import org.kohsuke.stapler.StaplerProxy;

public final class JacocoBuildAction
extends CoverageObject<JacocoBuildAction>
implements HealthReportingAction,
StaplerProxy,
Serializable,
RunAction2,
SimpleBuildStep.LastBuildAction {
    private static final long serialVersionUID = 1L;
    private transient Run<?, ?> owner;
    @Deprecated
    public transient AbstractBuild<?, ?> build;
    private final transient PrintStream logger;
    @Deprecated
    private transient ArrayList<?> reports;
    private transient WeakReference<CoverageReport> report;
    private final String[] inclusions;
    private final String[] exclusions;
    private final JacocoHealthReportThresholds thresholds;
    private transient JacocoProjectAction jacocoProjectAction;

    public JacocoBuildAction(Map<CoverageElement.Type, Coverage> ratios, JacocoHealthReportThresholds thresholds, TaskListener listener, String[] inclusions, String[] exclusions) {
        this.logger = listener.getLogger();
        if (ratios == null) {
            ratios = Collections.emptyMap();
        }
        this.inclusions = inclusions != null ? Arrays.copyOf(inclusions, inclusions.length) : null;
        this.exclusions = exclusions != null ? Arrays.copyOf(exclusions, exclusions.length) : null;
        this.clazz = this.getOrCreateRatio(ratios, CoverageElement.Type.CLASS);
        this.method = this.getOrCreateRatio(ratios, CoverageElement.Type.METHOD);
        this.line = this.getOrCreateRatio(ratios, CoverageElement.Type.LINE);
        this.thresholds = thresholds;
        this.branch = this.getOrCreateRatio(ratios, CoverageElement.Type.BRANCH);
        this.instruction = this.getOrCreateRatio(ratios, CoverageElement.Type.INSTRUCTION);
        this.complexity = this.getOrCreateRatio(ratios, CoverageElement.Type.COMPLEXITY);
    }

    private Coverage getOrCreateRatio(Map<CoverageElement.Type, Coverage> ratios, CoverageElement.Type type) {
        Coverage r = ratios.get((Object)type);
        if (r == null) {
            r = new Coverage();
        }
        return r;
    }

    public String getDisplayName() {
        return Messages.BuildAction_DisplayName();
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getUrlName() {
        return "jacoco";
    }

    public HealthReport getBuildHealth() {
        float percent;
        if (this.thresholds == null) {
            return null;
        }
        this.thresholds.ensureValid();
        int score = 100;
        ArrayList<Localizable> reports = new ArrayList<Localizable>(5);
        if (this.clazz != null && this.thresholds.getMaxClass() > 0) {
            percent = this.clazz.getPercentageFloat();
            if (percent < (float)this.thresholds.getMaxClass()) {
                reports.add(Messages._BuildAction_Classes(this.clazz, Float.valueOf(percent)));
            }
            score = JacocoBuildAction.updateHealthScore(score, this.thresholds.getMinClass(), percent, this.thresholds.getMaxClass());
        }
        if (this.method != null && this.thresholds.getMaxMethod() > 0) {
            percent = this.method.getPercentageFloat();
            if (percent < (float)this.thresholds.getMaxMethod()) {
                reports.add(Messages._BuildAction_Methods(this.method, Float.valueOf(percent)));
            }
            score = JacocoBuildAction.updateHealthScore(score, this.thresholds.getMinMethod(), percent, this.thresholds.getMaxMethod());
        }
        if (this.line != null && this.thresholds.getMaxLine() > 0) {
            percent = this.line.getPercentageFloat();
            if (percent < (float)this.thresholds.getMaxLine()) {
                reports.add(Messages._BuildAction_Lines(this.line, Float.valueOf(percent)));
            }
            score = JacocoBuildAction.updateHealthScore(score, this.thresholds.getMinLine(), percent, this.thresholds.getMaxLine());
        }
        if (this.branch != null && this.thresholds.getMaxBranch() > 0) {
            percent = this.branch.getPercentageFloat();
            if (percent < (float)this.thresholds.getMaxBranch()) {
                reports.add(Messages._BuildAction_Branches(this.branch, Float.valueOf(percent)));
            }
            score = JacocoBuildAction.updateHealthScore(score, this.thresholds.getMinBranch(), percent, this.thresholds.getMaxBranch());
        }
        if (this.instruction != null && this.thresholds.getMaxInstruction() > 0) {
            percent = this.instruction.getPercentageFloat();
            if (percent < (float)this.thresholds.getMaxInstruction()) {
                reports.add(Messages._BuildAction_Instructions(this.instruction, Float.valueOf(percent)));
            }
            score = JacocoBuildAction.updateHealthScore(score, this.thresholds.getMinInstruction(), percent, this.thresholds.getMaxInstruction());
        }
        if (score == 100) {
            reports.add(Messages._BuildAction_Perfect());
        }
        Object[] args = reports.toArray(new Object[5]);
        for (int i = 4; i >= 0 && args[i] == null; --i) {
            args[i] = "";
        }
        return new HealthReport(score, Messages._BuildAction_Description(args[0], args[1], args[2], args[3], args[4]));
    }

    public JacocoHealthReportThresholds getThresholds() {
        return this.thresholds;
    }

    private static int updateHealthScore(int score, int min, float value, int max) {
        if (value >= (float)max) {
            return score;
        }
        if (value <= (float)min) {
            return 0;
        }
        assert (max != min);
        int scaled = (int)(100.0 * (double)(value - (float)min) / (double)(max - min));
        if (scaled < score) {
            return scaled;
        }
        return score;
    }

    public Object getTarget() {
        return this.getResult();
    }

    @Override
    public Run<?, ?> getBuild() {
        return this.owner;
    }

    public JacocoReportDir getJacocoReport() {
        return new JacocoReportDir(this.owner.getRootDir());
    }

    @Nullable
    public synchronized CoverageReport getResult() {
        CoverageReport r;
        if (this.report != null && (r = (CoverageReport)this.report.get()) != null) {
            return r;
        }
        JacocoReportDir reportFolder = this.getJacocoReport();
        try {
            CoverageReport r2 = new CoverageReport(this, reportFolder.parse(this.inclusions, this.exclusions));
            this.report = new WeakReference<CoverageReport>(r2);
            r2.setThresholds(this.thresholds);
            return r2;
        }
        catch (IOException | RuntimeException e) {
            this.getLogger().println("Failed to load " + reportFolder);
            e.printStackTrace(this.getLogger());
            return null;
        }
    }

    @Override
    public JacocoBuildAction getPreviousResult() {
        return JacocoBuildAction.getPreviousResult(this.owner);
    }

    public Map<Coverage, Boolean> getCoverageRatios() {
        CoverageReport result = this.getResult();
        LinkedHashMap<Coverage, Boolean> ratios = new LinkedHashMap<Coverage, Boolean>();
        if (result != null) {
            Coverage instructionCoverage = result.getInstructionCoverage();
            Coverage classCoverage = result.getClassCoverage();
            Coverage complexityScore = result.getComplexityScore();
            Coverage branchCoverage = result.getBranchCoverage();
            Coverage lineCoverage = result.getLineCoverage();
            Coverage methodCoverage = result.getMethodCoverage();
            instructionCoverage.setType(CoverageElement.Type.INSTRUCTION);
            classCoverage.setType(CoverageElement.Type.CLASS);
            complexityScore.setType(CoverageElement.Type.COMPLEXITY);
            branchCoverage.setType(CoverageElement.Type.BRANCH);
            lineCoverage.setType(CoverageElement.Type.LINE);
            methodCoverage.setType(CoverageElement.Type.METHOD);
            ratios.put(instructionCoverage, JacocoHealthReportThresholds.RESULT.BELOWMINIMUM == this.thresholds.getResultByTypeAndRatio(instructionCoverage));
            ratios.put(branchCoverage, JacocoHealthReportThresholds.RESULT.BELOWMINIMUM == this.thresholds.getResultByTypeAndRatio(branchCoverage));
            ratios.put(complexityScore, JacocoHealthReportThresholds.RESULT.BELOWMINIMUM == this.thresholds.getResultByTypeAndRatio(complexityScore));
            ratios.put(lineCoverage, JacocoHealthReportThresholds.RESULT.BELOWMINIMUM == this.thresholds.getResultByTypeAndRatio(lineCoverage));
            ratios.put(methodCoverage, JacocoHealthReportThresholds.RESULT.BELOWMINIMUM == this.thresholds.getResultByTypeAndRatio(methodCoverage));
            ratios.put(classCoverage, JacocoHealthReportThresholds.RESULT.BELOWMINIMUM == this.thresholds.getResultByTypeAndRatio(classCoverage));
        }
        return ratios;
    }

    static JacocoBuildAction getPreviousResult(Run<?, ?> start) {
        JacocoBuildAction r;
        Run b = start;
        do {
            if ((b = b.getPreviousBuild()) != null) continue;
            return null;
        } while (b.isBuilding() || b.getResult() == Result.FAILURE || b.getResult() == Result.ABORTED || (r = (JacocoBuildAction)b.getAction(JacocoBuildAction.class)) == null);
        return r;
    }

    public static JacocoBuildAction load(JacocoHealthReportThresholds thresholds, TaskListener listener, JacocoReportDir layout, String[] includes, String[] excludes) throws IOException {
        Map<CoverageElement.Type, Coverage> ratios = JacocoBuildAction.loadRatios(layout, includes, excludes);
        return new JacocoBuildAction(ratios, thresholds, listener, includes, excludes);
    }

    private static Map<CoverageElement.Type, Coverage> loadRatios(JacocoReportDir layout, String[] includes, String ... excludes) throws IOException {
        LinkedHashMap<CoverageElement.Type, Coverage> ratios = new LinkedHashMap<CoverageElement.Type, Coverage>();
        ExecutionFileLoader efl = layout.parse(includes, excludes);
        IBundleCoverage bundleCoverage = efl.getBundleCoverage();
        if (bundleCoverage == null) {
            return null;
        }
        Coverage ratio = new Coverage();
        ratio.accumulatePP(bundleCoverage.getClassCounter().getMissedCount(), bundleCoverage.getClassCounter().getCoveredCount());
        ratios.put(CoverageElement.Type.CLASS, ratio);
        ratio = new Coverage();
        ratio.accumulatePP(bundleCoverage.getBranchCounter().getMissedCount(), bundleCoverage.getBranchCounter().getCoveredCount());
        ratios.put(CoverageElement.Type.BRANCH, ratio);
        ratio = new Coverage();
        ratio.accumulatePP(bundleCoverage.getInstructionCounter().getMissedCount(), bundleCoverage.getInstructionCounter().getCoveredCount());
        ratios.put(CoverageElement.Type.INSTRUCTION, ratio);
        ratio = new Coverage();
        ratio.accumulatePP(bundleCoverage.getMethodCounter().getMissedCount(), bundleCoverage.getMethodCounter().getCoveredCount());
        ratios.put(CoverageElement.Type.METHOD, ratio);
        ratio = new Coverage();
        ratio.accumulatePP(bundleCoverage.getComplexityCounter().getMissedCount(), bundleCoverage.getComplexityCounter().getCoveredCount());
        ratios.put(CoverageElement.Type.COMPLEXITY, ratio);
        ratio = new Coverage();
        ratio.accumulatePP(bundleCoverage.getLineCounter().getMissedCount(), bundleCoverage.getLineCounter().getCoveredCount());
        ratios.put(CoverageElement.Type.LINE, ratio);
        return ratios;
    }

    public final PrintStream getLogger() {
        if (this.logger != null) {
            return this.logger;
        }
        return System.out;
    }

    public Run<?, ?> getOwner() {
        return this.owner;
    }

    private void setOwner(Run<?, ?> owner) {
        this.jacocoProjectAction = new JacocoProjectAction(owner.getParent());
        this.owner = owner;
    }

    public void onAttached(Run<?, ?> run) {
        this.setOwner(run);
    }

    public void onLoad(Run<?, ?> run) {
        this.setOwner(run);
    }

    public Collection<? extends Action> getProjectActions() {
        return this.jacocoProjectAction != null ? Collections.singletonList(this.jacocoProjectAction) : Collections.emptyList();
    }
}

