/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jacoco;

import hudson.FilePath;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.util.FileUtils;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.data.ExecutionDataReader;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.data.SessionInfoStore;

public class ExecutionFileLoader
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String[] STARSTAR = new String[]{"**"};
    private static final String[] ITEM_ZERO = new String[]{"{0}"};
    private String name;
    private FilePath srcDir;
    private FilePath classDir;
    private FilePath generatedHTMLsDir;
    private String[] includes;
    private String[] excludes;
    private transient ExecutionDataStore executionDataStore;
    private transient SessionInfoStore sessionInfoStore;
    private transient IBundleCoverage bundleCoverage;
    private ArrayList<FilePath> execFiles = new ArrayList();

    public void addExecFile(FilePath execFile) {
        this.execFiles.add(execFile);
    }

    public IBundleCoverage getBundleCoverage() {
        return this.bundleCoverage;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setBundleCoverage(IBundleCoverage bundleCoverage) {
        this.bundleCoverage = bundleCoverage;
    }

    public FilePath getGeneratedHTMLsDir() {
        return this.generatedHTMLsDir;
    }

    public void setGeneratedHTMLsDir(FilePath generatedHTMLsDir) {
        this.generatedHTMLsDir = generatedHTMLsDir;
    }

    public FilePath getSrcDir() {
        return this.srcDir;
    }

    public void setSrcDir(FilePath srcDir) {
        this.srcDir = srcDir;
    }

    public FilePath getClassDir() {
        return this.classDir;
    }

    public void setClassDir(FilePath classDir) {
        this.classDir = classDir;
    }

    private void loadExecutionData() throws IOException {
        this.executionDataStore = new ExecutionDataStore();
        this.sessionInfoStore = new SessionInfoStore();
        for (FilePath filePath : this.execFiles) {
            File executionDataFile = new File(filePath.getRemote());
            try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(executionDataFile));){
                ExecutionDataReader reader = new ExecutionDataReader((InputStream)inputStream);
                reader.setSessionInfoVisitor((ISessionInfoVisitor)this.sessionInfoStore);
                reader.setExecutionDataVisitor((IExecutionDataVisitor)this.executionDataStore);
                reader.read();
            }
            catch (IOException e) {
                throw new IOException("While reading execution data-file: " + executionDataFile, e);
            }
        }
    }

    private IBundleCoverage analyzeStructure() throws IOException {
        File classDirectory = new File(this.classDir.getRemote());
        if (!classDirectory.exists()) {
            return null;
        }
        CoverageBuilder coverageBuilder = new CoverageBuilder();
        Analyzer analyzer = new Analyzer(this.executionDataStore, (ICoverageVisitor)coverageBuilder);
        if (this.includes == null) {
            this.includes = STARSTAR;
        } else if (this.includes.length == 0) {
            this.includes = STARSTAR;
        } else if (this.includes.length == 1 && "".equals(this.includes[0])) {
            this.includes = STARSTAR;
        }
        if (this.excludes == null) {
            this.excludes = ITEM_ZERO;
        } else if (this.excludes.length == 0) {
            this.excludes = ITEM_ZERO;
        }
        try {
            List filesToAnalyze = FileUtils.getFiles((File)classDirectory, (String)String.join((CharSequence)",", this.includes), (String)String.join((CharSequence)",", this.excludes));
            for (File file : filesToAnalyze) {
                analyzer.analyzeAll(file);
            }
        }
        catch (IOException e) {
            throw new IOException("While reading class directory: " + classDirectory, e);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("While reading class directory: " + classDirectory, e);
        }
        return coverageBuilder.getBundle(this.name);
    }

    public IBundleCoverage loadBundleCoverage() throws IOException {
        this.loadExecutionData();
        this.bundleCoverage = this.analyzeStructure();
        return this.bundleCoverage;
    }

    public void setIncludes(String ... includes) {
        this.includes = includes;
    }

    public void setExcludes(String ... excludes) {
        this.excludes = excludes;
    }
}

