/*
 * Decompiled with CFR 0.152.
 */
package hudson.ivy;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.ivy.AbstractIvyBuild;
import hudson.ivy.FilteredChangeLogSet;
import hudson.ivy.IvyBuildProxy;
import hudson.ivy.IvyBuildProxy2;
import hudson.ivy.IvyBuilder;
import hudson.ivy.IvyModule;
import hudson.ivy.IvyModuleSetBuild;
import hudson.ivy.IvyReporter;
import hudson.ivy.Messages;
import hudson.ivy.SplittableBuildListener;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Environment;
import hudson.model.EnvironmentContributingAction;
import hudson.model.Executor;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.scm.ChangeLogSet;
import hudson.slaves.WorkspaceList;
import hudson.tasks.BuildWrapper;
import hudson.tasks.Publisher;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildEvent;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public class IvyBuild
extends AbstractIvyBuild<IvyModule, IvyBuild> {
    List<IvyReporter> projectActionReporters;
    public static boolean debug = false;

    public IvyBuild(IvyModule job) throws IOException {
        super(job);
    }

    public IvyBuild(IvyModule job, Calendar timestamp) {
        super(job, timestamp);
    }

    public IvyBuild(IvyModule project, File buildDir) throws IOException {
        super(project, buildDir);
    }

    public String getUpUrl() {
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req != null) {
            List ancs = req.getAncestors();
            for (int i = 1; i < ancs.size(); ++i) {
                if (((Ancestor)ancs.get(i)).getObject() != this || !(((Ancestor)ancs.get(i - 1)).getObject() instanceof IvyModuleSetBuild)) continue;
                return ((Ancestor)ancs.get(i - 1)).getUrl() + "/";
            }
        }
        return super.getUpUrl();
    }

    public String getDisplayName() {
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req != null) {
            List ancs = req.getAncestors();
            for (int i = 1; i < ancs.size(); ++i) {
                if (((Ancestor)ancs.get(i)).getObject() != this || !(((Ancestor)ancs.get(i - 1)).getObject() instanceof IvyModuleSetBuild)) continue;
                return this.getParent().getDisplayName();
            }
        }
        return super.getDisplayName();
    }

    public IvyModuleSetBuild getParentBuild() {
        return (IvyModuleSetBuild)this.getParent().getParent().getBuildByNumber(this.getNumber());
    }

    public IvyModuleSetBuild getModuleSetBuild() {
        return (IvyModuleSetBuild)this.getParent().getParent().getNearestOldBuild(this.getNumber());
    }

    public ChangeLogSet<? extends ChangeLogSet.Entry> getChangeSet() {
        return new FilteredChangeLogSet(this);
    }

    public boolean hasChangeSetComputed() {
        return true;
    }

    public void registerAsProjectAction(IvyReporter reporter) {
        if (this.projectActionReporters == null) {
            this.projectActionReporters = new ArrayList<IvyReporter>();
        }
        this.projectActionReporters.add(reporter);
    }

    public void run() {
        this.addAction((Action)new IvyModuleEnvironmentAction());
        this.run((Run.Runner)new RunnerImpl());
        ((IvyModule)this.getProject()).updateTransientActions();
        IvyModuleSetBuild parentBuild = this.getModuleSetBuild();
        if (parentBuild != null) {
            parentBuild.notifyModuleBuild(this);
        }
    }

    protected void setWorkspace(FilePath path) {
        super.setWorkspace(path);
    }

    public IvyModule getParent() {
        return (IvyModule)super.getParent();
    }

    static /* synthetic */ List access$500(IvyBuild x0) {
        return x0.buildEnvironments;
    }

    static /* synthetic */ List access$600(IvyBuild x0) {
        return x0.buildEnvironments;
    }

    static /* synthetic */ List access$700(IvyBuild x0) {
        return x0.buildEnvironments;
    }

    static /* synthetic */ List access$800(IvyBuild x0) {
        return x0.buildEnvironments;
    }

    public static class IvyModuleEnvironmentAction
    implements EnvironmentContributingAction {
        public String getUrlName() {
            return null;
        }

        public String getIconFileName() {
            return null;
        }

        public String getDisplayName() {
            return null;
        }

        public void buildEnvVars(AbstractBuild<?, ?> build, EnvVars env) {
            Job buildParent = build.getParent();
            env.put("IVY_MODULE_NAME", ((IvyModule)buildParent).getModuleName().name);
            env.put("IVY_MODULE_ORGANISATION", ((IvyModule)buildParent).getModuleName().organisation);
        }
    }

    private class RunnerImpl
    extends AbstractBuild.AbstractRunner {
        private List<Publisher> reporters;

        private RunnerImpl() {
            super((AbstractBuild)IvyBuild.this);
        }

        protected WorkspaceList.Lease decideWorkspace(Node n, WorkspaceList wsl) throws InterruptedException, IOException {
            String pathToModuleRoot = ((IvyModule)IvyBuild.this.getProject()).getRelativePathToModuleRoot();
            return wsl.allocate(IvyBuild.this.getModuleSetBuild().getWorkspace().child(pathToModuleRoot));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected Result doRun(BuildListener listener) throws Exception {
            block18: {
                block16: {
                    block17: {
                        this.reporters = ((IvyModule)IvyBuild.this.getProject()).createModulePublishers();
                        if (IvyBuild.debug) {
                            listener.getLogger().println("Reporters=" + this.reporters);
                        }
                        if (!this.preBuild(listener, this.reporters)) {
                            return Result.FAILURE;
                        }
                        r = null;
                        try {
                            wrappers = new ArrayList<E>(((IvyModule)IvyBuild.this.getProject()).getBuildWrappersList().toList());
                            parameters = (ParametersAction)IvyBuild.this.getAction(ParametersAction.class);
                            if (parameters != null) {
                                parameters.createBuildWrappers((AbstractBuild)IvyBuild.this, wrappers);
                            }
lbl12:
                            // 4 sources

                            for (BuildWrapper w : wrappers) {
                                e = w.setUp((AbstractBuild)IvyBuild.this, this.launcher, listener);
                                if (e == null) {
                                    var8_10 = r = Result.FAILURE;
                                    if (r == null) break block16;
                                    break block17;
                                }
                                ** GOTO lbl-1000
                            }
                            ** GOTO lbl45
                        }
                        catch (Throwable var11_13) {
                            if (r != null) {
                                IvyBuild.this.setResult(r);
                            }
                            failed = false;
                            for (i = IvyBuild.access$700(IvyBuild.this).size() - 1; i >= 0; --i) {
                                if (((Environment)IvyBuild.access$800(IvyBuild.this).get(i)).tearDown((AbstractBuild)IvyBuild.this, listener)) continue;
                                failed = true;
                            }
                            if (failed) {
                                return Result.FAILURE;
                            }
                            throw var11_13;
                        }
                    }
                    IvyBuild.this.setResult(r);
                }
                failed = false;
                for (i = IvyBuild.access$700(IvyBuild.this).size() - 1; i >= 0; --i) {
                    if (((Environment)IvyBuild.access$800(IvyBuild.this).get(i)).tearDown((AbstractBuild)IvyBuild.this, listener)) continue;
                    failed = true;
                }
                if (failed) {
                    return Result.FAILURE;
                }
                return var8_10;
lbl-1000:
                // 1 sources

                {
                    IvyBuild.access$500(IvyBuild.this).add(e);
                    ** GOTO lbl12
lbl45:
                    // 1 sources

                    builder = ((IvyModule)IvyBuild.this.getProject()).getParent().getIvyBuilderType().getBuilder(null, ((IvyModule)IvyBuild.this.getProject()).getTargets(), IvyBuild.access$600(IvyBuild.this));
                    if (!builder.perform((AbstractBuild)IvyBuild.this, this.launcher, listener)) {
                        r = Result.FAILURE;
                    }
                    if (r == null) break block18;
                }
                IvyBuild.this.setResult(r);
            }
            failed = false;
            for (i = IvyBuild.access$700(IvyBuild.this).size() - 1; i >= 0; --i) {
                if (((Environment)IvyBuild.access$800(IvyBuild.this).get(i)).tearDown((AbstractBuild)IvyBuild.this, listener)) continue;
                failed = true;
            }
            if (failed) {
                return Result.FAILURE;
            }
            return r;
        }

        public void post2(BuildListener listener) throws Exception {
            if (!this.performAllBuildSteps(listener, this.reporters, true)) {
                IvyBuild.this.setResult(Result.FAILURE);
            }
            if (!this.performAllBuildSteps(listener, ((IvyModule)IvyBuild.this.project).getProperties(), true)) {
                IvyBuild.this.setResult(Result.FAILURE);
            }
        }

        public void cleanUp(BuildListener listener) throws Exception {
            super.cleanUp(listener);
            this.performAllBuildSteps(listener, this.reporters, false);
            this.performAllBuildSteps(listener, ((IvyModule)IvyBuild.this.project).getProperties(), false);
            IvyBuild.this.scheduleDownstreamBuilds(listener);
        }
    }

    class ProxyImpl2
    extends ProxyImpl
    implements IvyBuildProxy2 {
        private final SplittableBuildListener listener;
        long startTime;
        private final OutputStream log;
        private final IvyModuleSetBuild parentBuild;

        ProxyImpl2(IvyModuleSetBuild parentBuild, SplittableBuildListener listener) throws FileNotFoundException {
            this.parentBuild = parentBuild;
            this.listener = listener;
            this.log = new FileOutputStream(IvyBuild.this.getLogFile());
        }

        @Override
        public void start() {
            IvyBuild.this.onStartBuilding();
            this.startTime = System.currentTimeMillis();
            try {
                this.listener.setSideOutputStream(this.log);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void end() {
            if (IvyBuild.this.result == null) {
                this.setResult(Result.SUCCESS);
            }
            IvyBuild.this.onEndBuilding();
            IvyBuild.this.duration = System.currentTimeMillis() - this.startTime;
            this.parentBuild.notifyModuleBuild(IvyBuild.this);
            try {
                this.listener.setSideOutputStream(null);
                IvyBuild.this.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void appendLastLog() {
            try {
                this.listener.setSideOutputStream(this.log);
                this.listener.setSideOutputStream(null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        protected void close() {
            try {
                this.log.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (IvyBuild.this.hasntStartedYet()) {
                IvyBuild.this.run(new Run.Runner(){

                    public Result run(BuildListener listener) {
                        listener.getLogger().println(Messages.IvyBuild_FailedEarlier());
                        return Result.NOT_BUILT;
                    }

                    public void post(BuildListener listener) {
                    }

                    public void cleanUp(BuildListener listener) {
                    }
                });
            }
        }

        public IvyBuild owner() {
            return IvyBuild.this;
        }

        private Object writeReplace() {
            return Channel.current().export(IvyBuildProxy2.class, (Object)((IvyBuildProxy2)Executor.currentExecutor().newImpersonatingProxy(IvyBuildProxy2.class, (Object)this)));
        }
    }

    class ProxyImpl
    implements IvyBuildProxy,
    Serializable {
        ProxyImpl() {
        }

        @Override
        public <V, T extends Throwable> V execute(IvyBuildProxy.BuildCallable<V, T> program) throws T, IOException, InterruptedException {
            return program.call(IvyBuild.this);
        }

        @Override
        @Deprecated
        public final void executeAsync(IvyBuildProxy.BuildCallable<?, ?> program) throws IOException {
            throw new AssertionError();
        }

        @Override
        public FilePath getRootDir() {
            return new FilePath(IvyBuild.this.getRootDir());
        }

        @Override
        public FilePath getProjectRootDir() {
            return new FilePath(IvyBuild.this.getParent().getRootDir());
        }

        @Override
        public FilePath getModuleSetRootDir() {
            return new FilePath(IvyBuild.this.getParent().getParent().getRootDir());
        }

        @Override
        public FilePath getArtifactsDir() {
            return new FilePath(IvyBuild.this.getArtifactsDir());
        }

        @Override
        public void setResult(Result result) {
            IvyBuild.this.setResult(result);
        }

        @Override
        public Calendar getTimestamp() {
            return IvyBuild.this.getTimestamp();
        }

        @Override
        public long getMilliSecsSinceBuildStart() {
            return System.currentTimeMillis() - this.getTimestamp().getTimeInMillis();
        }

        @Override
        public boolean isArchivingDisabled() {
            return IvyBuild.this.getParent().getParent().isArchivingDisabled();
        }

        @Override
        public void registerAsProjectAction(IvyReporter reporter) {
            IvyBuild.this.registerAsProjectAction(reporter);
        }

        @Override
        public void registerAsAggregatedProjectAction(IvyReporter reporter) {
            IvyModuleSetBuild pb = IvyBuild.this.getParentBuild();
            if (pb != null) {
                pb.registerAsProjectAction(reporter);
            }
        }

        private Object writeReplace() {
            return Channel.current().export(IvyBuildProxy.class, (Object)this);
        }
    }

    private static final class Builder
    extends IvyBuilder {
        private final IvyBuildProxy buildProxy;
        private final IvyReporter[] reporters;
        private long startTime;
        private static final long serialVersionUID = 1L;

        public Builder(BuildListener listener, IvyBuildProxy buildProxy, IvyReporter[] reporters, List<String> goals, Map<String, String> systemProps) {
            super(listener, goals, systemProps);
            this.buildProxy = new FilterImpl(buildProxy);
            this.reporters = reporters;
        }

        @Override
        void preBuild(BuildEvent event) throws IOException, InterruptedException {
            for (IvyReporter r : this.reporters) {
                r.preBuild(this.buildProxy, event, this.listener);
            }
        }

        @Override
        void postBuild(BuildEvent event) throws IOException, InterruptedException {
            for (IvyReporter r : this.reporters) {
                r.postBuild(this.buildProxy, event, this.listener);
            }
        }

        @Override
        void preModule(BuildEvent event) throws InterruptedException, IOException {
            for (IvyReporter r : this.reporters) {
                if (r.enterModule(this.buildProxy, event, this.listener)) continue;
                throw new AbortException(r + " failed");
            }
        }

        @Override
        void postModule(BuildEvent event) throws InterruptedException, IOException {
            for (IvyReporter r : this.reporters) {
                if (r.leaveModule(this.buildProxy, event, this.listener)) continue;
                throw new AbortException(r + " failed");
            }
        }

        private class FilterImpl
        extends IvyBuildProxy.Filter<IvyBuildProxy>
        implements Serializable {
            private static final long serialVersionUID = 1L;

            public FilterImpl(IvyBuildProxy buildProxy) {
                super(buildProxy);
            }

            @Override
            public void executeAsync(IvyBuildProxy.BuildCallable<?, ?> program) throws IOException {
                Builder.this.futures.add(Channel.current().callAsync((Callable)new IvyBuildProxy.Filter.AsyncInvoker(this.core, program)));
            }
        }
    }
}

