/*
 * Decompiled with CFR 0.152.
 */
package hudson.ivy;

import hudson.ivy.Messages;
import hudson.model.Result;
import hudson.remoting.DelegatingCallable;
import hudson.remoting.Future;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;

public abstract class IvyBuilder
extends MasterToSlaveCallable<Result, IOException>
implements DelegatingCallable<Result, IOException> {
    private final List<String> goals;
    private final Map<String, String> systemProps;
    protected final hudson.model.BuildListener listener;
    protected transient List<Future<?>> futures;
    private static final long serialVersionUID = 1L;

    protected IvyBuilder(hudson.model.BuildListener listener, List<String> goals, Map<String, String> systemProps) {
        this.listener = listener;
        this.goals = goals;
        this.systemProps = systemProps;
    }

    abstract void preBuild(BuildEvent var1) throws IOException, InterruptedException;

    abstract void postBuild(BuildEvent var1) throws IOException, InterruptedException;

    abstract void preModule(BuildEvent var1) throws InterruptedException, IOException;

    abstract void postModule(BuildEvent var1) throws InterruptedException, IOException;

    public Result call() throws IOException {
        this.futures = new ArrayList();
        Adapter a = new Adapter(this);
        System.getProperties().putAll(this.systemProps);
        this.listener.getLogger().println(this.formatArgs(this.goals));
        boolean messageReported = false;
        long startTime = System.nanoTime();
        for (Future<?> f : this.futures) {
            try {
                if (!f.isDone() && !messageReported) {
                    messageReported = true;
                    this.listener.getLogger().println(Messages.IvyBuilder_Waiting());
                }
                f.get();
            }
            catch (InterruptedException e) {
                for (Future<?> g : this.futures) {
                    g.cancel(true);
                }
                this.listener.getLogger().println(Messages.IvyBuilder_Aborted());
                return Result.ABORTED;
            }
            catch (ExecutionException executionException) {
            }
        }
        a.overheadTime += System.nanoTime() - startTime;
        this.futures.clear();
        this.listener.getLogger().println(Messages.IvyBuilder_Failed());
        return Result.FAILURE;
    }

    private String formatArgs(List<String> args) {
        StringBuilder buf = new StringBuilder("Executing Ant: ");
        for (String arg : args) {
            buf.append(' ').append(arg);
        }
        return buf.toString();
    }

    private String format(NumberFormat n, long nanoTime) {
        return n.format(nanoTime / 1000000L);
    }

    public ClassLoader getClassLoader() {
        return Jenkins.get().getPluginManager().uberClassLoader;
    }

    private static final class Adapter
    implements BuildListener {
        private final IvyBuilder listener;
        long overheadTime;

        public Adapter(IvyBuilder listener) {
            this.listener = listener;
        }

        public void buildFinished(BuildEvent event) {
            long startTime = System.nanoTime();
            try {
                this.listener.postBuild(event);
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
            }
            this.overheadTime += System.nanoTime() - startTime;
        }

        public void buildStarted(BuildEvent event) {
            long startTime = System.nanoTime();
            try {
                this.listener.preBuild(event);
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
            }
            this.overheadTime += System.nanoTime() - startTime;
        }

        public void messageLogged(BuildEvent event) {
        }

        public void targetFinished(BuildEvent event) {
        }

        public void targetStarted(BuildEvent event) {
        }

        public void taskFinished(BuildEvent event) {
        }

        public void taskStarted(BuildEvent event) {
        }
    }
}

