/*
 * Decompiled with CFR 0.152.
 */
package hudson.ivy;

import hudson.ivy.IvyBuild;
import hudson.ivy.IvyModuleSetBuild;
import hudson.model.AbstractBuild;
import hudson.scm.ChangeLogSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class FilteredChangeLogSet
extends ChangeLogSet<ChangeLogSet.Entry> {
    private final List<ChangeLogSet.Entry> master;
    public final ChangeLogSet<? extends ChangeLogSet.Entry> core;

    FilteredChangeLogSet(IvyBuild build) {
        super((AbstractBuild)build);
        IvyModuleSetBuild parentBuild = build.getParentBuild();
        if (parentBuild == null) {
            this.core = ChangeLogSet.createEmpty((AbstractBuild)build);
            this.master = Collections.emptyList();
        } else {
            this.core = parentBuild.getChangeSet();
            this.master = parentBuild.getChangeSetFor(build.getParent());
        }
    }

    public Iterator<ChangeLogSet.Entry> iterator() {
        return this.master.iterator();
    }

    public boolean isEmptySet() {
        return this.master.isEmpty();
    }

    public List<ChangeLogSet.Entry> getLogs() {
        return this.master;
    }
}

