/*
 * Decompiled with CFR 0.152.
 */
package hudson.ivy;

import java.io.Serializable;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;

public class ModuleName
implements Comparable<ModuleName>,
Serializable {
    public final String organisation;
    public final String name;
    private static final long serialVersionUID = 1L;

    public ModuleName(String organisation, String name) {
        this.organisation = organisation;
        this.name = name;
    }

    public ModuleName(ModuleDescriptor module) {
        this(module.getModuleRevisionId().getOrganisation(), module.getModuleRevisionId().getName());
    }

    public ModuleName(DependencyDescriptor dep) {
        this(dep.getDependencyId().getOrganisation(), dep.getDependencyId().getName());
    }

    public String toString() {
        return this.organisation + ":" + this.name;
    }

    public String toFileSystemName() {
        return this.organisation + "$" + this.name;
    }

    public static ModuleName fromFileSystemName(String n) {
        int idx = n.indexOf(36);
        if (idx < 0) {
            throw new IllegalArgumentException(n);
        }
        return new ModuleName(n.substring(0, idx), n.substring(idx + 1));
    }

    public static ModuleName fromString(String n) {
        int idx = Math.max(n.indexOf(58), n.indexOf(36));
        if (idx < 0) {
            throw new IllegalArgumentException(n);
        }
        return new ModuleName(n.substring(0, idx), n.substring(idx + 1));
    }

    public static boolean isValid(String n) {
        return Math.max(n.indexOf(58), n.indexOf(36)) > 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModuleName that = (ModuleName)o;
        return this.name.equals(that.name) && this.organisation.equals(that.organisation);
    }

    public int hashCode() {
        int result = this.organisation.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    @Override
    public int compareTo(ModuleName that) {
        int r = this.organisation.compareTo(that.organisation);
        if (r != 0) {
            return r;
        }
        return this.name.compareTo(that.name);
    }
}

